/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities.state;

import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class DefaultServiceCalculatedState
implements ServiceCalculatedState {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCalculatedState.class);
    @Inject
    private static Provider<Clusters> clustersProvider;
    @Inject
    static Provider<OBDPManagementController> managementControllerProvider;

    protected State getHostComponentState(ServiceComponentHostResponse hostComponent) {
        return State.valueOf(hostComponent.getLiveState());
    }

    protected Cluster getCluster(String clusterName) throws OBDPException {
        Clusters clusters;
        if (clustersProvider != null && clusterName != null && clusterName.length() > 0 && (clusters = (Clusters)clustersProvider.get()) != null) {
            return clusters.getCluster(clusterName);
        }
        return null;
    }

    @Override
    public State getState(String clusterName, String serviceName) {
        try {
            Cluster cluster = this.getCluster(clusterName);
            if (cluster != null && managementControllerProvider != null) {
                Service service = cluster.getService(serviceName);
                OBDPMetaInfo obdpMetaInfo = ((OBDPManagementController)managementControllerProvider.get()).getAmbariMetaInfo();
                StackId stackId = service.getDesiredStackId();
                ServiceComponentHostRequest request = new ServiceComponentHostRequest(clusterName, serviceName, null, null, null);
                Set<ServiceComponentHostResponse> hostComponentResponses = ((OBDPManagementController)managementControllerProvider.get()).getHostComponents(Collections.singleton(request), true);
                State masterState = null;
                State clientState = null;
                State otherState = null;
                State maxMMState = null;
                boolean hasDisabled = false;
                boolean hasMaster = false;
                boolean hasOther = false;
                boolean hasClient = false;
                boolean hasMM = false;
                for (ServiceComponentHostResponse hostComponentResponse : hostComponentResponses) {
                    try {
                        boolean isInMaintenance;
                        ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), hostComponentResponse.getServiceName(), hostComponentResponse.getComponentName());
                        State state = this.getHostComponentState(hostComponentResponse);
                        boolean bl = isInMaintenance = !MaintenanceState.OFF.toString().equals(hostComponentResponse.getMaintenanceState());
                        if (state.equals((Object)State.DISABLED)) {
                            hasDisabled = true;
                        }
                        if (isInMaintenance && !componentInfo.isClient()) {
                            hasMM = true;
                            if (maxMMState == null || state.ordinal() > maxMMState.ordinal()) {
                                maxMMState = state;
                            }
                        }
                        if (componentInfo.isMaster()) {
                            if (state.equals((Object)State.STARTED) || !isInMaintenance) {
                                hasMaster = true;
                            }
                            if (state.equals((Object)State.STARTED) || isInMaintenance || masterState != null && state.ordinal() <= masterState.ordinal()) continue;
                            masterState = state;
                            continue;
                        }
                        if (componentInfo.isClient()) {
                            hasClient = true;
                            if (state.equals((Object)State.INSTALLED) || clientState != null && state.ordinal() <= clientState.ordinal()) continue;
                            clientState = state;
                            continue;
                        }
                        if (state.equals((Object)State.STARTED) || !isInMaintenance) {
                            hasOther = true;
                        }
                        if (state.equals((Object)State.STARTED) || isInMaintenance || otherState != null && state.ordinal() <= otherState.ordinal()) continue;
                        otherState = state;
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {}
                }
                return hasMaster ? (masterState == null ? State.STARTED : masterState) : (hasOther ? (otherState == null ? State.STARTED : otherState) : (hasClient ? (clientState == null ? State.INSTALLED : clientState) : (hasDisabled ? State.DISABLED : (hasMM ? maxMMState : State.UNKNOWN))));
            }
        }
        catch (OBDPException e) {
            LOG.error("Can't determine service state.", (Throwable)e);
        }
        return State.UNKNOWN;
    }
}

