/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class UsedIdentities {
    private final List<KerberosIdentityDescriptor> used;

    public static UsedIdentities none() throws OBDPException {
        return new UsedIdentities(Collections.emptyList());
    }

    public static UsedIdentities populate(Cluster cluster, ServiceExclude serviceExclude, ComponentExclude componentExclude, KerberosHelper kerberosHelper) throws OBDPException {
        ArrayList<KerberosIdentityDescriptor> result = new ArrayList<KerberosIdentityDescriptor>();
        KerberosDescriptor root = kerberosHelper.getKerberosDescriptor(cluster, false);
        result.addAll(AbstractKerberosDescriptor.nullToEmpty(root.getIdentities()));
        for (Service service : cluster.getServices().values()) {
            KerberosServiceDescriptor serviceDescriptor;
            if (serviceExclude.shouldExclude(service.getName()) || (serviceDescriptor = root.getService(service.getName())) == null) continue;
            result.addAll(AbstractKerberosDescriptor.nullToEmpty(serviceDescriptor.getIdentities()));
            result.addAll(AbstractKerberosDescriptor.nullToEmpty(UsedIdentities.componentIdentities(serviceDescriptor, service, componentExclude)));
        }
        return new UsedIdentities(result);
    }

    private static List<KerberosIdentityDescriptor> componentIdentities(KerberosServiceDescriptor serviceDescriptor, Service service, ComponentExclude componentExclude) {
        return service.getServiceComponents().values().stream().filter(component -> !UsedIdentities.isComponentExcluded(service, componentExclude, component)).flatMap(component -> serviceDescriptor.getComponentIdentities(component.getName()).stream()).collect(Collectors.toList());
    }

    private static boolean isComponentExcluded(Service service, ComponentExclude componentExclude, ServiceComponent component) {
        return component.getServiceComponentHosts().isEmpty() || componentExclude.shouldExclude(service.getName(), component.getName(), component.getServiceComponentHosts().values());
    }

    private UsedIdentities(List<KerberosIdentityDescriptor> used) {
        this.used = used;
    }

    public boolean contains(KerberosIdentityDescriptor identity) {
        return this.used.stream().anyMatch(each -> identity.isShared((KerberosIdentityDescriptor)each));
    }

    public static interface ServiceExclude {
        public static final ServiceExclude NONE = serviceName -> false;

        public boolean shouldExclude(String var1);
    }

    public static interface ComponentExclude {
        public static final ComponentExclude NONE = (serviceName, componentName, hosts) -> false;

        public boolean shouldExclude(String var1, String var2, Collection<ServiceComponentHost> var3);
    }
}

