/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import id.onyx.obdp.server.controller.utilities.state.DefaultServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.FlumeServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.HBaseServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.HDFSServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.HiveServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.OozieServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.YARNServiceCalculatedState;
import id.onyx.obdp.server.state.Service;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCalculatedStateFactory {
    private static final ServiceCalculatedState DEFAULT_SERVICE_CALCULATED_STATE = new DefaultServiceCalculatedState();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCalculatedStateFactory.class);
    private static final Map<Service.Type, ServiceCalculatedState> serviceStateProviders = new ConcurrentHashMap<Service.Type, ServiceCalculatedState>();

    public static ServiceCalculatedState getServiceStateProvider(String service) {
        ServiceCalculatedState suggestedServiceProvider;
        Service.Type serviceType = null;
        try {
            serviceType = Service.Type.valueOf(service);
        }
        catch (Exception e) {
            LOG.debug("Could not parse service name \"{}\", will use default state provider", (Object)service);
        }
        if (serviceType == null) {
            return DEFAULT_SERVICE_CALCULATED_STATE;
        }
        if (serviceStateProviders.containsKey((Object)serviceType)) {
            suggestedServiceProvider = serviceStateProviders.get((Object)serviceType);
        } else {
            switch (serviceType) {
                case HDFS: {
                    suggestedServiceProvider = new HDFSServiceCalculatedState();
                    break;
                }
                case FLUME: {
                    suggestedServiceProvider = new FlumeServiceCalculatedState();
                    break;
                }
                case OOZIE: {
                    suggestedServiceProvider = new OozieServiceCalculatedState();
                    break;
                }
                case YARN: {
                    suggestedServiceProvider = new YARNServiceCalculatedState();
                    break;
                }
                case HIVE: {
                    suggestedServiceProvider = new HiveServiceCalculatedState();
                    break;
                }
                case HBASE: {
                    suggestedServiceProvider = new HBaseServiceCalculatedState();
                    break;
                }
                default: {
                    suggestedServiceProvider = DEFAULT_SERVICE_CALCULATED_STATE;
                }
            }
            serviceStateProviders.put(serviceType, suggestedServiceProvider);
        }
        return suggestedServiceProvider;
    }
}

