/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.utilities.UsedIdentities;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.ServiceRemovedEvent;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RemovableIdentities {
    private final List<KerberosIdentityDescriptor> candidateIdentities;
    private final UsedIdentities usedIdentities;
    private final Cluster cluster;
    private final List<Component> components;

    public static RemovableIdentities ofService(Cluster cluster, ServiceRemovedEvent event, KerberosHelper kerberosHelper) throws OBDPException {
        if (cluster.getSecurityType() != SecurityType.KERBEROS) {
            return RemovableIdentities.none();
        }
        KerberosServiceDescriptor serviceDescriptor = kerberosHelper.getKerberosDescriptor(cluster, false).getService(event.getServiceName());
        if (serviceDescriptor == null) {
            return RemovableIdentities.none();
        }
        UsedIdentities usedIdentities = UsedIdentities.populate(cluster, RemovableIdentities.excludeService(event.getServiceName()), UsedIdentities.ComponentExclude.NONE, kerberosHelper);
        return new RemovableIdentities(serviceDescriptor.getIdentitiesSkipReferences(), usedIdentities, cluster, event.getComponents());
    }

    public static RemovableIdentities ofComponent(Cluster cluster, ServiceComponentUninstalledEvent event, KerberosHelper kerberosHelper) throws OBDPException {
        if (cluster.getSecurityType() != SecurityType.KERBEROS) {
            return RemovableIdentities.none();
        }
        KerberosServiceDescriptor serviceDescriptor = kerberosHelper.getKerberosDescriptor(cluster, false).getService(event.getServiceName());
        if (serviceDescriptor == null) {
            return RemovableIdentities.none();
        }
        UsedIdentities usedIdentities = UsedIdentities.populate(cluster, UsedIdentities.ServiceExclude.NONE, RemovableIdentities.excludeComponent(event.getServiceName(), event.getComponentName(), event.getHostName()), kerberosHelper);
        return new RemovableIdentities(RemovableIdentities.componentIdentities(Collections.singletonList(event.getComponentName()), serviceDescriptor), usedIdentities, cluster, Collections.singletonList(event.getComponent()));
    }

    public static RemovableIdentities none() throws OBDPException {
        return new RemovableIdentities(Collections.emptyList(), UsedIdentities.none(), null, null);
    }

    private static UsedIdentities.ServiceExclude excludeService(String excludedServiceName) {
        return serviceName -> excludedServiceName.equals(serviceName);
    }

    private static UsedIdentities.ComponentExclude excludeComponent(String excludedServiceName, String excludedComponentName, String excludedHostName) {
        return (serviceName, componentName, hosts) -> excludedServiceName.equals(serviceName) && excludedComponentName.equals(componentName) && RemovableIdentities.hostNames(hosts).equals(Collections.singletonList(excludedHostName));
    }

    private static List<String> hostNames(Collection<ServiceComponentHost> hosts) {
        return hosts.stream().map(ServiceComponentHost::getHostName).collect(Collectors.toList());
    }

    private static List<KerberosIdentityDescriptor> componentIdentities(List<String> componentNames, KerberosServiceDescriptor serviceDescriptor) throws OBDPException {
        return componentNames.stream().map(componentName -> serviceDescriptor.getComponent((String)componentName)).filter(Objects::nonNull).flatMap(componentDescriptor -> componentDescriptor.getIdentitiesSkipReferences().stream()).collect(Collectors.toList());
    }

    private RemovableIdentities(List<KerberosIdentityDescriptor> candidateIdentities, UsedIdentities usedIdentities, Cluster cluster, List<Component> components) {
        this.candidateIdentities = candidateIdentities;
        this.usedIdentities = usedIdentities;
        this.cluster = cluster;
        this.components = components;
    }

    public void remove(KerberosHelper kerberosHelper) throws OBDPException, KerberosOperationException {
        kerberosHelper.deleteIdentities(this.cluster, this.components, null);
    }

    private List<KerberosIdentityDescriptor> skipUsed() throws OBDPException {
        return this.candidateIdentities.stream().filter(each -> !this.usedIdentities.contains((KerberosIdentityDescriptor)each)).collect(Collectors.toList());
    }
}

