/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PropertyHelper {
    private static final String GANGLIA_PROPERTIES_FILE = "ganglia_properties.json";
    private static final String SQLSERVER_PROPERTIES_FILE = "sqlserver_properties.json";
    private static final String JMX_PROPERTIES_FILE = "jmx_properties.json";
    public static final char EXTERNAL_PATH_SEP = '/';
    public static final List<String> AGGREGATE_FUNCTION_IDENTIFIERS = ImmutableList.of((Object)"._sum", (Object)"._max", (Object)"._min", (Object)"._avg", (Object)"._rate");
    private static final List<Resource.InternalType> REPORT_METRIC_RESOURCES = ImmutableList.of((Object)((Object)Resource.InternalType.Cluster), (Object)((Object)Resource.InternalType.Host));
    private static final Map<Resource.InternalType, Set<String>> PROPERTY_IDS = new HashMap<Resource.InternalType, Set<String>>();
    private static final Map<Resource.InternalType, Map<String, Map<String, PropertyInfo>>> JMX_PROPERTY_IDS = PropertyHelper.readPropertyProviderIds("jmx_properties.json");
    private static final Map<Resource.InternalType, Map<String, Map<String, PropertyInfo>>> GANGLIA_PROPERTY_IDS = PropertyHelper.readPropertyProviderIds("ganglia_properties.json");
    private static final Map<Resource.InternalType, Map<String, Map<String, PropertyInfo>>> SQLSERVER_PROPERTY_IDS = PropertyHelper.readPropertyProviderIds("sqlserver_properties.json");
    private static final Map<Resource.InternalType, Map<Resource.Type, String>> KEY_PROPERTY_IDS = new HashMap<Resource.InternalType, Map<Resource.Type, String>>();
    private static final Map<String, List<String>> RPC_METRIC_SUFFIXES = new HashMap<String, List<String>>();
    private static final Pattern CHECK_FOR_METRIC_ARGUMENTS_REGEX = Pattern.compile(".*\\$\\d+.*");
    private static final Pattern METRIC_CATEGORY_TOKENIZE_REGEX = Pattern.compile("/+(?=([^\"\\\\\\\\]*(\\\\\\\\.|\"([^\"\\\\\\\\]*\\\\\\\\.)*[^\"\\\\\\\\]*\"))*[^\"]*$)");

    public static String getPropertyId(String category, String name) {
        String propertyId;
        String string = category == null || category.isEmpty() ? name : (propertyId = name == null || name.isEmpty() ? category : category + "/" + name);
        if (propertyId.endsWith("/")) {
            propertyId = propertyId.substring(0, propertyId.length() - 1);
        }
        return propertyId;
    }

    public static Set<String> getPropertyIds(Resource.Type resourceType) {
        Set<String> propertyIds = PROPERTY_IDS.get((Object)resourceType.getInternalType());
        return propertyIds == null ? Collections.emptySet() : propertyIds;
    }

    public static void setPropertyIds(Resource.Type resourceType, Set<String> propertyIds) {
        PROPERTY_IDS.put(resourceType.getInternalType(), propertyIds);
    }

    public static Set<String> getPropertyIds(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap) {
        HashSet<String> propertyIds = new HashSet<String>();
        for (Map.Entry<String, Map<String, PropertyInfo>> entry : componentPropertyInfoMap.entrySet()) {
            propertyIds.addAll(entry.getValue().keySet());
        }
        return propertyIds;
    }

    public static Map<String, Map<String, PropertyInfo>> getMetricPropertyIds(Resource.Type resourceType) {
        return GANGLIA_PROPERTY_IDS.get((Object)resourceType.getInternalType());
    }

    public static Map<String, Map<String, PropertyInfo>> getSQLServerPropertyIds(Resource.Type resourceType) {
        return SQLSERVER_PROPERTY_IDS.get((Object)resourceType.getInternalType());
    }

    public static Map<String, Map<String, PropertyInfo>> getJMXPropertyIds(Resource.Type resourceType) {
        return JMX_PROPERTY_IDS.get((Object)resourceType.getInternalType());
    }

    public static Map<Resource.Type, String> getKeyPropertyIds(Resource.Type resourceType) {
        return KEY_PROPERTY_IDS.get((Object)resourceType.getInternalType());
    }

    public static void setKeyPropertyIds(Resource.Type resourceType, Map<Resource.Type, String> keyPropertyKeys) {
        KEY_PROPERTY_IDS.put(resourceType.getInternalType(), keyPropertyKeys);
    }

    public static String getPropertyName(String absProperty) {
        int lastPathSep = absProperty.lastIndexOf(47);
        return lastPathSep == -1 ? absProperty : absProperty.substring(lastPathSep + 1);
    }

    public static String getPropertyCategory(String property) {
        int lastPathSep = -1;
        if (!PropertyHelper.containsArguments(property)) {
            lastPathSep = property.lastIndexOf(47);
            return lastPathSep == -1 ? null : property.substring(0, lastPathSep);
        }
        String[] tokens = METRIC_CATEGORY_TOKENIZE_REGEX.split(property);
        if (null == tokens || tokens.length == 0) {
            return null;
        }
        StringBuilder categoryBuilder = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            int methodIndex;
            Object token = tokens[i];
            if (PropertyHelper.containsArguments((String)token) && (methodIndex = ((String)token).indexOf(46)) != -1) {
                int parensIndex = ((String)token).lastIndexOf(41);
                if (parensIndex < ((String)token).length() - 1) {
                    Object temp = ((String)token).substring(0, methodIndex);
                    token = temp = (String)temp + ((String)token).substring(parensIndex + 1);
                } else {
                    token = ((String)token).substring(0, methodIndex);
                }
            }
            categoryBuilder.append((String)token);
            if (i >= tokens.length - 2) continue;
            categoryBuilder.append('/');
        }
        String category = categoryBuilder.toString();
        return category;
    }

    public static Set<String> getCategories(Set<String> propertyIds) {
        HashSet<String> categories = new HashSet<String>();
        for (String property : propertyIds) {
            String category = PropertyHelper.getPropertyCategory(property);
            while (category != null) {
                categories.add(category);
                category = PropertyHelper.getPropertyCategory(category);
            }
        }
        return categories;
    }

    public static boolean containsProperty(Set<String> propertyIds, String propertyId) {
        if (propertyIds.contains(propertyId)) {
            return true;
        }
        String category = PropertyHelper.getPropertyCategory(propertyId);
        while (category != null) {
            if (propertyIds.contains(category)) {
                return true;
            }
            category = PropertyHelper.getPropertyCategory(category);
        }
        return false;
    }

    public static boolean containsArguments(String propertyId) {
        if (!propertyId.contains("$")) {
            return false;
        }
        Matcher matcher = CHECK_FOR_METRIC_ARGUMENTS_REGEX.matcher(propertyId);
        return matcher.find();
    }

    public static Set<String> getAssociatedPropertyIds(Request request) {
        Set<String> ids = request.getPropertyIds();
        ids = ids != null ? new HashSet<String>(ids) : new HashSet<String>();
        Set<Map<String, Object>> properties = request.getProperties();
        if (properties != null) {
            for (Map<String, Object> propertyMap : properties) {
                ids.addAll(propertyMap.keySet());
            }
        }
        return ids;
    }

    public static Map<String, Object> getProperties(Resource resource) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map<String, Map<String, Object>> categories = resource.getPropertiesMap();
        for (Map.Entry<String, Map<String, Object>> categoryEntry : categories.entrySet()) {
            for (Map.Entry<String, Object> propertyEntry : categoryEntry.getValue().entrySet()) {
                properties.put(PropertyHelper.getPropertyId(categoryEntry.getKey(), propertyEntry.getKey()), propertyEntry.getValue());
            }
        }
        return properties;
    }

    public static Request getCreateRequest(Set<Map<String, Object>> properties, Map<String, String> requestInfoProperties) {
        return new RequestImpl(null, properties, requestInfoProperties, null);
    }

    public static Request getReadRequest(Set<String> propertyIds) {
        return PropertyHelper.getReadRequest(propertyIds, null);
    }

    public static Request getReadRequest(Set<String> propertyIds, Map<String, TemporalInfo> mapTemporalInfo) {
        return PropertyHelper.getReadRequest(propertyIds, null, mapTemporalInfo, null, null);
    }

    public static Request getReadRequest(Set<String> propertyIds, Map<String, String> requestInfoProperties, Map<String, TemporalInfo> mapTemporalInfo, PageRequest pageRequest, SortRequest sortRequest) {
        return new RequestImpl(propertyIds, null, requestInfoProperties, mapTemporalInfo, sortRequest, pageRequest);
    }

    public static Request getReadRequest(String ... propertyIds) {
        return PropertyHelper.getReadRequest(new HashSet<String>(Arrays.asList(propertyIds)));
    }

    public static Request getUpdateRequest(Map<String, Object> properties, Map<String, String> requestInfoProperties) {
        return new RequestImpl(null, Collections.singleton(properties), requestInfoProperties, null);
    }

    private static Map<Resource.InternalType, Map<String, Map<String, PropertyInfo>>> readPropertyProviderIds(String filename) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map resourceMetricMap = (Map)mapper.readValue(ClassLoader.getSystemResourceAsStream(filename), (TypeReference)new TypeReference<Map<Resource.InternalType, Map<String, Map<String, Metric>>>>(){});
            HashMap<Resource.InternalType, Map<String, Map<String, PropertyInfo>>> resourceMetrics = new HashMap<Resource.InternalType, Map<String, Map<String, PropertyInfo>>>();
            for (Map.Entry resourceEntry : resourceMetricMap.entrySet()) {
                HashMap<String, Map<String, PropertyInfo>> componentMetrics = new HashMap<String, Map<String, PropertyInfo>>();
                for (Map.Entry componentEntry : ((Map)resourceEntry.getValue()).entrySet()) {
                    HashMap<String, PropertyInfo> metrics = new HashMap<String, PropertyInfo>();
                    for (Map.Entry metricEntry : ((Map)componentEntry.getValue()).entrySet()) {
                        String property = (String)metricEntry.getKey();
                        Metric metric = (Metric)metricEntry.getValue();
                        PropertyInfo propertyInfo = new PropertyInfo(metric.getMetric(), metric.isTemporal(), metric.isPointInTime());
                        propertyInfo.setAmsId(metric.getAmsId());
                        propertyInfo.setAmsHostMetric(metric.isAmsHostMetric());
                        propertyInfo.setUnit(metric.getUnit());
                        metrics.put(property, propertyInfo);
                    }
                    componentMetrics.put((String)componentEntry.getKey(), metrics);
                }
                if (REPORT_METRIC_RESOURCES.contains(resourceEntry.getKey())) {
                    PropertyHelper.updateMetricsWithAggregateFunctionSupport(componentMetrics);
                }
                resourceMetrics.put((Resource.InternalType)((Object)resourceEntry.getKey()), componentMetrics);
            }
            return resourceMetrics;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read properties file " + filename, e);
        }
    }

    private static Map<Resource.InternalType, Set<String>> readPropertyIds(String filename) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (Map)mapper.readValue(ClassLoader.getSystemResourceAsStream(filename), (TypeReference)new TypeReference<Map<Resource.InternalType, Set<String>>>(){});
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read properties file " + filename, e);
        }
    }

    private static Map<Resource.InternalType, Map<Resource.Type, String>> readKeyPropertyIds(String filename) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(ClassLoader.getSystemResourceAsStream(filename), (TypeReference)new TypeReference<Map<Resource.InternalType, Map<Resource.InternalType, String>>>(){});
            HashMap<Resource.InternalType, Map<Resource.Type, String>> returnMap = new HashMap<Resource.InternalType, Map<Resource.Type, String>>();
            for (Map.Entry entry : map.entrySet()) {
                HashMap<Resource.Type, String> innerMap = new HashMap<Resource.Type, String>();
                for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                    innerMap.put(Resource.Type.valueOf(((Resource.InternalType)((Object)entry1.getKey())).name()), (String)entry1.getValue());
                }
                returnMap.put((Resource.InternalType)((Object)entry.getKey()), innerMap);
            }
            return returnMap;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read properties file " + filename, e);
        }
    }

    public static void updateMetricsWithAggregateFunctionSupport(Map<String, Map<String, PropertyInfo>> metrics) {
        if (metrics == null || metrics.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, PropertyInfo>> metricInfoEntry : metrics.entrySet()) {
            Map<String, PropertyInfo> metricInfo = metricInfoEntry.getValue();
            HashMap<CallSite, PropertyInfo> aggregateMetrics = new HashMap<CallSite, PropertyInfo>();
            for (Map.Entry<String, PropertyInfo> metricEntry : metricInfo.entrySet()) {
                for (String identifierToAdd : AGGREGATE_FUNCTION_IDENTIFIERS) {
                    String metricInfoKey = metricEntry.getKey() + identifierToAdd;
                    if (metricInfo.containsKey(metricInfoKey)) continue;
                    PropertyInfo propertyInfo = metricEntry.getValue();
                    PropertyInfo metricInfoValue = new PropertyInfo(propertyInfo.getPropertyId() + identifierToAdd, propertyInfo.isTemporal(), propertyInfo.isPointInTime());
                    metricInfoValue.setAmsHostMetric(propertyInfo.isAmsHostMetric());
                    metricInfoValue.setAmsId(!StringUtils.isEmpty((String)propertyInfo.getAmsId()) ? propertyInfo.getAmsId() + identifierToAdd : null);
                    metricInfoValue.setUnit(propertyInfo.getUnit());
                    aggregateMetrics.put((CallSite)((Object)metricInfoKey), metricInfoValue);
                }
            }
            metricInfo.putAll(aggregateMetrics);
        }
    }

    public static boolean hasAggregateFunctionSuffix(String propertyId) {
        for (String aggregateFunctionId : AGGREGATE_FUNCTION_IDENTIFIERS) {
            if (!propertyId.endsWith(aggregateFunctionId)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, id.onyx.obdp.server.state.stack.Metric> processRpcMetricDefinition(String metricType, String componentName, String propertyId, id.onyx.obdp.server.state.stack.Metric metric) {
        HashMap<String, id.onyx.obdp.server.state.stack.Metric> replacementMap = null;
        if (componentName.equalsIgnoreCase("NAMENODE")) {
            for (Map.Entry<String, List<String>> entry : RPC_METRIC_SUFFIXES.entrySet()) {
                String prefix = entry.getKey();
                if (!propertyId.startsWith(prefix)) continue;
                replacementMap = new HashMap<String, id.onyx.obdp.server.state.stack.Metric>();
                for (String suffix : entry.getValue()) {
                    String newMetricName = "jmx".equals(metricType) ? PropertyHelper.insertTagIntoCategoty(suffix, metric.getName()) : PropertyHelper.insertTagInToMetricName(suffix, metric.getName(), prefix);
                    id.onyx.obdp.server.state.stack.Metric newMetric = new id.onyx.obdp.server.state.stack.Metric(newMetricName, metric.isPointInTime(), metric.isTemporal(), metric.isAmsHostMetric(), metric.getUnit());
                    replacementMap.put(PropertyHelper.insertTagInToMetricName(suffix, propertyId, prefix), newMetric);
                }
            }
        }
        return replacementMap;
    }

    static String insertTagInToMetricName(String tag, String metricName, String prefix) {
        String prefixSep;
        String sepExpr = "\\.";
        String seperator = ".";
        if (metricName.indexOf(47) != -1) {
            seperator = sepExpr = Character.toString('/');
        }
        String string = prefixSep = prefix.contains(".") ? "\\." : "/";
        if (prefix.substring(prefix.length() - 1).equals(prefixSep)) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        int pos = prefix.split(prefixSep).length - 1;
        String[] parts = metricName.split(sepExpr);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i < parts.length - 1) {
                sb.append(seperator);
            }
            if (i != pos) continue;
            sb.append(tag);
            sb.append(seperator);
        }
        return sb.toString();
    }

    static String insertTagIntoCategoty(String tag, String metricName) {
        int pos = metricName.lastIndexOf(46);
        return metricName.substring(0, pos) + ",tag=" + tag + metricName.substring(pos);
    }

    static {
        RPC_METRIC_SUFFIXES.put("metrics/rpc/", (List<String>)ImmutableList.of((Object)"client", (Object)"datanode", (Object)"healthcheck"));
        RPC_METRIC_SUFFIXES.put("metrics/rpcdetailed/", (List<String>)ImmutableList.of((Object)"client", (Object)"datanode", (Object)"healthcheck"));
    }

    protected static class Metric {
        private String metric;
        private boolean pointInTime;
        private boolean temporal;
        private String amsId;
        private boolean amsHostMetric;
        private String unit = "unitless";

        private Metric() {
        }

        protected Metric(String metric, boolean pointInTime, boolean temporal, String unit) {
            this.metric = metric;
            this.pointInTime = pointInTime;
            this.temporal = temporal;
            this.unit = unit;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public boolean isPointInTime() {
            return this.pointInTime;
        }

        public void setPointInTime(boolean pointInTime) {
            this.pointInTime = pointInTime;
        }

        public boolean isTemporal() {
            return this.temporal;
        }

        public void setTemporal(boolean temporal) {
            this.temporal = temporal;
        }

        public String getAmsId() {
            return this.amsId;
        }

        public void setAmsId(String amsId) {
            this.amsId = amsId;
        }

        public boolean isAmsHostMetric() {
            return this.amsHostMetric;
        }

        public void setAmsHostMetric(boolean amsHostMetric) {
            this.amsHostMetric = amsHostMetric;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

