/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.GreaterEqualsPredicate;
import id.onyx.obdp.server.controller.predicate.GreaterPredicate;
import id.onyx.obdp.server.controller.predicate.LessEqualsPredicate;
import id.onyx.obdp.server.controller.predicate.LessPredicate;
import id.onyx.obdp.server.controller.predicate.NotPredicate;
import id.onyx.obdp.server.controller.predicate.OrPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import java.util.LinkedList;
import java.util.List;

public class PredicateBuilder {
    private String propertyId;
    private List<Predicate> predicates = new LinkedList<Predicate>();
    private Operator operator = null;
    private final PredicateBuilder outer;
    private boolean done = false;
    private boolean not = false;

    public PredicateBuilder() {
        this.outer = null;
    }

    private PredicateBuilder(PredicateBuilder outer) {
        this.outer = outer;
    }

    public PredicateBuilder(Predicate predicate) {
        this.outer = null;
        this.addPredicate(predicate);
    }

    public PredicateBuilderWithProperty property(String id) {
        this.checkDone();
        this.propertyId = id;
        return new PredicateBuilderWithProperty();
    }

    public PredicateBuilder not() {
        this.not = true;
        return this;
    }

    public PredicateBuilder begin() {
        this.checkDone();
        return new PredicateBuilder(this);
    }

    public Predicate toPredicate() {
        return this.getPredicate();
    }

    private void checkDone() {
        if (this.done) {
            throw new IllegalStateException("Can't reuse a predicate builder.");
        }
    }

    private PredicateBuilderWithPredicate getPredicateBuilderWithPredicate() {
        return new PredicateBuilderWithPredicate();
    }

    private void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    private void handleComparator() {
        if (this.operator == null) {
            return;
        }
        if (this.predicates.size() == 0) {
            throw new IllegalStateException("No left operand.");
        }
        ArrayPredicate predicate = switch (this.operator) {
            case Operator.And -> new AndPredicate(this.predicates.toArray(new Predicate[this.predicates.size()]));
            case Operator.Or -> new OrPredicate(this.predicates.toArray(new Predicate[this.predicates.size()]));
            default -> throw new IllegalStateException("Unknown operator " + this.operator);
        };
        this.predicates.clear();
        this.addPredicate(predicate);
    }

    private Predicate getPredicate() {
        this.handleComparator();
        if (this.predicates.size() == 1) {
            Predicate predicate = this.predicates.get(0);
            if (this.not) {
                predicate = new NotPredicate(predicate);
                this.not = false;
            }
            return predicate;
        }
        throw new IllegalStateException("Can't return a predicate.");
    }

    private static enum Operator {
        And,
        Or;

    }

    public class PredicateBuilderWithProperty {
        public <T> PredicateBuilderWithPredicate equals(Comparable<T> value) {
            if (PredicateBuilder.this.propertyId == null) {
                throw new IllegalStateException("No property.");
            }
            PredicateBuilder.this.addPredicate(new EqualsPredicate<T>(PredicateBuilder.this.propertyId, value));
            return new PredicateBuilderWithPredicate();
        }

        public <T> PredicateBuilderWithPredicate greaterThan(Comparable<T> value) {
            if (PredicateBuilder.this.propertyId == null) {
                throw new IllegalStateException("No property.");
            }
            PredicateBuilder.this.addPredicate(new GreaterPredicate<T>(PredicateBuilder.this.propertyId, value));
            return new PredicateBuilderWithPredicate();
        }

        public <T> PredicateBuilderWithPredicate greaterThanEqualTo(Comparable<T> value) {
            if (PredicateBuilder.this.propertyId == null) {
                throw new IllegalStateException("No property.");
            }
            PredicateBuilder.this.addPredicate(new GreaterEqualsPredicate<T>(PredicateBuilder.this.propertyId, value));
            return new PredicateBuilderWithPredicate();
        }

        public <T> PredicateBuilderWithPredicate lessThan(Comparable<T> value) {
            if (PredicateBuilder.this.propertyId == null) {
                throw new IllegalStateException("No property.");
            }
            PredicateBuilder.this.addPredicate(new LessPredicate<T>(PredicateBuilder.this.propertyId, value));
            return new PredicateBuilderWithPredicate();
        }

        public <T> PredicateBuilderWithPredicate lessThanEqualTo(Comparable<T> value) {
            if (PredicateBuilder.this.propertyId == null) {
                throw new IllegalStateException("No property.");
            }
            PredicateBuilder.this.addPredicate(new LessEqualsPredicate<T>(PredicateBuilder.this.propertyId, value));
            return new PredicateBuilderWithPredicate();
        }
    }

    public class PredicateBuilderWithPredicate {
        public PredicateBuilder and() {
            if (PredicateBuilder.this.operator != Operator.And) {
                PredicateBuilder.this.handleComparator();
                PredicateBuilder.this.operator = Operator.And;
            }
            return PredicateBuilder.this;
        }

        public PredicateBuilder or() {
            if (PredicateBuilder.this.operator != Operator.Or) {
                PredicateBuilder.this.handleComparator();
                PredicateBuilder.this.operator = Operator.Or;
            }
            return PredicateBuilder.this;
        }

        public Predicate toPredicate() {
            if (PredicateBuilder.this.outer != null) {
                throw new IllegalStateException("Unbalanced block - missing end.");
            }
            PredicateBuilder.this.done = true;
            return PredicateBuilder.this.getPredicate();
        }

        public PredicateBuilderWithPredicate end() {
            if (PredicateBuilder.this.outer == null) {
                throw new IllegalStateException("Unbalanced block - missing begin.");
            }
            PredicateBuilder.this.outer.addPredicate(PredicateBuilder.this.getPredicate());
            return PredicateBuilder.this.outer.getPredicateBuilderWithPredicate();
        }
    }
}

