/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.utilities.RemovableIdentities;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.ServiceRemovedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.serveraction.kerberos.KerberosMissingAdminCredentialsException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.SecurityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KerberosIdentityCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosIdentityCleaner.class);
    private final OBDPEventPublisher eventPublisher;
    private final KerberosHelper kerberosHelper;
    private final Clusters clusters;

    @Inject
    public KerberosIdentityCleaner(OBDPEventPublisher eventPublisher, KerberosHelper kerberosHelper, Clusters clusters) {
        this.eventPublisher = eventPublisher;
        this.kerberosHelper = kerberosHelper;
        this.clusters = clusters;
    }

    public void register() {
        this.eventPublisher.register(this);
    }

    @Subscribe
    public void componentRemoved(ServiceComponentUninstalledEvent event) throws KerberosMissingAdminCredentialsException {
        try {
            Cluster cluster = this.clusters.getCluster(event.getClusterId());
            if (cluster.getSecurityType() == SecurityType.KERBEROS) {
                if (null != cluster.getUpgradeInProgress()) {
                    LOG.info("Skipping removal of identities for {} since there is an upgrade in progress", (Object)event.getComponentName());
                    return;
                }
                LOG.info("Removing identities after {}", (Object)event);
                RemovableIdentities.ofComponent(this.clusters.getCluster(event.getClusterId()), event, this.kerberosHelper).remove(this.kerberosHelper);
            }
        }
        catch (Exception e) {
            LOG.error("Error while deleting kerberos identity after an event: " + event, (Throwable)e);
        }
    }

    @Subscribe
    public void serviceRemoved(ServiceRemovedEvent event) {
        try {
            Cluster cluster = this.clusters.getCluster(event.getClusterId());
            if (cluster.getSecurityType() == SecurityType.KERBEROS) {
                if (null != cluster.getUpgradeInProgress()) {
                    LOG.info("Skipping removal of identities for {} since there is an upgrade in progress", (Object)event.getServiceName());
                    return;
                }
                LOG.info("Removing identities after {}", (Object)event);
                RemovableIdentities.ofService(this.clusters.getCluster(event.getClusterId()), event, this.kerberosHelper).remove(this.kerberosHelper);
            }
        }
        catch (Exception e) {
            LOG.error("Error while deleting kerberos identity after an event: " + event, (Throwable)e);
        }
    }
}

