/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.utilities.LoginContextHelper;
import java.io.File;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosChecker {
    static final String HTTP_SPNEGO_STANDARD_ENTRY = "com.sun.security.jgss.krb5.initiate";
    private static final String KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    public static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosChecker.class);
    @Inject
    static id.onyx.obdp.server.configuration.Configuration config;
    @Inject
    static LoginContextHelper loginContextHelper;

    public static void checkJaasConfiguration() throws OBDPException {
        if (config.isKerberosJaasConfigurationCheckEnabled()) {
            LOG.info("Checking Ambari Server Kerberos credentials.");
            String jaasConfPath = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            Configuration jaasConf = Configuration.getConfiguration();
            AppConfigurationEntry[] jaasConfEntries = jaasConf.getAppConfigurationEntry(HTTP_SPNEGO_STANDARD_ENTRY);
            if (jaasConfEntries == null) {
                LOG.warn("Can't find com.sun.security.jgss.krb5.initiate entry in " + jaasConfPath);
            } else {
                boolean krb5LoginModulePresent = false;
                for (AppConfigurationEntry ace : jaasConfEntries) {
                    if (!KRB5_LOGIN_MODULE.equals(ace.getLoginModuleName())) continue;
                    krb5LoginModulePresent = true;
                    Map<String, ?> options = ace.getOptions();
                    if (options == null) continue;
                    if (options.containsKey("keyTab")) {
                        String keytabPath = (String)options.get("keyTab");
                        File keytabFile = new File(keytabPath);
                        if (!keytabFile.exists()) {
                            LOG.warn(keytabPath + " doesn't exist.");
                        } else if (!keytabFile.canRead()) {
                            LOG.warn("Unable to read " + keytabPath + " Please check the file access permissions for user " + System.getProperty("user.name"));
                        }
                    } else {
                        LOG.warn("Can't find keyTab option in com.sun.security.auth.module.Krb5LoginModule module of com.sun.security.jgss.krb5.initiate entry in " + jaasConfPath);
                    }
                    if (options.containsKey("principal")) continue;
                    LOG.warn("Can't find principal option in com.sun.security.auth.module.Krb5LoginModule module of com.sun.security.jgss.krb5.initiate entry in " + jaasConfPath);
                }
                if (!krb5LoginModulePresent) {
                    LOG.warn("Can't find com.sun.security.auth.module.Krb5LoginModule module in com.sun.security.jgss.krb5.initiate entry in " + jaasConfPath);
                }
            }
            try {
                LoginContext loginContext = loginContextHelper.createLoginContext(HTTP_SPNEGO_STANDARD_ENTRY);
                loginContext.login();
                loginContext.logout();
            }
            catch (LoginException le) {
                LOG.error(le.getMessage());
                throw new OBDPException("Ambari Server Kerberos credentials check failed. \nCheck KDC availability and JAAS configuration in " + jaasConfPath);
            }
            LOG.info("Ambari Server Kerberos credentials check passed.");
        } else {
            LOG.info("Skipping Ambari Server Kerberos credentials check.");
        }
    }
}

