/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.MetainfoDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.MetainfoEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.utils.VersionUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseChecker.class);
    @Inject
    static Injector injector;
    static OBDPMetaInfo obdpMetaInfo;
    static MetainfoDAO metainfoDAO;

    public static void checkDBConsistency() throws OBDPException {
        LOG.info("Checking DB consistency");
        boolean checkPassed = true;
        if (obdpMetaInfo == null) {
            obdpMetaInfo = (OBDPMetaInfo)injector.getInstance(OBDPMetaInfo.class);
        }
        ClusterDAO clusterDAO = (ClusterDAO)injector.getInstance(ClusterDAO.class);
        List<ClusterEntity> clusters = clusterDAO.findAll();
        for (ClusterEntity clusterEntity : clusters) {
            StackId stackId = new StackId(clusterEntity.getDesiredStack());
            Collection<ClusterServiceEntity> serviceEntities = clusterEntity.getClusterServiceEntities();
            for (ClusterServiceEntity clusterServiceEntity : serviceEntities) {
                Collection<ServiceComponentDesiredStateEntity> scDesiredStateEntities;
                ServiceDesiredStateEntity serviceDesiredStateEntity = clusterServiceEntity.getServiceDesiredStateEntity();
                if (serviceDesiredStateEntity == null) {
                    checkPassed = false;
                    LOG.error(String.format("ServiceDesiredStateEntity is null for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s ", clusterEntity.getClusterName(), clusterServiceEntity.getServiceName()));
                }
                if ((scDesiredStateEntities = clusterServiceEntity.getServiceComponentDesiredStateEntities()) == null || scDesiredStateEntities.isEmpty()) {
                    checkPassed = false;
                    LOG.error(String.format("serviceComponentDesiredStateEntities is null or empty for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s ", clusterEntity.getClusterName(), clusterServiceEntity.getServiceName()));
                    continue;
                }
                for (ServiceComponentDesiredStateEntity scDesiredStateEnity : scDesiredStateEntities) {
                    Collection<HostComponentDesiredStateEntity> schDesiredStateEntities = scDesiredStateEnity.getHostComponentDesiredStateEntities();
                    Collection<HostComponentStateEntity> schStateEntities = scDesiredStateEnity.getHostComponentStateEntities();
                    ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName());
                    boolean zeroCardinality = componentInfo.getCardinality() == null || componentInfo.getCardinality().startsWith("0") || scDesiredStateEnity.getComponentName().equals("SECONDARY_NAMENODE");
                    boolean componentCheckFailed = false;
                    if (schDesiredStateEntities == null) {
                        componentCheckFailed = true;
                        LOG.error(String.format("hostComponentDesiredStateEntities is null for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s, componentName=%s ", clusterEntity.getClusterName(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName()));
                    } else if (!zeroCardinality && schDesiredStateEntities.isEmpty()) {
                        componentCheckFailed = true;
                        LOG.error(String.format("hostComponentDesiredStateEntities is empty for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s, componentName=%s ", clusterEntity.getClusterName(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName()));
                    }
                    if (schStateEntities == null) {
                        componentCheckFailed = true;
                        LOG.error(String.format("hostComponentStateEntities is null for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s, componentName=%s ", clusterEntity.getClusterName(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName()));
                    } else if (!zeroCardinality && schStateEntities.isEmpty()) {
                        componentCheckFailed = true;
                        LOG.error(String.format("hostComponentStateEntities is empty for ServiceComponentDesiredStateEntity, clusterName=%s, serviceName=%s, componentName=%s ", clusterEntity.getClusterName(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName()));
                    }
                    if (!componentCheckFailed && schDesiredStateEntities.size() != schStateEntities.size()) {
                        checkPassed = false;
                        LOG.error(String.format("HostComponentStateEntities and HostComponentDesiredStateEntities tables must contain equal number of rows mapped to ServiceComponentDesiredStateEntity, (clusterName=%s, serviceName=%s, componentName=%s) ", clusterEntity.getClusterName(), scDesiredStateEnity.getServiceName(), scDesiredStateEnity.getComponentName()));
                    }
                    checkPassed = checkPassed && !componentCheckFailed;
                }
            }
        }
        if (!checkPassed) {
            String errorMessage = "DB consistency check failed. Run \"obdp-server start --skip-database-validation\" to skip validation.";
            LOG.error(errorMessage);
            throw new OBDPException(errorMessage);
        }
        LOG.info("DB consistency check passed.");
    }

    private static boolean clusterConfigsContainTypeAndTag(Collection<ClusterConfigEntity> clusterConfigEntities, String typeName, String tag) {
        for (ClusterConfigEntity clusterConfigEntity : clusterConfigEntities) {
            if (!typeName.equals(clusterConfigEntity.getType()) || !tag.equals(clusterConfigEntity.getTag())) continue;
            return true;
        }
        return false;
    }

    public static void checkDBConfigsConsistency() throws OBDPException {
        ClusterDAO clusterDAO;
        List<ClusterEntity> clusters;
        LOG.info("Checking DB configs consistency");
        boolean checkPassed = true;
        if (obdpMetaInfo == null) {
            obdpMetaInfo = (OBDPMetaInfo)injector.getInstance(OBDPMetaInfo.class);
        }
        if ((clusters = (clusterDAO = (ClusterDAO)injector.getInstance(ClusterDAO.class)).findAll()) != null) {
            for (ClusterEntity clusterEntity : clusters) {
                Collection<ClusterConfigEntity> clusterConfigEntities = clusterEntity.getClusterConfigEntities();
                if (null == clusterConfigEntities) {
                    return;
                }
                HashMap<String, Integer> selectedCountForType = new HashMap<String, Integer>();
                for (ClusterConfigEntity configEntity : clusterConfigEntities) {
                    String typeName = configEntity.getType();
                    if (configEntity.isSelected()) {
                        int selectedCount = selectedCountForType.get(typeName) != null ? (Integer)selectedCountForType.get(typeName) : 0;
                        selectedCountForType.put(typeName, selectedCount + 1);
                        continue;
                    }
                    if (selectedCountForType.containsKey(typeName)) continue;
                    selectedCountForType.put(typeName, 0);
                }
                Collection<ClusterServiceEntity> clusterServiceEntities = clusterEntity.getClusterServiceEntities();
                ClusterStateEntity clusterStateEntity = clusterEntity.getClusterStateEntity();
                if (clusterStateEntity == null) continue;
                StackEntity currentStack = clusterStateEntity.getCurrentStack();
                StackInfo stack = obdpMetaInfo.getStack(currentStack.getStackName(), currentStack.getStackVersion());
                for (ClusterServiceEntity clusterServiceEntity : clusterServiceEntities) {
                    if (State.INIT.equals((Object)clusterServiceEntity.getServiceDesiredStateEntity().getDesiredState())) continue;
                    String serviceName = clusterServiceEntity.getServiceName();
                    ServiceInfo serviceInfo = obdpMetaInfo.getService(stack.getName(), stack.getVersion(), serviceName);
                    for (String configTypeName : serviceInfo.getConfigTypeAttributes().keySet()) {
                        if (selectedCountForType.get(configTypeName) == null) {
                            checkPassed = false;
                            LOG.error("Configuration {} is missing for service {}", (Object)configTypeName, (Object)serviceName);
                            continue;
                        }
                        if ((Integer)selectedCountForType.get(configTypeName) == 0) {
                            checkPassed = false;
                            LOG.error("Configuration {} has no enabled entries for service {}", (Object)configTypeName, (Object)serviceName);
                            continue;
                        }
                        if ((Integer)selectedCountForType.get(configTypeName) <= 1) continue;
                        checkPassed = false;
                        LOG.error("Configuration {} has more than 1 enabled entry for service {}", (Object)configTypeName, (Object)serviceName);
                    }
                }
            }
        }
        if (!checkPassed) {
            String errorMessage = "DB configs consistency check failed. Run \"obdp-server start --skip-database-validation\" to skip validation.";
            LOG.error(errorMessage);
            throw new OBDPException(errorMessage);
        }
        LOG.info("DB configs consistency check passed.");
    }

    public static void checkDBVersion() throws OBDPException {
        Configuration conf;
        File versionFile;
        LOG.info("Checking DB store version");
        if (metainfoDAO == null) {
            metainfoDAO = (MetainfoDAO)injector.getInstance(MetainfoDAO.class);
        }
        MetainfoEntity schemaVersionEntity = metainfoDAO.findByKey("version");
        String schemaVersion = null;
        if (schemaVersionEntity != null) {
            schemaVersion = schemaVersionEntity.getMetainfoValue();
        }
        if (!(versionFile = new File((conf = (Configuration)injector.getInstance(Configuration.class)).getServerVersionFilePath())).exists()) {
            throw new OBDPException("Server version file does not exist.");
        }
        String serverVersion = null;
        try (Scanner scanner = new Scanner(versionFile);){
            serverVersion = scanner.useDelimiter("\\Z").next();
        }
        catch (IOException ioe) {
            throw new OBDPException("Unable to read server version file.");
        }
        if (schemaVersionEntity == null || VersionUtils.compareVersions((String)schemaVersion, (String)serverVersion, (int)3) != 0) {
            String error = "Current database store version is not compatible with current server version, serverVersion=" + serverVersion + ", schemaVersion=" + schemaVersion;
            LOG.warn(error);
            throw new OBDPException(error);
        }
        LOG.info("DB store version is compatible");
    }
}

