/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import id.onyx.obdp.server.controller.internal.ClusterControllerImpl;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.ProviderModule;
import id.onyx.obdp.server.view.ViewProviderModule;

public class ClusterControllerHelper {
    private static String PROVIDER_MODULE_CLASS = System.getProperty("provider.module.class", "id.onyx.obdp.server.controller.internal.DefaultProviderModule");
    private static ClusterController controller;

    public static synchronized ClusterController getClusterController() {
        if (controller == null) {
            try {
                Class<?> implClass = Class.forName(PROVIDER_MODULE_CLASS);
                ViewProviderModule providerModule = ViewProviderModule.getViewProviderModule((ProviderModule)implClass.newInstance());
                controller = new ClusterControllerImpl(providerModule);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create provider module " + PROVIDER_MODULE_CLASS, e);
            }
        }
        return controller;
    }
}

