/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities;

import java.util.Queue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BufferedThreadPoolExecutorCompletionService<V>
extends ExecutorCompletionService<V> {
    private ThreadPoolExecutor executor;
    private Queue<Runnable> overflowQueue;

    public BufferedThreadPoolExecutorCompletionService(ThreadPoolExecutor executor) {
        super(executor);
        this.executor = executor;
        this.overflowQueue = new LinkedBlockingQueue<Runnable>();
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                BufferedThreadPoolExecutorCompletionService.this.overflowQueue.add(r);
            }
        });
    }

    @Override
    public Future<V> take() throws InterruptedException {
        Runnable overflow;
        Future take = super.take();
        if (!this.executor.isTerminating() && !this.overflowQueue.isEmpty() && this.executor.getActiveCount() < this.executor.getMaximumPoolSize() && (overflow = this.overflowQueue.poll()) != null) {
            this.executor.execute(overflow);
        }
        return take;
    }

    @Override
    public Future<V> poll() {
        Runnable overflow;
        Future poll = super.poll();
        if (!this.executor.isTerminating() && !this.overflowQueue.isEmpty() && this.executor.getActiveCount() < this.executor.getMaximumPoolSize() && (overflow = this.overflowQueue.poll()) != null) {
            this.executor.execute(overflow);
        }
        return poll;
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable overflow;
        Future poll = super.poll();
        if (null != poll) {
            Runnable overflow2;
            if (!this.executor.isTerminating() && !this.overflowQueue.isEmpty() && this.executor.getActiveCount() < this.executor.getMaximumPoolSize() && (overflow2 = this.overflowQueue.poll()) != null) {
                this.executor.execute(overflow2);
            }
            return poll;
        }
        if (this.executor.getActiveCount() == 0 && !this.executor.isTerminating() && !this.overflowQueue.isEmpty() && (overflow = this.overflowQueue.poll()) != null) {
            this.executor.execute(overflow);
        }
        poll = super.poll(timeout, unit);
        return poll;
    }
}

