/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.predicate;

import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class OrPredicate
extends ArrayPredicate {
    public OrPredicate(Predicate ... predicates) {
        super(predicates);
    }

    @Override
    public Predicate create(Predicate ... predicates) {
        return OrPredicate.instance(predicates);
    }

    public static Predicate instance(Predicate ... predicates) {
        return OrPredicate.of(Arrays.asList(predicates));
    }

    public static Predicate of(@Nonnull Iterable<? extends Predicate> predicates) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        for (Predicate predicate : predicates) {
            if (predicate instanceof AlwaysPredicate) {
                return predicate;
            }
            if (predicate instanceof OrPredicate) {
                predicateList.addAll(Arrays.asList(((OrPredicate)predicate).getPredicates()));
                continue;
            }
            predicateList.add(predicate);
        }
        return predicateList.size() == 1 ? (Predicate)predicateList.get(0) : new OrPredicate(predicateList.toArray(new Predicate[predicateList.size()]));
    }

    @Override
    public boolean evaluate(Resource resource) {
        Predicate[] predicates;
        for (Predicate predicate : predicates = this.getPredicates()) {
            if (!predicate.evaluate(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperator() {
        return "OR";
    }
}

