/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.predicate;

import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FilterPredicate
extends ComparisonPredicate {
    private final Matcher matcher;
    private final String patternExpr;
    private final String emptyString = "";

    public FilterPredicate(String propertyId, String patternExpr) {
        super(propertyId, patternExpr);
        this.patternExpr = patternExpr;
        try {
            Pattern pattern = Pattern.compile(patternExpr != null ? patternExpr : "");
            this.matcher = pattern.matcher("");
        }
        catch (PatternSyntaxException pe) {
            throw new IllegalArgumentException(pe);
        }
    }

    @Override
    public boolean evaluate(Resource resource) {
        Object propertyValue = resource.getPropertyValue(this.getPropertyId());
        this.matcher.reset(propertyValue != null ? propertyValue.toString() : "");
        return this.patternExpr == null ? propertyValue == null : propertyValue != null && this.matcher.matches();
    }

    @Override
    public String getOperator() {
        return ".FILTER";
    }

    public ComparisonPredicate copy(String propertyId) {
        return new FilterPredicate(propertyId, this.patternExpr);
    }

    @Override
    public String toString() {
        return this.getPropertyId() + this.getOperator() + "(" + this.getValue() + ")";
    }
}

