/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.predicate;

import id.onyx.obdp.server.controller.predicate.BasePredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.PropertyPredicate;
import java.text.NumberFormat;
import java.text.ParsePosition;

public abstract class ComparisonPredicate<T>
extends PropertyPredicate
implements BasePredicate {
    private final Comparable<T> value;
    private final String stringValue;
    private final Double doubleValue;

    protected ComparisonPredicate(String propertyId, Comparable<T> value) {
        super(propertyId);
        this.value = value;
        if (value instanceof Number) {
            this.stringValue = null;
            this.doubleValue = ((Number)((Object)value)).doubleValue();
        } else if (value instanceof String) {
            this.stringValue = (String)((Object)value);
            this.doubleValue = this.stringToDouble(this.stringValue);
        } else {
            this.stringValue = null;
            this.doubleValue = null;
        }
    }

    public Comparable<T> getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonPredicate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComparisonPredicate that = (ComparisonPredicate)o;
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public void accept(PredicateVisitor visitor) {
        visitor.acceptComparisonPredicate(this);
    }

    protected int compareValueToIgnoreCase(Object propertyValue) throws ClassCastException {
        return this.compareValueTo(propertyValue, true);
    }

    protected int compareValueTo(Object propertyValue) throws ClassCastException {
        return this.compareValueTo(propertyValue, false);
    }

    private int compareValueTo(Object propertyValue, boolean ignoreCase) throws ClassCastException {
        if (this.doubleValue != null) {
            Double doubleFromString;
            if (propertyValue instanceof Number) {
                return this.doubleValue.compareTo(((Number)propertyValue).doubleValue());
            }
            if (propertyValue instanceof String && (doubleFromString = this.stringToDouble((String)propertyValue)) != null) {
                return this.doubleValue.compareTo(doubleFromString);
            }
        }
        if (this.stringValue != null) {
            if (ignoreCase) {
                return this.stringValue.compareToIgnoreCase(propertyValue.toString());
            }
            return this.stringValue.compareTo(propertyValue.toString());
        }
        return this.getValue().compareTo(propertyValue);
    }

    private Double stringToDouble(String stringValue) {
        if (stringValue == null || stringValue.isEmpty()) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        NumberFormat numberFormat = NumberFormat.getInstance();
        Number parsedNumber = numberFormat.parse(stringValue, parsePosition);
        return parsePosition.getIndex() == stringValue.length() ? Double.valueOf(parsedNumber.doubleValue()) : null;
    }

    public abstract String getOperator();

    public abstract ComparisonPredicate<T> copy(String var1);

    public String toString() {
        return this.getPropertyId() + this.getOperator() + this.getValue();
    }
}

