/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.predicate;

import id.onyx.obdp.server.controller.predicate.BasePredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class ArrayPredicate
implements BasePredicate {
    private final Predicate[] predicates;
    private final Set<String> propertyIds = new HashSet<String>();

    public ArrayPredicate(Predicate ... predicates) {
        this.predicates = predicates;
        for (Predicate predicate : predicates) {
            this.propertyIds.addAll(PredicateHelper.getPropertyIds(predicate));
        }
    }

    @Override
    public Set<String> getPropertyIds() {
        return this.propertyIds;
    }

    @Override
    public void accept(PredicateVisitor visitor) {
        visitor.acceptArrayPredicate(this);
    }

    public abstract String getOperator();

    public abstract Predicate create(Predicate ... var1);

    public Predicate[] getPredicates() {
        return this.predicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayPredicate)) {
            return false;
        }
        ArrayPredicate that = (ArrayPredicate)o;
        if (this.propertyIds != null ? !this.propertyIds.equals(that.propertyIds) : that.propertyIds != null) {
            return false;
        }
        HashSet<Predicate> setThisPredicates = new HashSet<Predicate>(Arrays.asList(this.predicates));
        HashSet<Predicate> setThatPredicates = new HashSet<Predicate>(Arrays.asList(that.predicates));
        return setThisPredicates.equals(setThatPredicates);
    }

    public int hashCode() {
        int result = this.predicates != null ? new HashSet<Predicate>(Arrays.asList(this.predicates)).hashCode() : 0;
        result = 31 * result + (this.propertyIds != null ? this.propertyIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Predicate predicate : this.predicates) {
            boolean arrayPredicate = predicate instanceof ArrayPredicate;
            if (sb.length() > 0) {
                sb.append(" ").append(this.getOperator()).append(" ");
            }
            if (arrayPredicate) {
                sb.append("(").append(predicate).append(")");
                continue;
            }
            sb.append(predicate);
        }
        return sb.toString();
    }
}

