/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class TimelineMetricsCacheValueSerializer
implements Serializer<TimelineMetricsCacheValue> {
    private final ClassLoader classLoader;

    public TimelineMetricsCacheValueSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ByteBuffer serialize(TimelineMetricsCacheValue value) throws SerializerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(value);
            objectOutputStream.close();
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
    }

    public TimelineMetricsCacheValue read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binary.array());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (TimelineMetricsCacheValue)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializerException("Error during deserialization", (Throwable)e);
        }
    }

    public boolean equals(TimelineMetricsCacheValue value, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binary.array());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            TimelineMetricsCacheValue deserializedValue = (TimelineMetricsCacheValue)objectInputStream.readObject();
            if (value == deserializedValue) {
                return true;
            }
            if (deserializedValue == null || value.getClass() != deserializedValue.getClass()) {
                return false;
            }
            if (!value.getStartTime().equals(deserializedValue.getStartTime())) {
                return false;
            }
            if (!value.getEndTime().equals(deserializedValue.getEndTime())) {
                return false;
            }
            if (!value.getTimelineMetrics().equals(deserializedValue.getTimelineMetrics())) {
                return false;
            }
            return value.getPrecision() == deserializedValue.getPrecision();
        }
        catch (IOException e) {
            throw new SerializerException("Error during deserialization", (Throwable)e);
        }
    }
}

