/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import java.util.Date;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

public class TimelineMetricsCacheValue {
    private Long startTime;
    private Long endTime;
    private TimelineMetrics timelineMetrics = new TimelineMetrics();
    private Precision precision;

    public TimelineMetricsCacheValue(Long startTime, Long endTime, TimelineMetrics timelineMetrics, Precision precision) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.timelineMetrics = timelineMetrics;
        this.precision = precision;
    }

    public TimelineMetrics getTimelineMetrics() {
        return this.timelineMetrics;
    }

    public void setTimelineMetrics(TimelineMetrics timelineMetrics) {
        this.timelineMetrics = timelineMetrics;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    private long getMillisecondsTime(long time) {
        if (time < 9999999999L) {
            return time * 1000L;
        }
        return time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimelineMetricsCacheValue {, startTime = " + new Date(this.getMillisecondsTime(this.startTime)) + ", endTime = " + new Date(this.getMillisecondsTime(this.endTime)) + ", precision = " + this.precision + ", timelineMetrics =");
        for (TimelineMetric metric : this.timelineMetrics.getMetrics()) {
            sb.append(" { ");
            sb.append(metric.getMetricName());
            sb.append(", ");
            sb.append(metric.getHostName());
            sb.append(" # ");
            sb.append(metric.getMetricValues().size());
            sb.append(" }");
        }
        sb.append("}");
        return sb.toString();
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }
}

