/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKeySerializer;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCache;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheCustomExpiry;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheEntryFactory;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValue;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValueSerializer;
import java.time.Duration;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.expiry.Expiry;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimelineMetricCacheProvider {
    private TimelineMetricCache timelineMetricsCache;
    private volatile boolean isCacheInitialized = false;
    public static final String TIMELINE_METRIC_CACHE_INSTANCE_NAME = "timelineMetricCache";
    Configuration configuration;
    TimelineMetricCacheEntryFactory cacheEntryFactory;
    private static final Logger LOG = LoggerFactory.getLogger(TimelineMetricCacheProvider.class);

    @Inject
    public TimelineMetricCacheProvider(Configuration configuration, TimelineMetricCacheEntryFactory cacheEntryFactory) {
        this.configuration = configuration;
        this.cacheEntryFactory = cacheEntryFactory;
    }

    private synchronized void initializeCache() {
        if (this.isCacheInitialized) {
            return;
        }
        DefaultStatisticsService statisticsService = new DefaultStatisticsService();
        CacheManager manager = CacheManagerBuilder.newCacheManagerBuilder().using((Service)statisticsService).build(true);
        CacheConfigurationBuilder cacheConfigurationBuilder = this.createCacheConfiguration();
        Cache cache = manager.createCache(TIMELINE_METRIC_CACHE_INSTANCE_NAME, (Builder)cacheConfigurationBuilder);
        this.timelineMetricsCache = new TimelineMetricCache((Cache<TimelineAppMetricCacheKey, TimelineMetricsCacheValue>)cache, this.cacheEntryFactory, statisticsService);
        LOG.info("Registering metrics cache with provider: name = timelineMetricCache, manager = " + manager);
        this.isCacheInitialized = true;
    }

    public CacheConfigurationBuilder createCacheConfiguration() {
        LOG.info("Creating Metrics Cache with timeouts => ttl = " + this.configuration.getMetricCacheTTLSeconds() + ", idle = " + this.configuration.getMetricCacheIdleSeconds() + ", cache size = " + this.configuration.getMetricCacheEntryUnitSize());
        TimelineMetricCacheCustomExpiry timelineMetricCacheCustomExpiry = new TimelineMetricCacheCustomExpiry(Duration.ofSeconds(this.configuration.getMetricCacheTTLSeconds()), Duration.ofSeconds(this.configuration.getMetricCacheIdleSeconds()));
        CacheConfigurationBuilder cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(TimelineAppMetricCacheKey.class, TimelineMetricsCacheValue.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)this.configuration.getMetricCacheEntryUnitSize(), (ResourceUnit)EntryUnit.ENTRIES)).withKeySerializer(TimelineAppMetricCacheKeySerializer.class).withValueSerializer(TimelineMetricsCacheValueSerializer.class).withLoaderWriter((CacheLoaderWriter)this.cacheEntryFactory).withExpiry((Expiry)timelineMetricCacheCustomExpiry);
        return cacheConfigurationBuilder;
    }

    public TimelineMetricCache getTimelineMetricsCache() {
        if (this.configuration.isMetricsCacheDisabled()) {
            return null;
        }
        if (!this.isCacheInitialized) {
            this.initializeCache();
        }
        return this.timelineMetricsCache;
    }
}

