/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.timeline.MetricsRequestHelper;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValue;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.http.client.utils.URIBuilder;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheWritingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimelineMetricCacheEntryFactory
implements CacheLoaderWriter<TimelineAppMetricCacheKey, TimelineMetricsCacheValue> {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineMetricCacheEntryFactory.class);
    private MetricsRequestHelper requestHelperForGets;
    private MetricsRequestHelper requestHelperForUpdates;
    private final Long BUFFER_TIME_DIFF_CATCHUP_INTERVAL;

    @Inject
    public TimelineMetricCacheEntryFactory(Configuration configuration) {
        this.requestHelperForGets = new MetricsRequestHelper(new URLStreamProvider(configuration.getMetricsRequestConnectTimeoutMillis(), configuration.getMetricsRequestReadTimeoutMillis(), ComponentSSLConfiguration.instance()));
        this.requestHelperForUpdates = new MetricsRequestHelper(new URLStreamProvider(configuration.getMetricsRequestConnectTimeoutMillis(), configuration.getMetricsRequestIntervalReadTimeoutMillis(), ComponentSSLConfiguration.instance()));
        this.BUFFER_TIME_DIFF_CATCHUP_INTERVAL = configuration.getMetricRequestBufferTimeCatchupInterval();
    }

    public TimelineMetricsCacheValue load(TimelineAppMetricCacheKey key) throws Exception {
        LOG.debug("Creating cache entry since none exists, key = {}", (Object)key);
        TimelineAppMetricCacheKey metricCacheKey = key;
        TimelineMetrics timelineMetrics = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(metricCacheKey.getSpec());
            timelineMetrics = this.requestHelperForGets.fetchTimelineMetrics(uriBuilder, metricCacheKey.getTemporalInfo().getStartTimeMillis(), metricCacheKey.getTemporalInfo().getEndTimeMillis());
        }
        catch (URISyntaxException e) {
            LOG.debug("Caught URISyntaxException on fetching metrics. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (IOException io) {
            LOG.debug("Caught IOException on fetching metrics. {}", (Object)io.getMessage());
            throw io;
        }
        TimelineMetricsCacheValue value = null;
        if (timelineMetrics != null && !timelineMetrics.getMetrics().isEmpty()) {
            value = new TimelineMetricsCacheValue(metricCacheKey.getTemporalInfo().getStartTime(), metricCacheKey.getTemporalInfo().getEndTime(), timelineMetrics, Precision.getPrecision((long)metricCacheKey.getTemporalInfo().getStartTimeMillis(), (long)metricCacheKey.getTemporalInfo().getEndTimeMillis()));
            LOG.debug("Created cache entry: {}", (Object)value);
        }
        return value;
    }

    public void write(TimelineAppMetricCacheKey key, TimelineMetricsCacheValue value) throws Exception {
        TimelineAppMetricCacheKey metricCacheKey = key;
        TimelineMetricsCacheValue existingMetrics = value;
        LOG.debug("Updating cache entry, key: {}, with value = {}", (Object)key, (Object)value);
        Long existingSeriesStartTime = existingMetrics.getStartTime();
        Long existingSeriesEndTime = existingMetrics.getEndTime();
        TemporalInfo newTemporalInfo = metricCacheKey.getTemporalInfo();
        Long requestedStartTime = newTemporalInfo.getStartTimeMillis();
        Long requestedEndTime = newTemporalInfo.getEndTimeMillis();
        URIBuilder uriBuilder = new URIBuilder(metricCacheKey.getSpec());
        Precision requestedPrecision = Precision.getPrecision((long)requestedStartTime, (long)requestedEndTime);
        Precision currentPrecision = existingMetrics.getPrecision();
        Long newStartTime = null;
        Long newEndTime = null;
        if (!requestedPrecision.equals((Object)currentPrecision)) {
            LOG.debug("Precision changed from {} to {}", (Object)currentPrecision, (Object)requestedPrecision);
            newStartTime = requestedStartTime;
            newEndTime = requestedEndTime;
        } else {
            LOG.debug("No change in precision {}", (Object)currentPrecision);
            newStartTime = this.getRefreshRequestStartTime(existingSeriesStartTime, existingSeriesEndTime, requestedStartTime);
            newEndTime = this.getRefreshRequestEndTime(existingSeriesStartTime, existingSeriesEndTime, requestedEndTime);
        }
        if (!(newEndTime <= newStartTime || newStartTime.equals(existingSeriesStartTime) && newEndTime.equals(existingSeriesEndTime) && requestedPrecision.equals((Object)currentPrecision))) {
            LOG.debug("Existing cached timeseries startTime = {}, endTime = {}", (Object)new Date(this.getMillisecondsTime(existingSeriesStartTime)), (Object)new Date(this.getMillisecondsTime(existingSeriesEndTime)));
            LOG.debug("Requested timeseries startTime = {}, endTime = {}", (Object)new Date(this.getMillisecondsTime(newStartTime)), (Object)new Date(this.getMillisecondsTime(newEndTime)));
            uriBuilder.setParameter("startTime", String.valueOf(newStartTime));
            uriBuilder.setParameter("endTime", String.valueOf(newEndTime));
            uriBuilder.setParameter("precision", requestedPrecision.toString());
            try {
                TimelineMetrics newTimeSeries = this.requestHelperForUpdates.fetchTimelineMetrics(uriBuilder, newStartTime, newEndTime);
                this.updateTimelineMetricsInCache(newTimeSeries, existingMetrics, this.getMillisecondsTime(requestedStartTime), this.getMillisecondsTime(requestedEndTime), !currentPrecision.equals((Object)requestedPrecision));
                existingMetrics.setStartTime(requestedStartTime);
                existingMetrics.setEndTime(requestedEndTime);
                existingMetrics.setPrecision(requestedPrecision);
            }
            catch (IOException io) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception retrieving metrics.", (Throwable)io);
                }
                throw io;
            }
        } else {
            LOG.debug("Skip updating cache with new startTime = {}, new endTime = {}", (Object)new Date(this.getMillisecondsTime(newStartTime)), (Object)new Date(this.getMillisecondsTime(newEndTime)));
        }
    }

    protected void updateTimelineMetricsInCache(TimelineMetrics newMetrics, TimelineMetricsCacheValue timelineMetricsCacheValue, Long requestedStartTime, Long requestedEndTime, boolean removeAll) {
        TimelineMetrics existingTimelineMetrics = timelineMetricsCacheValue.getTimelineMetrics();
        this.updateExistingMetricValues(existingTimelineMetrics, requestedStartTime, requestedEndTime, removeAll);
        if (newMetrics != null && !newMetrics.getMetrics().isEmpty()) {
            for (TimelineMetric timelineMetric : newMetrics.getMetrics()) {
                if (LOG.isTraceEnabled()) {
                    TreeMap sortedMetrics = new TreeMap(timelineMetric.getMetricValues());
                    LOG.trace("New metric: {} # {}, startTime = {}, endTime = {}", new Object[]{timelineMetric.getMetricName(), timelineMetric.getMetricValues().size(), sortedMetrics.firstKey(), sortedMetrics.lastKey()});
                }
                TimelineMetric existingMetric = null;
                for (TimelineMetric metric : existingTimelineMetrics.getMetrics()) {
                    if (!metric.equalsExceptTime(timelineMetric)) continue;
                    existingMetric = metric;
                }
                if (existingMetric != null) {
                    existingMetric.getMetricValues().putAll(timelineMetric.getMetricValues());
                    if (!LOG.isTraceEnabled()) continue;
                    TreeMap sortedMetrics = new TreeMap(existingMetric.getMetricValues());
                    LOG.trace("Merged metric: {}, Final size: {}, startTime = {}, endTime = {}", new Object[]{timelineMetric.getMetricName(), existingMetric.getMetricValues().size(), sortedMetrics.firstKey(), sortedMetrics.lastKey()});
                    continue;
                }
                existingTimelineMetrics.getMetrics().add(timelineMetric);
            }
        }
    }

    private void updateExistingMetricValues(TimelineMetrics existingMetrics, Long requestedStartTime, Long requestedEndTime, boolean removeAll) {
        for (TimelineMetric existingMetric : existingMetrics.getMetrics()) {
            if (removeAll) {
                existingMetric.setMetricValues(new TreeMap());
                continue;
            }
            TreeMap existingMetricValues = existingMetric.getMetricValues();
            LOG.trace("Existing metric: {} # {}", (Object)existingMetric.getMetricName(), (Object)existingMetricValues.size());
            existingMetricValues.headMap(requestedStartTime, false).clear();
            existingMetricValues.tailMap(requestedEndTime, false).clear();
        }
    }

    protected Long getRefreshRequestStartTime(Long existingSeriesStartTime, Long existingSeriesEndTime, Long requestedStartTime) {
        Long diff = requestedStartTime - existingSeriesEndTime;
        Long startTime = requestedStartTime;
        if (diff < 0L && requestedStartTime > existingSeriesStartTime) {
            startTime = this.getTimeShiftedStartTime(existingSeriesEndTime);
        }
        LOG.trace("Requesting timeseries data with new startTime = {}", (Object)new Date(this.getMillisecondsTime(startTime)));
        return startTime;
    }

    protected Long getRefreshRequestEndTime(Long existingSeriesStartTime, Long existingSeriesEndTime, Long requestedEndTime) {
        Long endTime = requestedEndTime;
        Long diff = requestedEndTime - existingSeriesEndTime;
        if (diff < 0L && requestedEndTime > existingSeriesStartTime) {
            endTime = existingSeriesStartTime;
        }
        LOG.trace("Requesting timeseries data with new endTime = {}", (Object)new Date(this.getMillisecondsTime(endTime)));
        return endTime;
    }

    private long getTimeShiftedStartTime(long startTime) {
        if (startTime < 9999999999L) {
            return startTime - this.BUFFER_TIME_DIFF_CATCHUP_INTERVAL / 1000L;
        }
        return startTime - this.BUFFER_TIME_DIFF_CATCHUP_INTERVAL;
    }

    private long getMillisecondsTime(long time) {
        if (time < 9999999999L) {
            return time * 1000L;
        }
        return time;
    }

    public void delete(TimelineAppMetricCacheKey key) throws CacheWritingException {
    }

    public Map<TimelineAppMetricCacheKey, TimelineMetricsCacheValue> loadAll(Iterable<? extends TimelineAppMetricCacheKey> keys) throws BulkCacheLoadingException, Exception {
        return null;
    }

    public void writeAll(Iterable<? extends Map.Entry<? extends TimelineAppMetricCacheKey, ? extends TimelineMetricsCacheValue>> entries) throws BulkCacheWritingException, Exception {
    }

    public void deleteAll(Iterable<? extends TimelineAppMetricCacheKey> keys) throws BulkCacheWritingException, Exception {
    }
}

