/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValue;
import java.util.concurrent.TimeUnit;
import org.ehcache.ValueSupplier;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;

public class TimelineMetricCacheCustomExpiry
implements Expiry<TimelineAppMetricCacheKey, TimelineMetricsCacheValue> {
    private final Duration timeToLive;
    private final Duration timeToIdle;

    public TimelineMetricCacheCustomExpiry(java.time.Duration timeToLive, java.time.Duration timeToIdle) {
        this.timeToLive = this.convertJavaDurationToEhcacheDuration(timeToLive);
        this.timeToIdle = this.convertJavaDurationToEhcacheDuration(timeToIdle);
    }

    public Duration getExpiryForCreation(TimelineAppMetricCacheKey key, TimelineMetricsCacheValue value) {
        return this.timeToLive;
    }

    public Duration getExpiryForAccess(TimelineAppMetricCacheKey key, ValueSupplier<? extends TimelineMetricsCacheValue> value) {
        return this.timeToIdle;
    }

    public Duration getExpiryForUpdate(TimelineAppMetricCacheKey key, ValueSupplier<? extends TimelineMetricsCacheValue> oldValue, TimelineMetricsCacheValue newValue) {
        return this.timeToLive;
    }

    private Duration convertJavaDurationToEhcacheDuration(java.time.Duration javaDuration) {
        return Duration.of((long)javaDuration.toNanos(), (TimeUnit)TimeUnit.NANOSECONDS);
    }
}

