/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheEntryFactory;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricsCacheValue;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.ehcache.Cache;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineMetricCache {
    private final Cache<TimelineAppMetricCacheKey, TimelineMetricsCacheValue> cache;
    private final DefaultStatisticsService statisticsService;
    private final TimelineMetricCacheEntryFactory cacheEntryFactory;
    public static final String TIMELINE_METRIC_CACHE_INSTANCE_NAME = "timelineMetricCache";
    private static final Logger LOG = LoggerFactory.getLogger(TimelineMetricCache.class);
    private static AtomicInteger printCacheStatsCounter = new AtomicInteger(0);

    public TimelineMetricCache(Cache<TimelineAppMetricCacheKey, TimelineMetricsCacheValue> cache, TimelineMetricCacheEntryFactory cacheEntryFactory, DefaultStatisticsService statisticsService) {
        this.cache = cache;
        this.cacheEntryFactory = cacheEntryFactory;
        this.statisticsService = statisticsService;
    }

    public TimelineMetrics getAppTimelineMetricsFromCache(TimelineAppMetricCacheKey key) throws IllegalArgumentException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching metrics with key: {}", (Object)key);
        }
        this.validateKey(key);
        TimelineMetricsCacheValue value = null;
        try {
            value = (TimelineMetricsCacheValue)this.cache.get((Object)key);
        }
        catch (CacheLoadingException cle) {
            Throwable t = cle.getCause();
            if (t instanceof SocketTimeoutException) {
                throw new SocketTimeoutException(t.getMessage());
            }
            if (t instanceof IOException) {
                throw new IOException(t.getMessage());
            }
            throw cle;
        }
        TimelineMetrics timelineMetrics = new TimelineMetrics();
        if (value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning value from cache: {}", (Object)value);
            }
            timelineMetrics = value.getTimelineMetrics();
        }
        if (LOG.isDebugEnabled()) {
            if (printCacheStatsCounter.getAndIncrement() == 0) {
                CacheStatistics cacheStatistics = this.statisticsService.getCacheStatistics(TIMELINE_METRIC_CACHE_INSTANCE_NAME);
                if (cacheStatistics == null) {
                    LOG.warn("Cache statistics not available.");
                    return timelineMetrics;
                }
                LOG.debug("Metrics cache stats => \n, Evictions = {}, Expired = {}, Hits = {}, Misses = {}, Hit ratio = {}, Puts = {}", new Object[]{cacheStatistics.getCacheEvictions(), cacheStatistics.getCacheExpirations(), cacheStatistics.getCacheHits(), cacheStatistics.getCacheMisses(), Float.valueOf(cacheStatistics.getCacheHitPercentage()), cacheStatistics.getCachePuts()});
            } else {
                printCacheStatsCounter.compareAndSet(100, 0);
            }
        }
        return timelineMetrics;
    }

    private void validateKey(TimelineAppMetricCacheKey key) throws IllegalArgumentException {
        StringBuilder msg = new StringBuilder("Invalid metric key requested.");
        boolean throwException = false;
        if (key.getTemporalInfo() == null) {
            msg.append(" No temporal info provided.");
            throwException = true;
        }
        if (key.getSpec() == null) {
            msg.append(" Missing call spec for metric request.");
        }
        if (throwException) {
            throw new IllegalArgumentException(msg.toString());
        }
    }
}

