/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline.cache;

import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class TimelineAppMetricCacheKeySerializer
implements Serializer<TimelineAppMetricCacheKey> {
    private final ClassLoader classLoader;

    public TimelineAppMetricCacheKeySerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ByteBuffer serialize(TimelineAppMetricCacheKey key) throws SerializerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(key);
            objectOutputStream.close();
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
    }

    public TimelineAppMetricCacheKey read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binary.array());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (TimelineAppMetricCacheKey)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializerException("Error during deserialization", (Throwable)e);
        }
    }

    public boolean equals(TimelineAppMetricCacheKey key, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binary.array());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            TimelineAppMetricCacheKey deserializedKey = (TimelineAppMetricCacheKey)objectInputStream.readObject();
            if (key == deserializedKey) {
                return true;
            }
            if (deserializedKey == null || key.getClass() != deserializedKey.getClass()) {
                return false;
            }
            if (!key.getMetricNames().equals(deserializedKey.getMetricNames())) {
                return false;
            }
            if (!key.getAppId().equals(deserializedKey.getAppId())) {
                return false;
            }
            return !(key.getHostNames() == null ? deserializedKey.getHostNames() != null : !key.getHostNames().equals(deserializedKey.getHostNames()));
        }
        catch (IOException e) {
            throw new SerializerException("Error during deserialization", (Throwable)e);
        }
    }
}

