/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsRequestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRequestHelper.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader timelineObjectReader;
    private final URLStreamProvider streamProvider;

    public MetricsRequestHelper(URLStreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineMetrics fetchTimelineMetrics(URIBuilder uriBuilder, Long startTime, Long endTime) throws IOException {
        LOG.debug("Metrics request url = {}", (Object)uriBuilder);
        BufferedReader reader = null;
        TimelineMetrics timelineMetrics = null;
        try {
            HttpURLConnection connection = this.streamProvider.processURL(uriBuilder.toString(), "GET", (String)null, Collections.emptyMap());
            if (!this.checkConnectionForPrecisionException(connection)) {
                String higherPrecision = this.getHigherPrecision(uriBuilder, startTime, endTime);
                if (higherPrecision != null) {
                    LOG.debug("Requesting metrics with higher precision : {}", (Object)higherPrecision);
                    uriBuilder.setParameter("precision", higherPrecision);
                    String newSpec = uriBuilder.toString();
                    connection = this.streamProvider.processURL(newSpec, "GET", (String)null, Collections.emptyMap());
                    if (!this.checkConnectionForPrecisionException(connection)) {
                        throw new IOException("Encountered Precision exception : Higher precision request also failed.");
                    }
                } else {
                    throw new IOException("Encountered Precision exception : Unable to request higher precision");
                }
            }
            InputStream inputStream = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            timelineMetrics = (TimelineMetrics)timelineObjectReader.readValue((Reader)reader);
            if (LOG.isTraceEnabled()) {
                for (TimelineMetric metric : timelineMetrics.getMetrics()) {
                    LOG.trace("metric: {}, size = {}, host = {}, app = {}, instance = {}, startTime = {}", new Object[]{metric.getMetricName(), metric.getMetricValues().size(), metric.getHostName(), metric.getAppId(), metric.getInstanceId(), new Date(metric.getStartTime())});
                }
            }
        }
        catch (IOException io) {
            String errorMsg = "Error getting timeline metrics : " + io.getMessage();
            LOG.error(errorMsg);
            if (LOG.isDebugEnabled()) {
                LOG.debug(errorMsg, (Throwable)io);
            }
            if (io instanceof SocketTimeoutException || io instanceof ConnectException) {
                errorMsg = "Cannot connect to collector: SocketTimeoutException for " + uriBuilder.getHost();
                LOG.error(errorMsg);
                throw io;
            }
        }
        catch (URISyntaxException e) {
            String errorMsg = "Error getting timeline metrics : " + e.getMessage();
            LOG.error(errorMsg);
            if (LOG.isDebugEnabled()) {
                LOG.debug(errorMsg, (Throwable)e);
            }
        }
        finally {
            block27: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) break block27;
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Unable to close http input stream : spec=" + uriBuilder, (Throwable)e);
                        }
                        LOG.warn("Unable to close http input stream : spec=" + uriBuilder);
                    }
                }
            }
        }
        return timelineMetrics;
    }

    private boolean checkConnectionForPrecisionException(HttpURLConnection connection) throws IOException, URISyntaxException {
        if (connection != null && connection.getResponseCode() == 400) {
            InputStream errorStream = connection.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
            String errorMessage = reader.readLine();
            if (errorMessage != null && errorMessage.contains("PrecisionLimitExceededException")) {
                LOG.debug("Encountered Precision exception while requesting metrics : {}", (Object)errorMessage);
                return false;
            }
            throw new IOException(errorMessage);
        }
        return true;
    }

    private String getHigherPrecision(URIBuilder uriBuilder, Long startTime, Long endTime) throws URISyntaxException {
        Precision higherPrecision;
        Precision currentPrecision = null;
        List queryParams = uriBuilder.getQueryParams();
        for (NameValuePair nvp : queryParams) {
            if (!nvp.getName().equals("precision")) continue;
            currentPrecision = Precision.getPrecision((String)nvp.getValue());
        }
        if (currentPrecision == null && startTime != null && endTime != null) {
            currentPrecision = Precision.getPrecision((long)startTime, (long)endTime);
        }
        return (higherPrecision = Precision.getHigherPrecision(currentPrecision)) != null ? higherPrecision.toString() : null;
    }

    static {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        timelineObjectReader = mapper.reader(TimelineMetrics.class);
    }
}

