/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsPaddingMethod;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.MetricsRequestHelper;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCache;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.events.MetricsCollectorHostDownEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMSReportPropertyProvider
extends MetricsReportPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AMSReportPropertyProvider.class);
    private MetricsPaddingMethod metricsPaddingMethod;
    private final TimelineMetricCache metricCache;
    MetricsRequestHelper requestHelper;
    private static AtomicInteger printSkipPopulateMsgHostCounter = new AtomicInteger(0);
    private static AtomicInteger printSkipPopulateMsgHostCompCounter = new AtomicInteger(0);
    private OBDPEventPublisher ambariEventPublisher;

    public AMSReportPropertyProvider(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, TimelineMetricCacheProvider cacheProvider, MetricHostProvider hostProvider, String clusterNamePropertyId) {
        super(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId);
        this.metricCache = cacheProvider.getTimelineMetricsCache();
        this.requestHelper = new MetricsRequestHelper(streamProvider);
        if (OBDPServer.getController() != null) {
            this.ambariEventPublisher = OBDPServer.getController().getAmbariEventPublisher();
        }
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        HashSet<String> supportedIds = new HashSet<String>();
        for (String propertyId : propertyIds) {
            if (!propertyId.startsWith("params/padding") && !PropertyHelper.hasAggregateFunctionSuffix(propertyId)) continue;
            supportedIds.add(propertyId);
        }
        propertyIds.removeAll(supportedIds);
        return propertyIds;
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        HashSet<Resource> keepers = new HashSet<Resource>();
        for (Resource resource : resources) {
            this.populateResource(resource, request, predicate);
            keepers.add(resource);
        }
        return keepers;
    }

    private boolean populateResource(Resource resource, Request request, Predicate predicate) throws SystemException {
        String clusterName;
        Set<String> propertyIds = this.getPropertyIds();
        if (propertyIds.isEmpty()) {
            return true;
        }
        this.metricsPaddingMethod = DEFAULT_PADDING_METHOD;
        Set<String> requestPropertyIds = request.getPropertyIds();
        if (requestPropertyIds != null && !requestPropertyIds.isEmpty()) {
            for (String propertyId : requestPropertyIds) {
                if (!propertyId.startsWith("params/padding")) continue;
                String paddingStrategyStr = propertyId.substring("params/padding".length() + 1);
                this.metricsPaddingMethod = new MetricsPaddingMethod(MetricsPaddingMethod.PADDING_STRATEGY.valueOf(paddingStrategyStr));
            }
        }
        if (!this.hostProvider.isCollectorHostLive(clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId), MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            if (printSkipPopulateMsgHostCounter.getAndIncrement() == 0) {
                LOG.info("METRICS_COLLECTOR host is not live. Skip populating resources with metrics, next message will be logged after 1000 attempts.");
            } else {
                printSkipPopulateMsgHostCounter.compareAndSet(1000, 0);
            }
            return true;
        }
        printSkipPopulateMsgHostCompCounter.set(0);
        if (!this.hostProvider.isCollectorComponentLive(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            if (printSkipPopulateMsgHostCompCounter.getAndIncrement() == 0) {
                LOG.info("METRICS_COLLECTOR is not live. Skip populating resources with metrics, next message will be logged after 1000 attempts.");
            } else {
                printSkipPopulateMsgHostCompCounter.compareAndSet(1000, 0);
            }
            return true;
        }
        printSkipPopulateMsgHostCompCounter.set(0);
        this.setProperties(resource, clusterName, request, this.getRequestPropertyIds(request, predicate));
        return true;
    }

    private void setProperties(Resource resource, String clusterName, Request request, Set<String> ids) throws SystemException {
        Map<String, MetricReportRequest> reportRequestMap = this.getPropertyIdMaps(request, ids);
        String host = this.hostProvider.getCollectorHostName(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
        String port = this.hostProvider.getCollectorPort(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
        URIBuilder uriBuilder = AMSPropertyProvider.getAMSUriBuilder(host, port != null ? Integer.parseInt(port) : 6188, this.configuration.isHttpsEnabled());
        for (Map.Entry<String, MetricReportRequest> entry : reportRequestMap.entrySet()) {
            TimelineMetrics timelineMetrics;
            Map<String, String> propertyIdMap;
            TemporalInfo temporalInfo;
            block8: {
                long endTime;
                long startTime;
                MetricReportRequest reportRequest = entry.getValue();
                temporalInfo = reportRequest.getTemporalInfo();
                propertyIdMap = reportRequest.getPropertyIdMap();
                uriBuilder.removeQuery();
                uriBuilder.addParameter("metricNames", MetricsPropertyProvider.getSetString(propertyIdMap.keySet(), -1));
                uriBuilder.setParameter("appId", "HOST");
                if (clusterName != null && this.hostProvider.isCollectorHostExternal(clusterName)) {
                    uriBuilder.setParameter("instanceId", clusterName);
                }
                if ((startTime = temporalInfo.getStartTime().longValue()) != -1L) {
                    uriBuilder.setParameter("startTime", String.valueOf(startTime));
                }
                if ((endTime = temporalInfo.getEndTime().longValue()) != -1L) {
                    uriBuilder.setParameter("endTime", String.valueOf(endTime));
                }
                TimelineAppMetricCacheKey metricCacheKey = new TimelineAppMetricCacheKey(propertyIdMap.keySet(), "HOST", temporalInfo);
                metricCacheKey.setSpec(uriBuilder.toString());
                try {
                    timelineMetrics = this.metricCache != null && metricCacheKey.getTemporalInfo() != null ? this.metricCache.getAppTimelineMetricsFromCache(metricCacheKey) : this.requestHelper.fetchTimelineMetrics(uriBuilder, temporalInfo.getStartTimeMillis(), temporalInfo.getEndTimeMillis());
                }
                catch (IOException io) {
                    timelineMetrics = null;
                    if (!(io instanceof SocketTimeoutException) && !(io instanceof ConnectException)) break block8;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skip populating metrics on socket timeout exception.");
                    }
                    if (this.ambariEventPublisher == null) break;
                    this.ambariEventPublisher.publish(new MetricsCollectorHostDownEvent(clusterName, host));
                    break;
                }
            }
            if (timelineMetrics == null) continue;
            for (TimelineMetric metric : timelineMetrics.getMetrics()) {
                if (metric.getMetricName() == null || metric.getMetricValues() == null) continue;
                TimelineMetric timelineMetricClone = new TimelineMetric(metric);
                this.metricsPaddingMethod.applyPaddingStrategy(timelineMetricClone, temporalInfo);
                String propertyId = propertyIdMap.get(metric.getMetricName());
                if (propertyId == null) continue;
                resource.setProperty(propertyId, AMSReportPropertyProvider.getValue(timelineMetricClone, temporalInfo));
            }
        }
    }

    private Map<String, MetricReportRequest> getPropertyIdMaps(Request request, Set<String> ids) {
        HashMap<String, MetricReportRequest> propertyMap = new HashMap<String, MetricReportRequest>();
        for (String id : ids) {
            Map<String, PropertyInfo> propertyInfoMap = this.getPropertyInfoMap("*", id);
            for (Map.Entry<String, PropertyInfo> entry : propertyInfoMap.entrySet()) {
                PropertyInfo propertyInfo = entry.getValue();
                String propertyId = entry.getKey();
                String amsId = propertyInfo.getAmsId();
                TemporalInfo temporalInfo = request.getTemporalInfo(id);
                if (temporalInfo == null || !propertyInfo.isTemporal()) continue;
                String propertyName = propertyInfo.getPropertyId();
                String report = null;
                int dotIndex = propertyName.lastIndexOf(46);
                if (dotIndex != -1) {
                    report = propertyName.substring(0, dotIndex);
                }
                if (report == null) continue;
                MetricReportRequest reportRequest = (MetricReportRequest)propertyMap.get(report);
                if (reportRequest == null) {
                    reportRequest = new MetricReportRequest();
                    propertyMap.put(report, reportRequest);
                    reportRequest.setTemporalInfo(temporalInfo);
                }
                reportRequest.addPropertyId(amsId, propertyId);
            }
        }
        return propertyMap;
    }

    class MetricReportRequest {
        private TemporalInfo temporalInfo;
        private Map<String, String> propertyIdMap = new HashMap<String, String>();

        MetricReportRequest() {
        }

        public TemporalInfo getTemporalInfo() {
            return this.temporalInfo;
        }

        public void setTemporalInfo(TemporalInfo temporalInfo) {
            this.temporalInfo = temporalInfo;
        }

        public Map<String, String> getPropertyIdMap() {
            return this.propertyIdMap;
        }

        public void addPropertyId(String propertyName, String propertyId) {
            this.propertyIdMap.put(propertyName, propertyId);
        }
    }
}

