/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.timeline;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.timeline.MetricsRequestHelper;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineAppMetricCacheKey;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCache;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.events.MetricsCollectorHostDownEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMSPropertyProvider
extends MetricsPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AMSPropertyProvider.class);
    private static final String METRIC_REGEXP_PATTERN = "\\([^)]*\\)";
    private static final int COLLECTOR_DEFAULT_PORT = 6188;
    private final TimelineMetricCache metricCache;
    private static final Integer HOST_NAMES_BATCH_REQUEST_SIZE = 100;
    private static AtomicInteger printSkipPopulateMsgHostCounter = new AtomicInteger(0);
    private static AtomicInteger printSkipPopulateMsgHostCompCounter = new AtomicInteger(0);
    private static final Map<String, String> timelineAppIdCache = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> JVM_PROCESS_NAMES = ImmutableMap.builder().put((Object)"HBASE_MASTER", (Object)"Master.").put((Object)"HBASE_REGIONSERVER", (Object)"RegionServer.").build();
    private OBDPEventPublisher ambariEventPublisher;

    public AMSPropertyProvider(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, TimelineMetricCacheProvider cacheProvider, MetricHostProvider hostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        super(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
        this.metricCache = cacheProvider.getTimelineMetricsCache();
        if (OBDPServer.getController() != null) {
            this.ambariEventPublisher = OBDPServer.getController().getAmbariEventPublisher();
        }
    }

    protected String getOverridenComponentName(Resource resource) {
        String componentName = this.getComponentName(resource);
        if (componentName.equals("HOST")) {
            return "*";
        }
        return componentName;
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        HashSet<String> supportedIds = new HashSet<String>();
        for (String propertyId : propertyIds) {
            if (!propertyId.startsWith("params/padding") && !PropertyHelper.hasAggregateFunctionSuffix(propertyId)) continue;
            supportedIds.add(propertyId);
        }
        propertyIds.removeAll(supportedIds);
        return propertyIds;
    }

    private List<String> getHostnames(Set<Resource> resources) {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (Resource resource : resources) {
            String hostname = this.getHostName(resource);
            if (hostname == null) continue;
            hostNames.add(hostname);
        }
        return hostNames;
    }

    private Set<String> splitHostNamesInBatches(List<String> hostNames, int batch_size) {
        HashSet<String> hostNamesBatches = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hostNames.size(); ++i) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(hostNames.get(i));
            if ((i + 1) % batch_size != 0) continue;
            hostNamesBatches.add(sb.toString());
            sb = new StringBuilder();
        }
        if (hostNamesBatches.size() == 0 || !"".equals(sb.toString())) {
            hostNamesBatches.add(sb.toString());
        }
        return hostNamesBatches;
    }

    @Override
    public Set<Resource> populateResourcesWithProperties(Set<Resource> resources, Request request, Set<String> propertyIds) throws SystemException {
        Map<String, Map<TemporalInfo, MetricsRequest>> requestMap = this.getMetricsRequests(resources, request, propertyIds);
        block2: for (Map.Entry<String, Map<TemporalInfo, MetricsRequest>> clusterEntry : requestMap.entrySet()) {
            for (MetricsRequest metricsRequest : clusterEntry.getValue().values()) {
                try {
                    metricsRequest.populateResources();
                }
                catch (IOException io) {
                    if (!(io instanceof SocketTimeoutException)) continue;
                    if (!LOG.isDebugEnabled()) continue block2;
                    LOG.debug("Skip populating resources on socket timeout.");
                    continue block2;
                }
            }
        }
        return resources;
    }

    @Override
    public Map<String, Map<String, PropertyInfo>> getComponentMetrics() {
        if (super.getComponentMetrics().containsKey(Role.METRICS_COLLECTOR.name())) {
            return super.getComponentMetrics();
        }
        Map<String, Map<String, PropertyInfo>> metricPropertyIds = this.hostNamePropertyId != null ? PropertyHelper.getMetricPropertyIds(Resource.Type.HostComponent) : PropertyHelper.getMetricPropertyIds(Resource.Type.Component);
        HashMap<String, PropertyInfo> amsMetrics = new HashMap<String, PropertyInfo>();
        if (metricPropertyIds.containsKey(Role.HBASE_MASTER.name())) {
            amsMetrics.putAll(metricPropertyIds.get(Role.HBASE_MASTER.name()));
        }
        if (metricPropertyIds.containsKey(Role.HBASE_REGIONSERVER.name())) {
            amsMetrics.putAll(metricPropertyIds.get(Role.HBASE_REGIONSERVER.name()));
        }
        if (!amsMetrics.isEmpty()) {
            super.getComponentMetrics().putAll(Collections.singletonMap(Role.METRICS_COLLECTOR.name(), amsMetrics));
        }
        return super.getComponentMetrics();
    }

    private Map<String, Map<TemporalInfo, MetricsRequest>> getMetricsRequests(Set<Resource> resources, Request request, Set<String> ids) throws SystemException {
        HashMap<String, Map<TemporalInfo, MetricsRequest>> requestMap = new HashMap<String, Map<TemporalInfo, MetricsRequest>>();
        String collectorPort = null;
        HashMap<String, Boolean> clusterCollectorComponentLiveMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> clusterCollectorHostLiveMap = new HashMap<String, Boolean>();
        for (Resource resource : resources) {
            boolean clusterCollectorComponentLive;
            boolean clusterCollectorHostLive;
            String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
            if (StringUtils.isEmpty((String)clusterName)) continue;
            if (clusterCollectorHostLiveMap.containsKey(clusterName)) {
                clusterCollectorHostLive = (Boolean)clusterCollectorHostLiveMap.get(clusterName);
            } else {
                clusterCollectorHostLive = this.hostProvider.isCollectorComponentLive(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
                clusterCollectorHostLiveMap.put(clusterName, clusterCollectorHostLive);
            }
            if (!clusterCollectorHostLive) {
                if (printSkipPopulateMsgHostCounter.getAndIncrement() == 0) {
                    LOG.info("METRICS_COLLECTOR host is not live. Skip populating resources with metrics, next message will be logged after 1000 attempts.");
                    continue;
                }
                printSkipPopulateMsgHostCounter.compareAndSet(1000, 0);
                continue;
            }
            printSkipPopulateMsgHostCounter.set(0);
            if (clusterCollectorComponentLiveMap.containsKey(clusterName)) {
                clusterCollectorComponentLive = (Boolean)clusterCollectorComponentLiveMap.get(clusterName);
            } else {
                clusterCollectorComponentLive = this.hostProvider.isCollectorComponentLive(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
                clusterCollectorComponentLiveMap.put(clusterName, clusterCollectorComponentLive);
            }
            if (!clusterCollectorComponentLive) {
                if (printSkipPopulateMsgHostCompCounter.getAndIncrement() == 0) {
                    LOG.info("METRICS_COLLECTOR is not live. Skip populating resources with metrics., next message will be logged after 1000 attempts.");
                    continue;
                }
                printSkipPopulateMsgHostCompCounter.compareAndSet(1000, 0);
                continue;
            }
            printSkipPopulateMsgHostCompCounter.set(0);
            HashMap<TemporalInfo, MetricsRequest> requests = (HashMap<TemporalInfo, MetricsRequest>)requestMap.get(clusterName);
            if (requests == null) {
                requests = new HashMap<TemporalInfo, MetricsRequest>();
                requestMap.put(clusterName, requests);
            }
            String collectorHost = this.hostProvider.getCollectorHostName(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
            if (collectorPort == null) {
                collectorPort = this.hostProvider.getCollectorPort(clusterName, MetricsServiceProvider.MetricsService.TIMELINE_METRICS);
            }
            for (String id : ids) {
                HashMap<String, PropertyInfo> propertyInfoMap = new HashMap<String, PropertyInfo>();
                String componentName = this.getOverridenComponentName(resource);
                Map<String, PropertyInfo> componentMetricMap = this.getComponentMetrics().get(componentName);
                if (componentMetricMap != null && !componentMetricMap.containsKey(id)) {
                    this.updateComponentMetricMap(componentMetricMap, id);
                }
                this.updatePropertyInfoMap(componentName, id, propertyInfoMap);
                for (Map.Entry entry : propertyInfoMap.entrySet()) {
                    String propertyId = (String)entry.getKey();
                    PropertyInfo propertyInfo = (PropertyInfo)entry.getValue();
                    TemporalInfo temporalInfo = request.getTemporalInfo(id);
                    if ((temporalInfo != null || !propertyInfo.isPointInTime()) && (temporalInfo == null || !propertyInfo.isTemporal())) continue;
                    MetricsRequest metricsRequest = (MetricsRequest)requests.get(temporalInfo);
                    if (metricsRequest == null) {
                        metricsRequest = new MetricsRequest(temporalInfo, AMSPropertyProvider.getAMSUriBuilder(collectorHost, collectorPort != null ? Integer.parseInt(collectorPort) : 6188, this.configuration.isHttpsEnabled()), (String)resource.getPropertyValue(this.clusterNamePropertyId));
                        requests.put(temporalInfo, metricsRequest);
                    }
                    metricsRequest.putResource(this.getComponentName(resource), resource);
                    metricsRequest.putPropertyId(this.preprocessPropertyId(propertyInfo.getPropertyId(), this.getComponentName(resource)), propertyId);
                    metricsRequest.linkResourceToMetric(this.getComponentName(resource), this.preprocessPropertyId(propertyInfo.getPropertyId(), this.getComponentName(resource)));
                    if (!propertyInfo.isAmsHostMetric()) continue;
                    metricsRequest.putHosComponentHostMetric(propertyInfo.getPropertyId());
                }
            }
        }
        return requestMap;
    }

    private String preprocessPropertyId(String propertyId, String componentName) {
        if (propertyId.startsWith("jvm") && JVM_PROCESS_NAMES.keySet().contains(componentName)) {
            String newPropertyId = propertyId.replace("jvm.", "jvm." + JVM_PROCESS_NAMES.get(componentName));
            LOG.debug("Pre-process: {}, to: {}", (Object)propertyId, (Object)newPropertyId);
            return newPropertyId;
        }
        return propertyId;
    }

    static URIBuilder getAMSUriBuilder(String hostname, int port, boolean httpsEnabled) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(httpsEnabled ? "https" : "http");
        uriBuilder.setHost(hostname);
        uriBuilder.setPort(port);
        uriBuilder.setPath("/ws/v1/timeline/metrics");
        return uriBuilder;
    }

    static /* synthetic */ URLStreamProvider access$000(AMSPropertyProvider x0) {
        return x0.streamProvider;
    }

    class MetricsRequest {
        private final TemporalInfo temporalInfo;
        private final Map<String, Set<Resource>> resources = new HashMap<String, Set<Resource>>();
        private final Map<String, Set<String>> metrics = new HashMap<String, Set<String>>();
        private final URIBuilder uriBuilder;
        Set<String> resolvedMetricsParams;
        MetricsRequestHelper requestHelper = new MetricsRequestHelper(AMSPropertyProvider.access$000(AMSPropertyProvider.this));
        private final Set<String> hostComponentHostMetrics = new HashSet<String>();
        private String clusterName;
        private Map<String, Set<String>> componentMetricMap = new HashMap<String, Set<String>>();

        private MetricsRequest(TemporalInfo temporalInfo, URIBuilder uriBuilder, String clusterName) {
            this.temporalInfo = temporalInfo;
            this.uriBuilder = uriBuilder;
            this.clusterName = clusterName;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void putResource(String componentName, Resource resource) {
            Set<Resource> resourceSet = this.resources.get(componentName);
            if (resourceSet == null) {
                resourceSet = new HashSet<Resource>();
                this.resources.put(componentName, resourceSet);
            }
            resourceSet.add(resource);
        }

        public void putPropertyId(String metric, String id) {
            Set<String> propertyIds = this.metrics.get(metric);
            if (propertyIds == null) {
                propertyIds = new HashSet<String>();
                this.metrics.put(metric, propertyIds);
            }
            propertyIds.add(id);
        }

        public void putHosComponentHostMetric(String metric) {
            if (metric != null) {
                this.hostComponentHostMetrics.add(metric);
            }
        }

        private TimelineMetrics getTimelineMetricsFromCache(TimelineAppMetricCacheKey metricCacheKey, String componentName) throws IOException {
            if (AMSPropertyProvider.this.metricCache != null && !StringUtils.isEmpty((String)componentName) && !componentName.equalsIgnoreCase("HOST") && metricCacheKey.getTemporalInfo() != null) {
                return AMSPropertyProvider.this.metricCache.getAppTimelineMetricsFromCache(metricCacheKey);
            }
            Long startTime = metricCacheKey.getTemporalInfo() != null ? metricCacheKey.getTemporalInfo().getStartTimeMillis() : null;
            Long endTime = metricCacheKey.getTemporalInfo() != null ? metricCacheKey.getTemporalInfo().getEndTimeMillis() : null;
            return this.requestHelper.fetchTimelineMetrics(this.uriBuilder, startTime, endTime);
        }

        public Collection<Resource> populateResources() throws SystemException, IOException {
            if (this.temporalInfo != null && (this.temporalInfo.getStartTime() == null || this.temporalInfo.getEndTime() == null)) {
                return Collections.emptySet();
            }
            for (Map.Entry<String, Set<Resource>> resourceEntry : this.resources.entrySet()) {
                String componentName = resourceEntry.getKey();
                Set<Resource> resourceSet = resourceEntry.getValue();
                TimelineMetrics timelineMetrics = new TimelineMetrics();
                Set<String> nonHostComponentMetrics = this.componentMetricMap.get(componentName);
                if (nonHostComponentMetrics == null) {
                    nonHostComponentMetrics = new HashSet<String>();
                }
                nonHostComponentMetrics.removeAll(this.hostComponentHostMetrics);
                Set<String> hostNamesBatches = AMSPropertyProvider.this.splitHostNamesInBatches(AMSPropertyProvider.this.getHostnames(this.resources.get(componentName)), HOST_NAMES_BATCH_REQUEST_SIZE);
                HashMap metricsMap = new HashMap();
                for (String hostNamesBatch : hostNamesBatches) {
                    String hostnameTmp;
                    block15: {
                        try {
                            TimelineMetrics metricsResponse;
                            if (!this.hostComponentHostMetrics.isEmpty()) {
                                String hostComponentHostMetricParams = MetricsPropertyProvider.getSetString(this.processRegexps(this.hostComponentHostMetrics), -1);
                                this.setQueryParams(hostComponentHostMetricParams, hostNamesBatch, true, componentName);
                                metricsResponse = this.getTimelineMetricsFromCache(this.getTimelineAppMetricCacheKey(this.hostComponentHostMetrics, componentName, hostNamesBatch, this.uriBuilder.toString()), componentName);
                                if (metricsResponse != null) {
                                    timelineMetrics.getMetrics().addAll(metricsResponse.getMetrics());
                                }
                            }
                            if (!nonHostComponentMetrics.isEmpty()) {
                                String nonHostComponentHostMetricParams = MetricsPropertyProvider.getSetString(this.processRegexps(nonHostComponentMetrics), -1);
                                this.setQueryParams(nonHostComponentHostMetricParams, hostNamesBatch, false, componentName);
                                metricsResponse = this.getTimelineMetricsFromCache(this.getTimelineAppMetricCacheKey(nonHostComponentMetrics, componentName, hostNamesBatch, this.uriBuilder.toString()), componentName);
                                if (metricsResponse != null) {
                                    timelineMetrics.getMetrics().addAll(metricsResponse.getMetrics());
                                }
                            }
                        }
                        catch (IOException io) {
                            if (!(io instanceof SocketTimeoutException) && !(io instanceof ConnectException)) break block15;
                            if (AMSPropertyProvider.this.ambariEventPublisher != null) {
                                AMSPropertyProvider.this.ambariEventPublisher.publish(new MetricsCollectorHostDownEvent(this.clusterName, this.uriBuilder.getHost()));
                            }
                            throw io;
                        }
                    }
                    Set<String> patterns = this.createPatterns(this.metrics.keySet());
                    if (timelineMetrics.getMetrics().isEmpty()) continue;
                    for (TimelineMetric metric : timelineMetrics.getMetrics()) {
                        if (metric.getMetricName() == null || metric.getMetricValues() == null || !this.checkMetricName(patterns, metric.getMetricName())) continue;
                        hostnameTmp = metric.getHostName();
                        if (!metricsMap.containsKey(hostnameTmp)) {
                            metricsMap.put(hostnameTmp, new HashSet());
                        }
                        ((Set)metricsMap.get(hostnameTmp)).add(metric);
                    }
                    for (Resource resource : resourceSet) {
                        hostnameTmp = AMSPropertyProvider.this.getHostName(resource);
                        if (!metricsMap.containsKey(hostnameTmp)) continue;
                        for (TimelineMetric metric : (Set)metricsMap.get(hostnameTmp)) {
                            TimelineMetric timelineMetricClone = new TimelineMetric(metric);
                            AMSPropertyProvider.this.metricsPaddingMethod.applyPaddingStrategy(timelineMetricClone, this.temporalInfo);
                            this.populateResource(resource, timelineMetricClone, this.temporalInfo);
                        }
                    }
                }
            }
            return Collections.emptySet();
        }

        private String getTimelineAppId(String componentName) {
            if (timelineAppIdCache.containsKey(componentName)) {
                return timelineAppIdCache.get(componentName);
            }
            try {
                OBDPManagementController managementController = OBDPServer.getController();
                Cluster cluster = managementController.getClusters().getCluster(this.clusterName);
                Service service = cluster.getServiceByComponentName(componentName);
                StackId stackId = service.getDesiredStackId();
                if (stackId != null) {
                    String serviceName;
                    String stackName = stackId.getStackName();
                    String version = stackId.getStackVersion();
                    OBDPMetaInfo obdpMetaInfo = managementController.getAmbariMetaInfo();
                    String timeLineAppId = obdpMetaInfo.getComponent(stackName, version, serviceName = service.getName(), componentName).getTimelineAppid();
                    if (timeLineAppId != null) {
                        timelineAppIdCache.put(componentName, timeLineAppId);
                        return timeLineAppId;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return componentName;
        }

        private void setQueryParams(String metricsParam, String hostname, boolean isHostMetric, String componentName) {
            this.uriBuilder.removeQuery();
            if (metricsParam.length() > 0) {
                this.uriBuilder.setParameter("metricNames", metricsParam);
                this.resolvedMetricsParams = Sets.newHashSet((Object[])metricsParam.split(","));
            }
            if (hostname != null && !hostname.isEmpty()) {
                this.uriBuilder.setParameter("hostname", hostname);
            }
            if (isHostMetric) {
                this.uriBuilder.setParameter("appId", "HOST");
            } else {
                if (componentName != null && !componentName.isEmpty() && !componentName.equalsIgnoreCase("HOST")) {
                    componentName = this.getTimelineAppId(componentName);
                }
                this.uriBuilder.setParameter("appId", componentName);
            }
            if (this.clusterName != null && AMSPropertyProvider.this.hostProvider.isCollectorHostExternal(this.clusterName)) {
                this.uriBuilder.setParameter("instanceId", this.clusterName);
            }
            if (this.temporalInfo != null) {
                long endTime;
                long startTime = this.temporalInfo.getStartTime();
                if (startTime != -1L) {
                    this.uriBuilder.setParameter("startTime", String.valueOf(startTime));
                }
                if ((endTime = this.temporalInfo.getEndTime().longValue()) != -1L) {
                    this.uriBuilder.setParameter("endTime", String.valueOf(endTime));
                }
            }
        }

        private Set<String> createPatterns(Set<String> rawNames) {
            Pattern pattern = Pattern.compile(AMSPropertyProvider.METRIC_REGEXP_PATTERN);
            HashSet<String> result = new HashSet<String>();
            for (String rawName : rawNames) {
                Matcher matcher = pattern.matcher(rawName);
                StringBuilder sb = new StringBuilder();
                int lastPos = 0;
                while (matcher.find()) {
                    sb.append(Pattern.quote(rawName.substring(lastPos, matcher.start())));
                    sb.append(matcher.group());
                    lastPos = matcher.end();
                }
                sb.append(Pattern.quote(rawName.substring(lastPos)));
                result.add(sb.toString());
            }
            return result;
        }

        private boolean checkMetricName(Set<String> patterns, String name) {
            for (String pattern : patterns) {
                if (!Pattern.matches(pattern, name)) continue;
                return true;
            }
            return false;
        }

        private Set<String> processRegexps(Set<String> metricNames) {
            HashSet<String> result = new HashSet<String>();
            for (String name : metricNames) {
                result.add(name.replaceAll(AMSPropertyProvider.METRIC_REGEXP_PATTERN, Matcher.quoteReplacement("%")));
            }
            return result;
        }

        private void populateResource(Resource resource, TimelineMetric metric, TemporalInfo temporalInfo) {
            Map<String, PropertyInfo> metricsMap;
            String metric_name = metric.getMetricName();
            Set<String> propertyIdSet = this.metrics.get(metric_name);
            LinkedList<String> parameterList = new LinkedList<String>();
            if (propertyIdSet == null) {
                for (Map.Entry<String, Set<String>> entry : this.metrics.entrySet()) {
                    String key = entry.getKey();
                    Pattern pattern = Pattern.compile(key);
                    Matcher matcher = pattern.matcher(metric_name);
                    if (!matcher.matches()) continue;
                    propertyIdSet = entry.getValue();
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        parameterList.add(matcher.group(i + 1));
                    }
                }
            }
            if (propertyIdSet != null && (metricsMap = AMSPropertyProvider.this.getComponentMetrics().get(AMSPropertyProvider.this.getOverridenComponentName(resource))) != null) {
                for (String propertyId : propertyIdSet) {
                    Object value;
                    String instanceId;
                    if (propertyId == null || !metricsMap.containsKey(propertyId)) continue;
                    if (AMSPropertyProvider.this.containsArguments(propertyId)) {
                        int i = 1;
                        if (!parameterList.isEmpty()) {
                            for (String param : parameterList) {
                                propertyId = AMSPropertyProvider.substituteArgument(propertyId, "$" + i, param);
                                ++i;
                            }
                        } else {
                            propertyId = AMSPropertyProvider.substituteArgument(propertyId, "$1", metric.getInstanceId());
                        }
                    } else if (metric.getInstanceId() != null && !propertyId.contains(instanceId = (instanceId = metric.getInstanceId()).matches("^\\w+\\..+$") ? instanceId.split("\\.")[1] : "")) continue;
                    if ((value = AMSPropertyProvider.getValue(metric, temporalInfo)) == null || AMSPropertyProvider.this.containsArguments(propertyId)) continue;
                    resource.setProperty(propertyId, value);
                }
            }
        }

        private TimelineAppMetricCacheKey getTimelineAppMetricCacheKey(Set<String> metrics, String hostnames, String componentName, String spec) {
            TimelineAppMetricCacheKey metricCacheKey = new TimelineAppMetricCacheKey(metrics, componentName, hostnames, this.temporalInfo);
            metricCacheKey.setSpec(spec);
            return metricCacheKey;
        }

        public void linkResourceToMetric(String componentName, String metric) {
            if (this.componentMetricMap.get(componentName) == null) {
                this.componentMetricMap.put(componentName, new HashSet<String>(Arrays.asList(metric)));
            } else {
                this.componentMetricMap.get(componentName).add(metric);
            }
        }
    }
}

