/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.ganglia;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaMetric;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReportPropertyProvider
extends MetricsReportPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GangliaReportPropertyProvider.class);

    public GangliaReportPropertyProvider(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, StreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId) {
        super(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId);
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        HashSet<Resource> keepers = new HashSet<Resource>();
        for (Resource resource : resources) {
            this.populateResource(resource, request, predicate);
            keepers.add(resource);
        }
        return keepers;
    }

    private void populateResource(Resource resource, Request request, Predicate predicate) throws SystemException {
        Set<String> propertyIds = this.getPropertyIds();
        if (propertyIds.isEmpty()) {
            return;
        }
        String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
        if (this.hostProvider.getCollectorHostName(clusterName, MetricsServiceProvider.MetricsService.GANGLIA) == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Attempting to get metrics but the Ganglia server is unknown. Resource=" + resource + " : Cluster=" + clusterName);
            }
            return;
        }
        this.setProperties(resource, clusterName, request, this.getRequestPropertyIds(request, predicate));
    }

    private boolean setProperties(Resource resource, String clusterName, Request request, Set<String> ids) throws SystemException {
        Map<String, Map<String, String>> propertyIdMaps = this.getPropertyIdMaps(request, ids);
        for (Map.Entry<String, Map<String, String>> entry : propertyIdMaps.entrySet()) {
            Map<String, String> map = entry.getValue();
            String report = entry.getKey();
            String spec = this.getSpec(clusterName, report);
            try {
                List gangliaMetrics = (List)new ObjectMapper().readValue(this.streamProvider.readFrom(spec), (TypeReference)new TypeReference<List<GangliaMetric>>(){});
                if (gangliaMetrics == null) continue;
                for (GangliaMetric gangliaMetric : gangliaMetrics) {
                    String propertyId = map.get(gangliaMetric.getMetric_name());
                    if (propertyId == null) continue;
                    resource.setProperty(propertyId, this.getValue(gangliaMetric));
                }
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Caught exception getting Ganglia metrics : " + e + " : spec=" + spec);
                }
                return false;
            }
        }
        return true;
    }

    private Map<String, Map<String, String>> getPropertyIdMaps(Request request, Set<String> ids) {
        HashMap<String, Map<String, String>> propertyMap = new HashMap<String, Map<String, String>>();
        for (String id : ids) {
            Map<String, PropertyInfo> propertyInfoMap = this.getPropertyInfoMap("*", id);
            for (Map.Entry<String, PropertyInfo> entry : propertyInfoMap.entrySet()) {
                String propertyId = entry.getKey();
                PropertyInfo propertyInfo = entry.getValue();
                TemporalInfo temporalInfo = request.getTemporalInfo(id);
                if (temporalInfo == null || !propertyInfo.isTemporal()) continue;
                String propertyName = propertyInfo.getPropertyId();
                String report = null;
                int dotIndex = propertyName.lastIndexOf(46);
                if (dotIndex != -1) {
                    report = propertyName.substring(0, dotIndex);
                    propertyName = propertyName.substring(dotIndex + 1);
                }
                if (report == null) continue;
                HashMap<String, String> map = (HashMap<String, String>)propertyMap.get(report);
                if (map == null) {
                    map = new HashMap<String, String>();
                    propertyMap.put(report, map);
                }
                map.put(propertyName, propertyId);
            }
        }
        return propertyMap;
    }

    private Object getValue(GangliaMetric metric) {
        return metric.getDatapoints();
    }

    protected String getSpec(String clusterName, String report) throws SystemException {
        StringBuilder sb = new StringBuilder();
        if (this.configuration.isHttpsEnabled()) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(this.hostProvider.getCollectorHostName(clusterName, MetricsServiceProvider.MetricsService.GANGLIA)).append("/ganglia/graph.php?g=").append(report).append("&json=1");
        return sb.toString();
    }
}

