/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.ganglia;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaMetric;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GangliaPropertyProvider
extends MetricsPropertyProvider {
    static final Map<String, List<String>> GANGLIA_CLUSTER_NAME_MAP = new HashMap<String, List<String>>();
    private static final Logger LOG;

    public GangliaPropertyProvider(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        super(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
    }

    @Override
    public Set<Resource> populateResourcesWithProperties(Set<Resource> resources, Request request, Set<String> propertyIds) throws SystemException {
        Map<String, Map<TemporalInfo, RRDRequest>> requestMap = this.getRRDRequests(resources, request, propertyIds);
        for (Map.Entry<String, Map<TemporalInfo, RRDRequest>> clusterEntry : requestMap.entrySet()) {
            for (RRDRequest rrdRequest : clusterEntry.getValue().values()) {
                rrdRequest.populateResources();
            }
        }
        return resources;
    }

    protected abstract Set<String> getGangliaClusterNames(Resource var1, String var2);

    protected String getComponentNamePropertyId() {
        return this.componentNamePropertyId;
    }

    protected String getHostNamePropertyId() {
        return this.hostNamePropertyId;
    }

    public StreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    private Map<String, Map<TemporalInfo, RRDRequest>> getRRDRequests(Set<Resource> resources, Request request, Set<String> ids) {
        HashMap<String, Map<TemporalInfo, RRDRequest>> requestMap = new HashMap<String, Map<TemporalInfo, RRDRequest>>();
        for (Resource resource : resources) {
            String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
            HashMap<TemporalInfo, RRDRequest> requests = (HashMap<TemporalInfo, RRDRequest>)requestMap.get(clusterName);
            if (requests == null) {
                requests = new HashMap<TemporalInfo, RRDRequest>();
                requestMap.put(clusterName, requests);
            }
            Set<String> gangliaClusterNames = this.getGangliaClusterNames(resource, clusterName);
            for (String gangliaClusterName : gangliaClusterNames) {
                ResourceKey key = new ResourceKey(this.getHostName(resource), gangliaClusterName);
                for (String id : ids) {
                    HashMap<String, PropertyInfo> propertyInfoMap = new HashMap<String, PropertyInfo>();
                    Map<String, PropertyInfo> componentMetricMap = this.getComponentMetrics().get(this.getComponentName(resource));
                    if (componentMetricMap != null && !componentMetricMap.containsKey(id)) {
                        this.updateComponentMetricMap(componentMetricMap, id);
                    }
                    this.updatePropertyInfoMap(this.getComponentName(resource), id, propertyInfoMap);
                    for (Map.Entry entry : propertyInfoMap.entrySet()) {
                        String propertyId = (String)entry.getKey();
                        PropertyInfo propertyInfo = (PropertyInfo)entry.getValue();
                        TemporalInfo temporalInfo = request.getTemporalInfo(id);
                        if ((temporalInfo != null || !propertyInfo.isPointInTime()) && (temporalInfo == null || !propertyInfo.isTemporal())) continue;
                        RRDRequest rrdRequest = (RRDRequest)requests.get(temporalInfo);
                        if (rrdRequest == null) {
                            rrdRequest = new RRDRequest(clusterName, temporalInfo);
                            requests.put(temporalInfo, rrdRequest);
                        }
                        rrdRequest.putResource(key, resource);
                        rrdRequest.putPropertyId(propertyInfo.getPropertyId(), propertyId);
                    }
                }
            }
        }
        return requestMap;
    }

    private String getSpec(String clusterName, Set<String> clusterSet, Set<String> hostSet, Set<String> metricSet, TemporalInfo temporalInfo) throws SystemException {
        String clusters = GangliaPropertyProvider.getSetString(clusterSet, -1);
        String hosts = GangliaPropertyProvider.getSetString(hostSet, -1);
        String metrics = GangliaPropertyProvider.getSetString(metricSet, -1);
        URIBuilder uriBuilder = new URIBuilder();
        if (this.configuration.isHttpsEnabled()) {
            uriBuilder.setScheme("https");
        } else {
            uriBuilder.setScheme("http");
        }
        uriBuilder.setHost(this.hostProvider.getCollectorHostName(clusterName, MetricsServiceProvider.MetricsService.GANGLIA));
        uriBuilder.setPath("/cgi-bin/rrd.py");
        uriBuilder.setParameter("c", clusters);
        if (hosts.length() > 0) {
            uriBuilder.setParameter("h", hosts);
        }
        if (metrics.length() > 0) {
            uriBuilder.setParameter("m", metrics);
        } else {
            uriBuilder.setParameter("m", ".*");
        }
        if (temporalInfo != null) {
            long step;
            long endTime;
            long startTime = temporalInfo.getStartTime();
            if (startTime != -1L) {
                uriBuilder.setParameter("s", String.valueOf(startTime));
            }
            if ((endTime = temporalInfo.getEndTime().longValue()) != -1L) {
                uriBuilder.setParameter("e", String.valueOf(endTime));
            }
            if ((step = temporalInfo.getStep().longValue()) != -1L) {
                uriBuilder.setParameter("r", String.valueOf(step));
            }
        } else {
            uriBuilder.setParameter("e", "now");
            uriBuilder.setParameter("pt", "true");
        }
        return uriBuilder.toString();
    }

    private static Object getValue(GangliaMetric metric, boolean isTemporal) {
        Number[][] dataPoints = metric.getDatapoints();
        int length = dataPoints.length;
        if (isTemporal) {
            return length > 0 ? dataPoints : null;
        }
        return length > 0 ? (Number)dataPoints[length - 1][0] : (Number)0;
    }

    static {
        GANGLIA_CLUSTER_NAME_MAP.put("NAMENODE", Collections.singletonList("HDPNameNode"));
        GANGLIA_CLUSTER_NAME_MAP.put("DATANODE", Arrays.asList("HDPDataNode", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("JOBTRACKER", Collections.singletonList("HDPJobTracker"));
        GANGLIA_CLUSTER_NAME_MAP.put("TASKTRACKER", Arrays.asList("HDPTaskTracker", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("RESOURCEMANAGER", Collections.singletonList("HDPResourceManager"));
        GANGLIA_CLUSTER_NAME_MAP.put("NODEMANAGER", Arrays.asList("HDPNodeManager", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("HISTORYSERVER", Collections.singletonList("HDPHistoryServer"));
        GANGLIA_CLUSTER_NAME_MAP.put("HBASE_MASTER", Collections.singletonList("HDPHBaseMaster"));
        GANGLIA_CLUSTER_NAME_MAP.put("HBASE_REGIONSERVER", Arrays.asList("HDPHBaseRegionServer", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("FLUME_HANDLER", Arrays.asList("HDPFlumeServer", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("JOURNALNODE", Arrays.asList("HDPJournalNode", "HDPSlaves"));
        GANGLIA_CLUSTER_NAME_MAP.put("NIMBUS", Collections.singletonList("HDPNimbus"));
        GANGLIA_CLUSTER_NAME_MAP.put("SUPERVISOR", Collections.singletonList("HDPSupervisor"));
        LOG = LoggerFactory.getLogger(GangliaPropertyProvider.class);
    }

    private class RRDRequest {
        private static final int POPULATION_TIME_UPPER_LIMIT = 5;
        private final String clusterName;
        private final TemporalInfo temporalInfo;
        private final Map<ResourceKey, Set<Resource>> resources = new HashMap<ResourceKey, Set<Resource>>();
        private final Map<String, Set<String>> metrics = new HashMap<String, Set<String>>();
        private final Set<String> clusterSet = new HashSet<String>();
        private final Set<String> hostSet = new HashSet<String>();

        private RRDRequest(String clusterName, TemporalInfo temporalInfo) {
            this.clusterName = clusterName;
            this.temporalInfo = temporalInfo;
        }

        public void putResource(ResourceKey key, Resource resource) {
            this.clusterSet.add(key.getClusterName());
            this.hostSet.add(key.getHostName());
            Set<Resource> resourceSet = this.resources.get(key);
            if (resourceSet == null) {
                resourceSet = new HashSet<Resource>();
                this.resources.put(key, resourceSet);
            }
            resourceSet.add(resource);
        }

        public void putPropertyId(String metric, String id) {
            Set<String> propertyIds = this.metrics.get(metric);
            if (propertyIds == null) {
                propertyIds = new HashSet<String>();
                this.metrics.put(metric, propertyIds);
            }
            propertyIds.add(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Resource> populateResources() throws SystemException {
            String specWithParams = GangliaPropertyProvider.this.getSpec(this.clusterName, this.clusterSet, this.hostSet, this.metrics.keySet(), this.temporalInfo);
            String spec = null;
            String params = null;
            String[] tokens = questionMarkPattern.split(specWithParams, 2);
            try {
                spec = tokens[0];
                params = tokens[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.info(e.toString());
            }
            BufferedReader reader = null;
            try {
                if (!GangliaPropertyProvider.this.hostProvider.isCollectorHostLive(this.clusterName, MetricsServiceProvider.MetricsService.GANGLIA)) {
                    LOG.info("Ganglia host is not live");
                    Set<Resource> set = Collections.emptySet();
                    return set;
                }
                if (!GangliaPropertyProvider.this.hostProvider.isCollectorComponentLive(this.clusterName, MetricsServiceProvider.MetricsService.GANGLIA)) {
                    LOG.info("Ganglia server component is not live");
                    Set<Resource> set = Collections.emptySet();
                    return set;
                }
                reader = new BufferedReader(new InputStreamReader(GangliaPropertyProvider.this.getStreamProvider().readFrom(spec, "POST", params)));
                String feedStart = reader.readLine();
                if (feedStart == null || feedStart.isEmpty()) {
                    LOG.info("Empty feed while getting ganglia metrics for spec => " + spec);
                    Set<Resource> e = Collections.emptySet();
                    return e;
                }
                int startTime = this.convertToNumber(feedStart).intValue();
                String dsName = reader.readLine();
                if (dsName == null || dsName.isEmpty()) {
                    LOG.info("Feed without body while reading ganglia metrics for spec => " + spec);
                    Set<Resource> set = Collections.emptySet();
                    return set;
                }
                while (!"[~EOF]".equals(dsName)) {
                    GangliaMetric metric = new GangliaMetric();
                    ArrayList<GangliaMetric.TemporalMetric> listTemporalMetrics = new ArrayList<GangliaMetric.TemporalMetric>();
                    metric.setDs_name(dsName);
                    metric.setCluster_name(reader.readLine());
                    metric.setHost_name(reader.readLine());
                    metric.setMetric_name(reader.readLine());
                    String timeStr = reader.readLine();
                    String stepStr = reader.readLine();
                    if (timeStr == null || timeStr.isEmpty() || stepStr == null || stepStr.isEmpty()) {
                        LOG.info("Unexpected end of stream reached while getting ganglia metrics for spec => " + spec);
                        Set<Resource> set = Collections.emptySet();
                        return set;
                    }
                    int time = this.convertToNumber(timeStr).intValue();
                    int step = this.convertToNumber(stepStr).intValue();
                    String val = reader.readLine();
                    String lastVal = null;
                    while (val != null && !"[~EOM]".equals(val)) {
                        if (val.startsWith("[~r]")) {
                            int repeat = Integer.parseInt(val.substring(4)) - 1;
                            for (int i = 0; i < repeat; ++i) {
                                GangliaMetric.TemporalMetric tm;
                                if (!"[~n]".equals(lastVal) && (tm = new GangliaMetric.TemporalMetric(lastVal, time)).isValid()) {
                                    listTemporalMetrics.add(tm);
                                }
                                time += step;
                            }
                        } else {
                            GangliaMetric.TemporalMetric tm;
                            if (!"[~n]".equals(val) && (tm = new GangliaMetric.TemporalMetric(val, time)).isValid()) {
                                listTemporalMetrics.add(tm);
                            }
                            time += step;
                        }
                        lastVal = val;
                        val = reader.readLine();
                    }
                    metric.setDatapointsFromList(listTemporalMetrics);
                    ResourceKey key = new ResourceKey(metric.getHost_name(), metric.getCluster_name());
                    Set<Resource> resourceSet = this.resources.get(key);
                    if (resourceSet != null) {
                        for (Resource resource : resourceSet) {
                            this.populateResource(resource, metric);
                        }
                    }
                    if ((dsName = reader.readLine()) != null && !dsName.isEmpty()) continue;
                    LOG.info("Unexpected end of stream reached while getting ganglia metrics for spec => " + spec);
                    Set set = Collections.emptySet();
                    return set;
                }
                String feedEnd = reader.readLine();
                if (feedEnd == null || feedEnd.isEmpty()) {
                    LOG.info("Error reading end of feed while getting ganglia metrics for spec => " + spec);
                } else {
                    int endTime = this.convertToNumber(feedEnd).intValue();
                    int totalTime = endTime - startTime;
                    if (LOG.isInfoEnabled() && totalTime > 5) {
                        LOG.info("Ganglia resource population time: " + totalTime);
                    }
                }
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Caught exception getting Ganglia metrics : spec=" + spec);
                }
            }
            finally {
                block51: {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isWarnEnabled()) break block51;
                            LOG.warn("Unable to close http input steam : spec=" + spec, (Throwable)e);
                        }
                    }
                }
            }
            return Collections.emptySet();
        }

        private void populateResource(Resource resource, GangliaMetric gangliaMetric) {
            Map<String, PropertyInfo> metricsMap;
            String metric_name = gangliaMetric.getMetric_name();
            Set<String> propertyIdSet = null;
            LinkedList<String> parameterList = null;
            if (metric_name != null) {
                propertyIdSet = this.metrics.get(metric_name);
                parameterList = new LinkedList<String>();
                if (propertyIdSet == null) {
                    for (Map.Entry<String, Set<String>> entry : this.metrics.entrySet()) {
                        String key = entry.getKey();
                        Pattern pattern = Pattern.compile(key);
                        Matcher matcher = pattern.matcher(metric_name);
                        if (!matcher.matches()) continue;
                        propertyIdSet = entry.getValue();
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            parameterList.add(matcher.group(i + 1));
                        }
                    }
                }
            }
            if (propertyIdSet != null && (metricsMap = GangliaPropertyProvider.this.getComponentMetrics().get(GangliaPropertyProvider.this.getComponentName(resource))) != null) {
                for (String propertyId : propertyIdSet) {
                    Object value;
                    if (propertyId == null || !metricsMap.containsKey(propertyId)) continue;
                    if (GangliaPropertyProvider.this.containsArguments(propertyId)) {
                        int i = 1;
                        for (String param : parameterList) {
                            propertyId = GangliaPropertyProvider.substituteArgument(propertyId, "$" + i, param);
                            ++i;
                        }
                    }
                    if ((value = GangliaPropertyProvider.getValue(gangliaMetric, this.temporalInfo != null)) == null) continue;
                    resource.setProperty(propertyId, value);
                }
            }
        }

        private Number convertToNumber(String s) {
            return s.contains(".") ? Double.parseDouble(s) : (double)Long.parseLong(s);
        }
    }

    private static class ResourceKey {
        private final String hostName;
        private final String gangliaClusterName;

        private ResourceKey(String hostName, String gangliaClusterName) {
            this.hostName = hostName;
            this.gangliaClusterName = gangliaClusterName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getClusterName() {
            return this.gangliaClusterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)o;
            return !(this.gangliaClusterName == null ? that.gangliaClusterName != null : !this.gangliaClusterName.equals(that.gangliaClusterName)) && !(this.hostName == null ? that.hostName != null : !this.hostName.equals(that.hostName));
        }

        public int hashCode() {
            int result = this.hostName != null ? this.hostName.hashCode() : 0;
            result = 31 * result + (this.gangliaClusterName != null ? this.gangliaClusterName.hashCode() : 0);
            return result;
        }
    }
}

