/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics.ganglia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GangliaMetric {
    private String ds_name;
    private String cluster_name;
    private String graph_type;
    private String host_name;
    private String metric_name;
    private Number[][] datapoints;
    private static final Set<String> PERCENTAGE_METRIC;

    public String getDs_name() {
        return this.ds_name;
    }

    public void setDs_name(String ds_name) {
        this.ds_name = ds_name;
    }

    public String getCluster_name() {
        return this.cluster_name;
    }

    public void setCluster_name(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public String getGraph_type() {
        return this.graph_type;
    }

    public void setGraph_type(String graph_type) {
        this.graph_type = graph_type;
    }

    public String getHost_name() {
        return this.host_name;
    }

    public void setHost_name(String host_name) {
        this.host_name = host_name;
    }

    public String getMetric_name() {
        return this.metric_name;
    }

    public void setMetric_name(String metric_name) {
        this.metric_name = metric_name;
    }

    public Number[][] getDatapoints() {
        return this.datapoints;
    }

    public void setDatapoints(Number[][] datapoints) {
        this.datapoints = datapoints;
    }

    public void setDatapointsFromList(List<TemporalMetric> listTemporalMetrics) {
        Number[][] datapointsArray = new Number[listTemporalMetrics.size()][2];
        int cnt = 0;
        if (PERCENTAGE_METRIC.contains(this.metric_name)) {
            firstIndex = 0;
            lastIndex = listTemporalMetrics.size() - 1;
            for (i = firstIndex; i <= lastIndex; ++i) {
                m = listTemporalMetrics.get(i);
                Number val = m.getValue();
                if (!(100.0 >= val.doubleValue())) continue;
                datapointsArray[cnt][0] = val;
                datapointsArray[cnt][1] = m.getTime();
                ++cnt;
            }
        } else {
            firstIndex = 0;
            lastIndex = listTemporalMetrics.size() - 1;
            for (i = firstIndex; i <= lastIndex; ++i) {
                m = listTemporalMetrics.get(i);
                datapointsArray[i][0] = m.getValue();
                datapointsArray[i][1] = m.getTime();
                ++cnt;
            }
        }
        this.datapoints = new Number[cnt][2];
        for (int i = 0; i < this.datapoints.length; ++i) {
            this.datapoints[i][0] = datapointsArray[i][0];
            this.datapoints[i][1] = datapointsArray[i][1];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("name=");
        stringBuilder.append(this.ds_name);
        stringBuilder.append("\n");
        stringBuilder.append("cluster name=");
        stringBuilder.append(this.cluster_name);
        stringBuilder.append("\n");
        stringBuilder.append("graph type=");
        stringBuilder.append(this.graph_type);
        stringBuilder.append("\n");
        stringBuilder.append("host name=");
        stringBuilder.append(this.host_name);
        stringBuilder.append("\n");
        stringBuilder.append("api name=");
        stringBuilder.append(this.metric_name);
        stringBuilder.append("\n");
        stringBuilder.append("datapoints (value/timestamp):");
        stringBuilder.append("\n");
        boolean first = true;
        stringBuilder.append("[");
        for (Number[] m : this.datapoints) {
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append("[");
            stringBuilder.append(m[0]);
            stringBuilder.append(",");
            stringBuilder.append(m[1].longValue());
            stringBuilder.append("]");
            first = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("cpu_wio");
        temp.add("cpu_idle");
        temp.add("cpu_nice");
        temp.add("cpu_aidle");
        temp.add("cpu_system");
        temp.add("cpu_user");
        PERCENTAGE_METRIC = Collections.unmodifiableSet(temp);
    }

    public static class TemporalMetric {
        private Number m_value;
        private Number m_time;
        private boolean valid = true;

        public boolean isValid() {
            return this.valid;
        }

        public TemporalMetric(String value, Number time) {
            try {
                this.m_value = this.convertToNumber(value);
            }
            catch (NumberFormatException e) {
                this.valid = false;
            }
            this.m_time = time;
        }

        public Number getValue() {
            return this.m_value;
        }

        public Number getTime() {
            return this.m_time;
        }

        private Number convertToNumber(String s) throws NumberFormatException {
            Number res;
            if (s.contains(".")) {
                Double d = Double.parseDouble(s);
                if (d.isNaN() || d.isInfinite()) {
                    throw new NumberFormatException(s);
                }
                res = d;
            } else {
                res = Long.parseLong(s);
            }
            return res;
        }
    }
}

