/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.AbstractPropertyProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.BufferedThreadPoolExecutorCompletionService;
import id.onyx.obdp.server.controller.utilities.ScalingThreadPoolExecutor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadPoolEnabledPropertyProvider
extends AbstractPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolEnabledPropertyProvider.class);
    public static final Set<String> healthyStates = Collections.singleton("STARTED");
    protected final String hostNamePropertyId;
    private final MetricHostProvider metricHostProvider;
    private final String clusterNamePropertyId;
    private static ThreadPoolExecutor EXECUTOR_SERVICE;
    private static int THREAD_POOL_CORE_SIZE;
    private static int THREAD_POOL_MAX_SIZE;
    private static int THREAD_POOL_WORKER_QUEUE_SIZE;
    private static long COMPLETION_SERVICE_POLL_TIMEOUT;
    private static final long THREAD_POOL_TIMEOUT_MILLIS = 30000L;
    private static final Cache<String, Throwable> exceptionsCache;

    @Inject
    public static void init(Configuration configuration) {
        THREAD_POOL_CORE_SIZE = configuration.getPropertyProvidersThreadPoolCoreSize();
        THREAD_POOL_MAX_SIZE = configuration.getPropertyProvidersThreadPoolMaxSize();
        THREAD_POOL_WORKER_QUEUE_SIZE = configuration.getPropertyProvidersWorkerQueueSize();
        COMPLETION_SERVICE_POLL_TIMEOUT = configuration.getPropertyProvidersCompletionServiceTimeout();
        EXECUTOR_SERVICE = ThreadPoolEnabledPropertyProvider.initExecutorService();
    }

    public ThreadPoolEnabledPropertyProvider(Map<String, Map<String, PropertyInfo>> componentMetrics, String hostNamePropertyId, MetricHostProvider metricHostProvider, String clusterNamePropertyId) {
        super(componentMetrics);
        this.hostNamePropertyId = hostNamePropertyId;
        this.metricHostProvider = metricHostProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
    }

    private static ThreadPoolExecutor initExecutorService() {
        ScalingThreadPoolExecutor threadPoolExecutor = new ScalingThreadPoolExecutor(THREAD_POOL_CORE_SIZE, THREAD_POOL_MAX_SIZE, 30000L, TimeUnit.MILLISECONDS, THREAD_POOL_WORKER_QUEUE_SIZE);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("obdp-property-provider-thread-%d").build();
        threadPoolExecutor.setThreadFactory(threadFactory);
        return threadPoolExecutor;
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        if (!this.checkAuthorizationForMetrics(resources, this.clusterNamePropertyId)) {
            return resources;
        }
        Ticket ticket = new Ticket();
        BufferedThreadPoolExecutorCompletionService<Resource> completionService = new BufferedThreadPoolExecutorCompletionService<Resource>(EXECUTOR_SERVICE);
        for (Resource resource : resources) {
            completionService.submit(this.getPopulateResourceCallable(resource, request, predicate, ticket));
        }
        HashSet<Resource> keepers = new HashSet<Resource>();
        try {
            for (int i = 0; i < resources.size(); ++i) {
                Future resourceFuture = completionService.poll(COMPLETION_SERVICE_POLL_TIMEOUT, TimeUnit.MILLISECONDS);
                if (resourceFuture == null) {
                    ticket.invalidate();
                    LOG.error("Timed out after waiting {}ms waiting for request {}", (Object)COMPLETION_SERVICE_POLL_TIMEOUT, (Object)request);
                    break;
                }
                Resource resource = (Resource)resourceFuture.get();
                if (resource == null) continue;
                keepers.add(resource);
            }
        }
        catch (InterruptedException e) {
            ThreadPoolEnabledPropertyProvider.logException(e);
        }
        catch (ExecutionException e) {
            ThreadPoolEnabledPropertyProvider.rethrowSystemException(e.getCause());
        }
        return keepers;
    }

    private Callable<Resource> getPopulateResourceCallable(final Resource resource, final Request request, final Predicate predicate, final Ticket ticket) {
        return new Callable<Resource>(){

            @Override
            public Resource call() throws SystemException {
                return ThreadPoolEnabledPropertyProvider.this.populateResource(resource, request, predicate, ticket);
            }
        };
    }

    protected abstract Resource populateResource(Resource var1, Request var2, Predicate var3, Ticket var4) throws SystemException;

    protected void setPopulateTimeout(long populateTimeout) {
        COMPLETION_SERVICE_POLL_TIMEOUT = populateTimeout;
    }

    protected static boolean isRequestedPropertyId(String propertyId, String requestedPropertyId, Request request) {
        return request.getPropertyIds().isEmpty() || propertyId.startsWith(requestedPropertyId);
    }

    protected static String getCacheKeyForException(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Throwable t : Throwables.getCausalChain((Throwable)throwable)) {
            if (t != null) {
                sb.append(t.getClass().getName());
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    protected static String logException(final Throwable throwable) {
        final String msg = "Caught exception getting metrics : " + throwable.getLocalizedMessage();
        String cacheKey = ThreadPoolEnabledPropertyProvider.getCacheKeyForException(throwable);
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, throwable);
        } else {
            try {
                exceptionsCache.get((Object)cacheKey, (Callable)new Callable<Throwable>(){

                    @Override
                    public Throwable call() {
                        LOG.error(msg + ", skipping same exceptions for next 5 minutes", throwable);
                        return throwable;
                    }
                });
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return msg;
    }

    protected static void rethrowSystemException(Throwable throwable) throws SystemException {
        String msg = ThreadPoolEnabledPropertyProvider.logException(throwable);
        if (throwable instanceof SystemException) {
            throw (SystemException)throwable;
        }
        throw new SystemException(msg, throwable);
    }

    public String getHost(Resource resource, String clusterName, String componentName) throws SystemException {
        return this.hostNamePropertyId == null ? this.metricHostProvider.getHostName(clusterName, componentName) : (String)resource.getPropertyValue(this.hostNamePropertyId);
    }

    protected String getSpec(String protocol, String hostName, String port, String url) {
        return protocol + "://" + hostName + ":" + port + url;
    }

    static {
        exceptionsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    }

    protected static class Ticket {
        private volatile boolean valid = true;

        protected Ticket() {
        }

        public void invalidate() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

