/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.ThreadPoolEnabledPropertyProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.services.MetricsRetrievalService;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMetricsPropertyProvider
extends ThreadPoolEnabledPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RestMetricsPropertyProvider.class);
    @Inject
    private OBDPManagementController amc;
    @Inject
    private Clusters clusters;
    @Inject
    private Gson gson;
    @Inject
    private MetricsRetrievalService metricsRetrievalService;
    private final Map<String, String> metricsProperties;
    private final StreamProvider streamProvider;
    private final String clusterNamePropertyId;
    private final String componentNamePropertyId;
    private final String statePropertyId;
    private final String componentName;
    private static final String DEFAULT_PORT_PROPERTY = "default_port";
    private static final String PORT_CONFIG_TYPE_PROPERTY = "port_config_type";
    private static final String PORT_PROPERTY_NAME_PROPERTY = "port_property_name";
    private static final String HTTPS_PORT_PROPERTY_NAME_PROPERTY = "https_port_property_name";
    private static final String PROTOCOL_OVERRIDE_PROPERTY = "protocol";
    private static final String HTTPS_PROTOCOL_PROPERTY = "https_property_name";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String DEFAULT_PROTOCOL = "http";
    public static final String URL_PATH_SEPARATOR = "##";
    public static final String DOCUMENT_PATH_SEPARATOR = "#";

    @AssistedInject
    RestMetricsPropertyProvider(@Assisted(value="metricsProperties") Map<String, String> metricsProperties, @Assisted(value="componentMetrics") Map<String, Map<String, PropertyInfo>> componentMetrics, @Assisted(value="streamProvider") StreamProvider streamProvider, @Assisted(value="metricHostProvider") MetricHostProvider metricHostProvider, @Assisted(value="clusterNamePropertyId") String clusterNamePropertyId, @Assisted(value="hostNamePropertyId") @Nullable String hostNamePropertyId, @Assisted(value="componentNamePropertyId") String componentNamePropertyId, @Assisted(value="statePropertyId") @Nullable String statePropertyId, @Assisted(value="componentName") @Nullable String componentName) {
        super(componentMetrics, hostNamePropertyId, metricHostProvider, clusterNamePropertyId);
        this.metricsProperties = metricsProperties;
        this.streamProvider = streamProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
        this.componentNamePropertyId = componentNamePropertyId;
        this.statePropertyId = statePropertyId;
        this.componentName = componentName;
    }

    @Override
    protected Resource populateResource(Resource resource, Request request, Predicate predicate, ThreadPoolEnabledPropertyProvider.Ticket ticket) throws SystemException {
        String state;
        Set<String> ids = this.getRequestPropertyIds(request, predicate);
        HashSet<String> temporalIds = new HashSet<String>();
        String resourceComponentName = (String)resource.getPropertyValue(this.componentNamePropertyId);
        if (!this.componentName.equals(resourceComponentName)) {
            return resource;
        }
        for (String id : ids) {
            if (request.getTemporalInfo(id) == null) continue;
            temporalIds.add(id);
        }
        ids.removeAll(temporalIds);
        if (ids.isEmpty()) {
            return resource;
        }
        if (this.statePropertyId != null && (state = (String)resource.getPropertyValue(this.statePropertyId)) != null && !healthyStates.contains(state)) {
            return resource;
        }
        Map<String, PropertyInfo> propertyInfos = this.getComponentMetrics().get("WRAPPED_METRICS_KEY");
        if (propertyInfos == null) {
            return resource;
        }
        String protocol = null;
        String port = "-1";
        String hostname = null;
        try {
            String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
            Cluster cluster = this.clusters.getCluster(clusterName);
            hostname = this.getHost(resource, clusterName, resourceComponentName);
            if (hostname == null) {
                String msg = String.format("Unable to get component REST metrics. No host name for %s.", resourceComponentName);
                LOG.warn(msg);
                return resource;
            }
            protocol = this.resolveProtocol(cluster, hostname);
            port = this.resolvePort(cluster, hostname, resourceComponentName, this.metricsProperties, protocol);
        }
        catch (Exception e) {
            RestMetricsPropertyProvider.rethrowSystemException(e);
        }
        HashSet<String> resultIds = new HashSet<String>();
        for (String id : ids) {
            for (String metricId : propertyInfos.keySet()) {
                if (!metricId.startsWith(id)) continue;
                resultIds.add(metricId);
            }
        }
        HashMap<String, Set<String>> urls = this.extractPropertyURLs(resultIds, propertyInfos);
        for (String url : urls.keySet()) {
            String spec = this.getSpec(protocol, hostname, port, url);
            this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.REST, this.streamProvider, spec);
            Map<String, String> jsonMap = this.metricsRetrievalService.getCachedRESTMetric(spec);
            if (null == jsonMap) {
                return resource;
            }
            if (!ticket.isValid()) {
                return resource;
            }
            try {
                this.extractValuesFromJSON(jsonMap, urls.get(url), resource, propertyInfos);
            }
            catch (OBDPException ambariException) {
                OBDPException detailedException = new OBDPException(String.format("Unable to get REST metrics from the for %s at %s", resourceComponentName, spec), (Throwable)ambariException);
                RestMetricsPropertyProvider.logException(detailedException);
            }
        }
        return resource;
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        HashSet<String> unsupported = new HashSet<String>();
        for (String propertyId : propertyIds) {
            if (this.getComponentMetrics().get("WRAPPED_METRICS_KEY").containsKey(propertyId)) continue;
            unsupported.add(propertyId);
        }
        return unsupported;
    }

    protected String resolvePort(Cluster cluster, String hostname, String componentName, Map<String, String> metricsProperties, String protocol) throws OBDPException {
        String portStr;
        String portConfigType = null;
        String portPropertyNameInMetricsProperties = protocol.equalsIgnoreCase(HTTPS_PROTOCOL) ? HTTPS_PORT_PROPERTY_NAME_PROPERTY : PORT_PROPERTY_NAME_PROPERTY;
        String portPropertyName = null;
        if (metricsProperties.containsKey(PORT_CONFIG_TYPE_PROPERTY) && metricsProperties.containsKey(portPropertyNameInMetricsProperties)) {
            portConfigType = metricsProperties.get(PORT_CONFIG_TYPE_PROPERTY);
            portPropertyName = metricsProperties.get(portPropertyNameInMetricsProperties);
        }
        if ((portStr = this.getPropertyValueByNameAndConfigType(portPropertyName, portConfigType, cluster, hostname)) == null) {
            if (metricsProperties.containsKey(DEFAULT_PORT_PROPERTY)) {
                portStr = metricsProperties.get(DEFAULT_PORT_PROPERTY);
            } else {
                String message = String.format("Can not determine REST port for component %s. Default REST port property %s is not defined at metrics.json file for service, and there is no any other available ways to determine port information.", componentName, DEFAULT_PORT_PROPERTY);
                throw new OBDPException(message);
            }
        }
        return portStr;
    }

    private String getPropertyValueByNameAndConfigType(String propertyName, String configType, Cluster cluster, String hostname) {
        String result = null;
        if (configType != null && propertyName != null) {
            try {
                Map<String, Map<String, String>> properties;
                Map<String, String> config;
                Map<String, Map<String, String>> configTags = this.amc.findConfigurationTagsWithOverrides(cluster, hostname, null);
                if (configTags.containsKey(configType) && (config = (properties = this.amc.getConfigHelper().getEffectiveConfigProperties(cluster, Collections.singletonMap(configType, configTags.get(configType)))).get(configType)) != null && config.containsKey(propertyName)) {
                    result = config.get(propertyName);
                }
            }
            catch (OBDPException e) {
                String message = String.format("Can not extract configs for component = %s, hostname = %s, config type = %s, property name = %s", this.componentName, hostname, configType, propertyName);
                LOG.warn(message, (Throwable)e);
            }
            if (result == null) {
                String message = String.format("Can not extract property for component %s from configurations. Config tag = %s, config key name = %s, hostname = %s. Probably metrics.json file for service is misspelled.", this.componentName, configType, propertyName, hostname);
                LOG.debug(message);
            }
        }
        return result;
    }

    private String resolveProtocol(Cluster cluster, String hostname) {
        String protocol = "http";
        if (this.metricsProperties.containsKey(PORT_CONFIG_TYPE_PROPERTY) && this.metricsProperties.containsKey(HTTPS_PROTOCOL_PROPERTY)) {
            String configType = this.metricsProperties.get(PORT_CONFIG_TYPE_PROPERTY);
            String propertyName = this.metricsProperties.get(HTTPS_PROTOCOL_PROPERTY);
            String value = this.getPropertyValueByNameAndConfigType(propertyName, configType, cluster, hostname);
            if (value != null) {
                return HTTPS_PROTOCOL;
            }
        }
        if (this.metricsProperties.containsKey(PROTOCOL_OVERRIDE_PROPERTY)) {
            protocol = this.metricsProperties.get(PROTOCOL_OVERRIDE_PROPERTY).toLowerCase();
            if (!protocol.equals("http") && !protocol.equals(HTTPS_PROTOCOL)) {
                String message = String.format("Unsupported protocol type %s, falling back to %s", protocol, "http");
                LOG.warn(message);
                protocol = "http";
            }
        } else {
            protocol = "http";
        }
        return protocol;
    }

    private String extractMetricsURL(String metricsPath) throws IllegalArgumentException {
        return this.validateAndExtractPathParts(metricsPath)[0];
    }

    private String extractDocumentPath(String metricsPath) throws IllegalArgumentException {
        return this.validateAndExtractPathParts(metricsPath)[1];
    }

    private String[] validateAndExtractPathParts(String metricsPath) throws IllegalArgumentException {
        String[] pathParts = metricsPath.split(URL_PATH_SEPARATOR);
        if (pathParts.length == 2) {
            return pathParts;
        }
        String message = String.format("Metrics path %s does not contain or containsmore than one %s sequence. That probably means that the mentioned metrics path is misspelled. Please check the relevant metrics.json file", metricsPath, URL_PATH_SEPARATOR);
        throw new IllegalArgumentException(message);
    }

    private HashMap<String, Set<String>> extractPropertyURLs(Set<String> ids, Map<String, PropertyInfo> propertyInfos) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String requestedPropertyId : ids) {
            Set<Object> set;
            PropertyInfo propertyInfo = propertyInfos.get(requestedPropertyId);
            String metricsPath = propertyInfo.getPropertyId();
            String url = this.extractMetricsURL(metricsPath);
            if (!result.containsKey(url)) {
                set = new HashSet();
                result.put(url, set);
            } else {
                set = result.get(url);
            }
            set.add(requestedPropertyId);
        }
        return result;
    }

    private void extractValuesFromJSON(Map<String, String> jsonMap, Set<String> requestedPropertyIds, Resource resource, Map<String, PropertyInfo> propertyInfos) throws OBDPException {
        Type type = new TypeToken<Map<Object, Object>>(){}.getType();
        for (String requestedPropertyId : requestedPropertyIds) {
            PropertyInfo propertyInfo = propertyInfos.get(requestedPropertyId);
            String metricsPath = propertyInfo.getPropertyId();
            String documentPath = this.extractDocumentPath(metricsPath);
            String[] docPath = documentPath.split(DOCUMENT_PATH_SEPARATOR);
            Map subMap = jsonMap;
            for (int i = 0; i < docPath.length; ++i) {
                String pathElement = docPath[i];
                if (!subMap.containsKey(pathElement)) {
                    String message = String.format("Can not fetch %dth element of document path (%s) from json. Wrong metrics path: %s", i, pathElement, metricsPath);
                    throw new OBDPException(message);
                }
                String jsonSubElement = jsonMap.get(pathElement);
                if (i == docPath.length - 1) {
                    resource.setProperty(requestedPropertyId, jsonSubElement);
                    continue;
                }
                subMap = (Map)this.gson.fromJson((JsonElement)jsonSubElement, type);
            }
        }
    }
}

