/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.AbstractPropertyProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import java.util.Map;
import java.util.Set;

public class MetricsReportPropertyProviderProxy
extends AbstractPropertyProvider {
    private MetricsReportPropertyProvider amsMetricsReportProvider;
    private MetricsReportPropertyProvider gangliaMetricsReportProvider;
    private final MetricsServiceProvider metricsServiceProvider;
    private TimelineMetricCacheProvider cacheProvider;
    private String clusterNamePropertyId;

    public MetricsReportPropertyProviderProxy(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, TimelineMetricCacheProvider cacheProvider, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId) {
        super(componentPropertyInfoMap);
        this.metricsServiceProvider = serviceProvider;
        this.cacheProvider = cacheProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
        this.createReportPropertyProviders(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId);
    }

    private void createReportPropertyProviders(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId) {
        this.amsMetricsReportProvider = new AMSReportPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, this.cacheProvider, hostProvider, clusterNamePropertyId);
        this.gangliaMetricsReportProvider = new GangliaReportPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        MetricsServiceProvider.MetricsService metricsService = this.metricsServiceProvider.getMetricsServiceType();
        Set<String> checkedPropertyIds = super.checkPropertyIds(propertyIds);
        if (metricsService != null && metricsService.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            return this.amsMetricsReportProvider.checkPropertyIds(checkedPropertyIds);
        }
        return checkedPropertyIds;
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        if (!this.checkAuthorizationForMetrics(resources, this.clusterNamePropertyId)) {
            return resources;
        }
        MetricsServiceProvider.MetricsService metricsService = this.metricsServiceProvider.getMetricsServiceType();
        if (metricsService != null) {
            if (metricsService.equals((Object)MetricsServiceProvider.MetricsService.GANGLIA)) {
                return this.gangliaMetricsReportProvider.populateResources(resources, request, predicate);
            }
            if (metricsService.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
                return this.amsMetricsReportProvider.populateResources(resources, request, predicate);
            }
        }
        return resources;
    }
}

