/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.AbstractPropertyProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaComponentPropertyProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaHostComponentPropertyProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaHostPropertyProvider;
import id.onyx.obdp.server.controller.metrics.ganglia.GangliaPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSComponentPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSHostComponentPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSHostPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.AMSPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import java.util.Map;
import java.util.Set;

public class MetricsPropertyProviderProxy
extends AbstractPropertyProvider {
    private final MetricsServiceProvider metricsServiceProvider;
    private AMSPropertyProvider amsPropertyProvider;
    private GangliaPropertyProvider gangliaPropertyProvider;
    private TimelineMetricCacheProvider cacheProvider;
    private String clusterNamePropertyId;

    public MetricsPropertyProviderProxy(Resource.InternalType type, Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, TimelineMetricCacheProvider cacheProvider, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        super(componentPropertyInfoMap);
        this.metricsServiceProvider = serviceProvider;
        this.cacheProvider = cacheProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
        switch (type) {
            case Host: {
                this.createHostPropertyProviders(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId);
                break;
            }
            case HostComponent: {
                this.createHostComponentPropertyProviders(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
                break;
            }
            case Component: {
                this.createComponentPropertyProviders(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, componentNamePropertyId);
                break;
            }
        }
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        MetricsServiceProvider.MetricsService metricsService = this.metricsServiceProvider.getMetricsServiceType();
        Set<String> checkedPropertyIds = super.checkPropertyIds(propertyIds);
        if (metricsService != null && metricsService.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            return this.amsPropertyProvider.checkPropertyIds(checkedPropertyIds);
        }
        return checkedPropertyIds;
    }

    private void createHostPropertyProviders(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId, String hostNamePropertyId) {
        this.amsPropertyProvider = new AMSHostPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, this.cacheProvider, hostProvider, clusterNamePropertyId, hostNamePropertyId);
        this.gangliaPropertyProvider = new GangliaHostPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId);
    }

    private void createHostComponentPropertyProviders(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        this.amsPropertyProvider = new AMSHostComponentPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, this.cacheProvider, hostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
        this.gangliaPropertyProvider = new GangliaHostComponentPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
    }

    private void createComponentPropertyProviders(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId, String componentNamePropertyId) {
        this.amsPropertyProvider = new AMSComponentPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, this.cacheProvider, hostProvider, clusterNamePropertyId, componentNamePropertyId);
        this.gangliaPropertyProvider = new GangliaComponentPropertyProvider(componentPropertyInfoMap, streamProvider, configuration, hostProvider, clusterNamePropertyId, componentNamePropertyId);
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        if (!this.checkAuthorizationForMetrics(resources, this.clusterNamePropertyId)) {
            return resources;
        }
        MetricsServiceProvider.MetricsService metricsService = this.metricsServiceProvider.getMetricsServiceType();
        if (metricsService != null) {
            if (metricsService.equals((Object)MetricsServiceProvider.MetricsService.GANGLIA)) {
                return this.gangliaPropertyProvider.populateResources(resources, request, predicate);
            }
            if (metricsService.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
                return this.amsPropertyProvider.populateResources(resources, request, predicate);
            }
        }
        return resources;
    }
}

