/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.AbstractPropertyProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsPaddingMethod;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProviderProxy;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricsPropertyProvider
extends AbstractPropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsPropertyProvider.class);
    protected static final Pattern questionMarkPattern = Pattern.compile("\\?");
    protected final URLStreamProvider streamProvider;
    protected final MetricHostProvider hostProvider;
    protected final String clusterNamePropertyId;
    protected final String hostNamePropertyId;
    protected final String componentNamePropertyId;
    protected final ComponentSSLConfiguration configuration;
    protected MetricsPaddingMethod metricsPaddingMethod;
    private static final MetricsPaddingMethod DEFAULT_PADDING_METHOD = new MetricsPaddingMethod(MetricsPaddingMethod.PADDING_STRATEGY.ZEROS);

    protected MetricsPropertyProvider(Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        super(componentPropertyInfoMap);
        this.streamProvider = streamProvider;
        this.configuration = configuration;
        this.hostProvider = hostProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
        this.hostNamePropertyId = hostNamePropertyId;
        this.componentNamePropertyId = componentNamePropertyId;
    }

    public static MetricsPropertyProviderProxy createInstance(Resource.Type type, Map<String, Map<String, PropertyInfo>> componentPropertyInfoMap, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, TimelineMetricCacheProvider cacheProvider, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        if (type.isInternalType()) {
            return new MetricsPropertyProviderProxy(type.getInternalType(), componentPropertyInfoMap, streamProvider, configuration, cacheProvider, hostProvider, serviceProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
        }
        return null;
    }

    protected abstract String getHostName(Resource var1);

    protected abstract String getComponentName(Resource var1);

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        Set<String> ids = this.getRequestPropertyIds(request, predicate);
        if (ids.isEmpty()) {
            return resources;
        }
        if (!this.checkAuthorizationForMetrics(resources, this.clusterNamePropertyId)) {
            return resources;
        }
        this.metricsPaddingMethod = DEFAULT_PADDING_METHOD;
        Set<String> requestPropertyIds = request.getPropertyIds();
        if (requestPropertyIds != null && !requestPropertyIds.isEmpty()) {
            for (String propertyId : requestPropertyIds) {
                if (!propertyId.startsWith("params/padding")) continue;
                String paddingStrategyStr = propertyId.substring("params/padding".length() + 1);
                this.metricsPaddingMethod = new MetricsPaddingMethod(MetricsPaddingMethod.PADDING_STRATEGY.valueOf(paddingStrategyStr));
            }
        }
        return this.populateResourcesWithProperties(resources, request, ids);
    }

    protected abstract Set<Resource> populateResourcesWithProperties(Set<Resource> var1, Request var2, Set<String> var3) throws SystemException;

    public static String getSetString(Set<String> set, int limit) {
        StringBuilder sb = new StringBuilder();
        if (limit == -1 || set.size() <= limit) {
            for (String cluster : set) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(cluster);
            }
        }
        return sb.toString();
    }
}

