/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.controller.spi.TemporalInfo;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class MetricsPaddingMethod {
    private final PADDING_STRATEGY strategy;
    public static final String ZERO_PADDING_PARAM = "params/padding";
    private static final long MINIMUM_STEP_INTERVAL = 999L;

    public MetricsPaddingMethod(PADDING_STRATEGY strategy) {
        this.strategy = strategy;
    }

    public void applyPaddingStrategy(TimelineMetric metric, TemporalInfo temporalInfo) {
        long counter;
        if (this.strategy.equals((Object)PADDING_STRATEGY.NONE) || temporalInfo == null) {
            return;
        }
        TreeMap values = metric.getMetricValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        long intervalStartTime = this.longToMillis(temporalInfo.getStartTime());
        long intervalEndTime = this.longToMillis(temporalInfo.getEndTime());
        long dataStartTime = this.longToMillis((Long)values.firstKey());
        long dataEndTime = this.longToMillis((Long)values.lastKey());
        long dataInterval = this.getTimelineMetricInterval(values, intervalStartTime, intervalEndTime);
        if (dataInterval == -1L || dataInterval < 999L) {
            long l = dataInterval = temporalInfo.getStep() != null ? temporalInfo.getStep() : -1L;
        }
        if (dataInterval == -1L) {
            return;
        }
        Double paddingValue = 0.0;
        if (this.strategy.equals((Object)PADDING_STRATEGY.NULLS)) {
            paddingValue = null;
        }
        for (counter = intervalStartTime; counter < dataStartTime; counter += dataInterval) {
            values.put(counter, paddingValue);
        }
        for (counter = dataEndTime + dataInterval; counter <= intervalEndTime; counter += dataInterval) {
            values.put(counter, paddingValue);
        }
        metric.setMetricValues(values);
    }

    private long longToMillis(long time) {
        if (time < 9999999999L) {
            return time * 1000L;
        }
        return time;
    }

    private long getTimelineMetricInterval(TreeMap<Long, Double> values, long startTime, long endTime) {
        long interval;
        Precision precision = Precision.getPrecision((long)startTime, (long)endTime);
        if (precision.equals((Object)Precision.DAYS)) {
            interval = TimeUnit.DAYS.toMillis(1L);
        } else if (precision.equals((Object)Precision.HOURS)) {
            interval = TimeUnit.HOURS.toMillis(1L);
        } else if (precision.equals((Object)Precision.MINUTES)) {
            interval = TimeUnit.MINUTES.toMillis(1L);
        } else if (values != null && values.size() > 1) {
            Iterator<Long> tsValuesIterator = values.descendingKeySet().iterator();
            long lastValue = tsValuesIterator.next();
            long secondToLastValue = tsValuesIterator.next();
            interval = Math.abs(lastValue - secondToLastValue);
        } else {
            interval = -1L;
        }
        return interval;
    }

    public static enum PADDING_STRATEGY {
        ZEROS,
        NULLS,
        NONE;

    }
}

