/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.controller.metrics.MetricsDataTransferMethod;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricsDownsamplingMethod {
    private static final long OUT_OF_BAND_TIME_ALLOWANCE = 120000L;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsDownsamplingMethod.class);

    public abstract Number[][] reportMetricData(TimelineMetric var1, MetricsDataTransferMethod var2, TemporalInfo var3);

    protected boolean isWithinTemporalQueryRange(Long timestamp, TemporalInfo temporalInfo) {
        boolean retVal;
        boolean bl = retVal = temporalInfo == null || timestamp >= temporalInfo.getStartTimeMillis() - 120000L && timestamp <= temporalInfo.getEndTimeMillis();
        if (!retVal && LOG.isTraceEnabled()) {
            LOG.trace("Ignoring out of band metric with ts: {}, temporalInfo: startTime = {}, endTime = {}", new Object[]{timestamp, temporalInfo.getStartTimeMillis(), temporalInfo.getEndTimeMillis()});
        }
        return retVal;
    }
}

