/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.controller.metrics.MetricsDataTransferMethod;
import id.onyx.obdp.server.controller.metrics.PassThroughTransferMethod;
import id.onyx.obdp.server.controller.metrics.PercentageAdjustmentTransferMethod;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class MetricsDataTransferMethodFactory {
    private static final Set<String> PERCENTAGE_METRIC;
    private static final MetricsDataTransferMethod percentageAdjustment;
    private static final MetricsDataTransferMethod passThrough;

    public static MetricsDataTransferMethod detectDataTransferMethod(TimelineMetric metricDecl) {
        if (PERCENTAGE_METRIC.contains(metricDecl.getMetricName())) {
            return percentageAdjustment;
        }
        return passThrough;
    }

    static {
        HashSet<String> percentMetrics = new HashSet<String>();
        percentMetrics.add("cpu_wio");
        percentMetrics.add("cpu_idle");
        percentMetrics.add("cpu_nice");
        percentMetrics.add("cpu_aidle");
        percentMetrics.add("cpu_system");
        percentMetrics.add("cpu_user");
        HashSet<CallSite> metricsWithAggregateFunctionIds = new HashSet<CallSite>();
        for (String metric : percentMetrics) {
            for (String aggregateFunctionId : PropertyHelper.AGGREGATE_FUNCTION_IDENTIFIERS) {
                if ("._sum".equals(aggregateFunctionId)) continue;
                metricsWithAggregateFunctionIds.add((CallSite)((Object)(metric + aggregateFunctionId)));
            }
        }
        percentMetrics.addAll(metricsWithAggregateFunctionIds);
        PERCENTAGE_METRIC = Collections.unmodifiableSet(percentMetrics);
        percentageAdjustment = new PercentageAdjustmentTransferMethod();
        passThrough = new PassThroughTransferMethod();
    }
}

