/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.metrics.CollectorHostDownRefreshCounter;
import id.onyx.obdp.server.controller.metrics.MetricsCollectorHAClusterState;
import id.onyx.obdp.server.events.MetricsCollectorHostDownEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectorHAManager {
    @Inject
    protected OBDPEventPublisher eventPublisher;
    private Map<String, MetricsCollectorHAClusterState> clusterCollectorHAState;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCollectorHAManager.class);
    private Map<String, Map<String, Boolean>> externalMetricCollectorsState = new HashMap<String, Map<String, Boolean>>();
    private CollectorHostDownRefreshCounter externalCollectorDownRefreshCounter = new CollectorHostDownRefreshCounter(5);

    public MetricsCollectorHAManager() {
        this.clusterCollectorHAState = new HashMap<String, MetricsCollectorHAClusterState>();
        if (null == this.eventPublisher && null != OBDPServer.getController()) {
            this.eventPublisher = OBDPServer.getController().getAmbariEventPublisher();
            if (this.eventPublisher != null) {
                this.eventPublisher.register(this);
            } else {
                LOG.error("Unable to retrieve OBDPEventPublisher for Metric collector host event listening.");
            }
        }
    }

    public void addCollectorHost(String clusterName, String collectorHost) {
        LOG.info("Adding collector host : " + collectorHost + " to cluster : " + clusterName);
        if (!this.clusterCollectorHAState.containsKey(clusterName)) {
            this.clusterCollectorHAState.put(clusterName, new MetricsCollectorHAClusterState(clusterName));
        }
        MetricsCollectorHAClusterState collectorHAClusterState = this.clusterCollectorHAState.get(clusterName);
        collectorHAClusterState.addMetricsCollectorHost(collectorHost);
    }

    public void addExternalMetricsCollectorHost(String clusterName, String collectorHost) {
        HashMap<String, Boolean> hostStateMap = new HashMap<String, Boolean>();
        hostStateMap.put(collectorHost, true);
        this.externalMetricCollectorsState.put(clusterName, hostStateMap);
    }

    public String getCollectorHost(String clusterName) {
        if (this.externalMetricCollectorsState.containsKey(clusterName)) {
            for (String externalCollectorHost : this.externalMetricCollectorsState.get(clusterName).keySet()) {
                if (!this.externalMetricCollectorsState.get(clusterName).get(externalCollectorHost).booleanValue()) continue;
                return externalCollectorHost;
            }
            return this.refreshAndReturnRandomExternalCollectorHost(clusterName);
        }
        if (!this.clusterCollectorHAState.containsKey(clusterName)) {
            this.clusterCollectorHAState.put(clusterName, new MetricsCollectorHAClusterState(clusterName));
        }
        MetricsCollectorHAClusterState collectorHAClusterState = this.clusterCollectorHAState.get(clusterName);
        return collectorHAClusterState.getCurrentCollectorHost();
    }

    private String refreshAndReturnRandomExternalCollectorHost(String clusterName) {
        for (Map.Entry<String, Boolean> entry : this.externalMetricCollectorsState.get(clusterName).entrySet()) {
            entry.setValue(true);
        }
        Iterator<Map.Entry<String, Boolean>> itr = this.externalMetricCollectorsState.get(clusterName).entrySet().iterator();
        return itr.next().getKey();
    }

    @Subscribe
    public void onMetricsCollectorHostDownEvent(MetricsCollectorHostDownEvent event) {
        LOG.debug("MetricsCollectorHostDownEvent caught, Down collector : {}", (Object)event.getCollectorHost());
        String clusterName = event.getClusterName();
        if (this.externalMetricCollectorsState.containsKey(clusterName)) {
            if (this.externalCollectorDownRefreshCounter.testRefreshCounter()) {
                this.externalMetricCollectorsState.get(clusterName).put(event.getCollectorHost(), false);
            }
        } else {
            MetricsCollectorHAClusterState collectorHAClusterState = this.clusterCollectorHAState.get(clusterName);
            collectorHAClusterState.onCollectorHostDown(event.getCollectorHost());
        }
    }

    public boolean isEmpty() {
        return this.clusterCollectorHAState.isEmpty() && this.externalMetricCollectorsState.isEmpty();
    }

    public boolean isExternalCollector() {
        return !this.externalMetricCollectorsState.isEmpty();
    }

    public boolean isCollectorHostLive(String clusterName) {
        if (!this.externalMetricCollectorsState.isEmpty()) {
            return true;
        }
        MetricsCollectorHAClusterState metricsCollectorHAClusterState = this.clusterCollectorHAState.get(clusterName);
        return metricsCollectorHAClusterState != null && metricsCollectorHAClusterState.isCollectorHostLive();
    }

    public boolean isCollectorComponentLive(String clusterName) {
        if (!this.externalMetricCollectorsState.isEmpty()) {
            return true;
        }
        MetricsCollectorHAClusterState metricsCollectorHAClusterState = this.clusterCollectorHAState.get(clusterName);
        return metricsCollectorHAClusterState != null && metricsCollectorHAClusterState.isCollectorComponentAlive();
    }
}

