/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import com.google.inject.Inject;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.HostStatusHelper;
import id.onyx.obdp.server.controller.metrics.CollectorHostDownRefreshCounter;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectorHAClusterState {
    private String clusterName;
    private Set<String> liveCollectorHosts;
    private Set<String> deadCollectorHosts;
    private CollectorHostDownRefreshCounter collectorDownRefreshCounter = new CollectorHostDownRefreshCounter(5);
    private String currentCollectorHost = null;
    @Inject
    OBDPManagementController managementController;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCollectorHAClusterState.class);

    public MetricsCollectorHAClusterState(String clusterName) {
        if (this.managementController == null) {
            this.managementController = OBDPServer.getController();
        }
        this.clusterName = clusterName;
        this.liveCollectorHosts = new CopyOnWriteArraySet<String>();
        this.deadCollectorHosts = new CopyOnWriteArraySet<String>();
    }

    public void addMetricsCollectorHost(String collectorHost) {
        if (HostStatusHelper.isHostComponentLive(this.managementController, this.clusterName, collectorHost, "AMBARI_METRICS", Role.METRICS_COLLECTOR.name())) {
            this.liveCollectorHosts.add(collectorHost);
            this.deadCollectorHosts.remove(collectorHost);
        } else {
            this.deadCollectorHosts.add(collectorHost);
            this.liveCollectorHosts.remove(collectorHost);
        }
        if (this.currentCollectorHost == null || !HostStatusHelper.isHostComponentLive(this.managementController, this.clusterName, this.currentCollectorHost, "AMBARI_METRICS", Role.METRICS_COLLECTOR.name())) {
            this.refreshCollectorHost(this.currentCollectorHost);
        }
    }

    private void refreshCollectorHost(String currentHost) {
        LOG.info("Refreshing collector host, current collector host : " + currentHost);
        this.testAndAddDeadCollectorsToLiveList();
        if (currentHost != null) {
            if (this.liveCollectorHosts.contains(currentHost)) {
                this.liveCollectorHosts.remove(currentHost);
            }
            if (!this.deadCollectorHosts.contains(currentHost)) {
                this.deadCollectorHosts.add(currentHost);
            }
        }
        if (!this.liveCollectorHosts.isEmpty()) {
            this.currentCollectorHost = this.getRandom(this.liveCollectorHosts);
        }
        if (this.currentCollectorHost == null && !this.deadCollectorHosts.isEmpty()) {
            this.currentCollectorHost = this.getRandom(this.deadCollectorHosts);
        }
        LOG.info("After refresh, new collector host : " + this.currentCollectorHost);
    }

    public String getCurrentCollectorHost() {
        return this.currentCollectorHost;
    }

    public void onCollectorHostDown(String deadCollectorHost) {
        if (deadCollectorHost == null) {
            this.refreshCollectorHost(null);
        } else if (deadCollectorHost.equals(this.currentCollectorHost) && this.numCollectors() > 1 && this.collectorDownRefreshCounter.testRefreshCounter()) {
            this.refreshCollectorHost(deadCollectorHost);
        }
    }

    private void testAndAddDeadCollectorsToLiveList() {
        HashSet<String> liveHosts = new HashSet<String>();
        for (String deadHost : this.deadCollectorHosts) {
            if (!this.isValidAliveCollectorHost(this.clusterName, deadHost)) continue;
            liveHosts.add(deadHost);
        }
        for (String liveHost : liveHosts) {
            LOG.info("Removing collector " + liveHost + " from dead list to live list");
            this.deadCollectorHosts.remove(liveHost);
            this.liveCollectorHosts.add(liveHost);
        }
    }

    private boolean isValidAliveCollectorHost(String clusterName, String collectorHost) {
        return collectorHost != null && HostStatusHelper.isHostLive(this.managementController, clusterName, collectorHost) && HostStatusHelper.isHostComponentLive(this.managementController, clusterName, collectorHost, "AMBARI_METRICS", Role.METRICS_COLLECTOR.name());
    }

    public boolean isCollectorHostLive() {
        for (String host : this.liveCollectorHosts) {
            if (!HostStatusHelper.isHostLive(this.managementController, this.clusterName, host)) continue;
            return true;
        }
        this.testAndAddDeadCollectorsToLiveList();
        for (String host : this.liveCollectorHosts) {
            if (!HostStatusHelper.isHostLive(this.managementController, this.clusterName, host)) continue;
            return true;
        }
        return false;
    }

    public boolean isCollectorComponentAlive() {
        for (String host : this.liveCollectorHosts) {
            if (!HostStatusHelper.isHostComponentLive(this.managementController, this.clusterName, host, "AMBARI_METRICS", Role.METRICS_COLLECTOR.name())) continue;
            return true;
        }
        for (String host : this.deadCollectorHosts) {
            if (!HostStatusHelper.isHostComponentLive(this.managementController, this.clusterName, host, "AMBARI_METRICS", Role.METRICS_COLLECTOR.name())) continue;
            return true;
        }
        return false;
    }

    private int numCollectors() {
        return this.liveCollectorHosts.size() + this.deadCollectorHosts.size();
    }

    private String getRandom(Set<String> collectorSet) {
        int randIndex = new Random().nextInt(collectorSet.size());
        int i = 0;
        for (String host : collectorSet) {
            if (i == randIndex) {
                return host;
            }
            ++i;
        }
        return null;
    }
}

