/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.metrics;

import id.onyx.obdp.server.controller.metrics.MetricsDataTransferMethod;
import id.onyx.obdp.server.controller.metrics.MetricsDownsamplingMethod;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

class MetricsAveragePerSecondDownsampling
extends MetricsDownsamplingMethod {
    MetricsAveragePerSecondDownsampling() {
    }

    @Override
    public Number[][] reportMetricData(TimelineMetric metricData, MetricsDataTransferMethod dataTransferMethod, TemporalInfo temporalInfo) {
        OutOfBandAccumuloFilterList cache = new OutOfBandAccumuloFilterList(temporalInfo);
        Iterator ci = metricData.getMetricValues().entrySet().iterator();
        Map.Entry e0 = null;
        while (ci.hasNext() && (e0 = ci.next()).getValue() == null) {
            cache.add(new Accumulo((Long)e0.getKey() / 1000L, null));
        }
        if (e0 != null) {
            long t0 = (Long)e0.getKey() / 1000L;
            Double s0 = (Double)e0.getValue();
            int nSamples = 1;
            boolean lastNonNullEntryAdded = false;
            while (ci.hasNext()) {
                e0 = ci.next();
                if (e0.getValue() == null) {
                    if (!lastNonNullEntryAdded) {
                        cache.add(new Accumulo(t0, dataTransferMethod.getData(s0 / (double)nSamples)));
                        lastNonNullEntryAdded = true;
                    }
                    cache.add(new Accumulo((Long)e0.getKey() / 1000L, null));
                    continue;
                }
                long t = (Long)e0.getKey() / 1000L;
                if (t != t0) {
                    cache.add(new Accumulo(t0, dataTransferMethod.getData(s0 / (double)nSamples)));
                    t0 = t;
                    s0 = (Double)e0.getValue();
                    nSamples = 1;
                    continue;
                }
                s0 = s0 + (Double)e0.getValue();
                ++nSamples;
            }
            if (!lastNonNullEntryAdded) {
                cache.add(new Accumulo(t0, dataTransferMethod.getData(s0 / (double)nSamples)));
            }
        }
        Number[][] datapointsArray = new Number[cache.size()][2];
        int cnt = 0;
        for (Accumulo e : cache) {
            datapointsArray[cnt][0] = e.val;
            datapointsArray[cnt][1] = e.ts;
            ++cnt;
        }
        return datapointsArray;
    }

    class OutOfBandAccumuloFilterList<T>
    extends ArrayList<Accumulo> {
        TemporalInfo temporalInfo;

        OutOfBandAccumuloFilterList(TemporalInfo temporalInfo) {
            this.temporalInfo = temporalInfo;
        }

        @Override
        public boolean add(Accumulo accumulo) {
            long ts = accumulo.ts;
            if (ts < 9999999999L) {
                ts *= 1000L;
            }
            if (MetricsAveragePerSecondDownsampling.this.isWithinTemporalQueryRange(ts, this.temporalInfo)) {
                return super.add(accumulo);
            }
            return false;
        }
    }

    class Accumulo {
        public long ts;
        public Double val;

        public Accumulo(long t, Double v) {
            this.ts = t;
            this.val = v;
        }
    }
}

