/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.logging;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class Utils {
    private static int WAIT_COUNT_MAX = 1000;

    private Utils() {
    }

    static void logErrorMessageWithThrowableWithCounter(Logger logger, AtomicInteger atomicInteger, String errorMessage, Throwable throwable) {
        Utils.logErrorMessageWithThrowableWithCounter(logger, atomicInteger, errorMessage, throwable, WAIT_COUNT_MAX);
    }

    static void logErrorMessageWithThrowableWithCounter(Logger logger, AtomicInteger atomicInteger, String errorMessage, Throwable throwable, int maxCount) {
        if (atomicInteger.getAndIncrement() == 0) {
            logger.error(errorMessage, throwable);
        } else {
            atomicInteger.compareAndSet(maxCount, 0);
        }
    }

    static void logErrorMessageWithCounter(Logger logger, AtomicInteger atomicInteger, String errorMessage) {
        Utils.logErrorMessageWithCounter(logger, atomicInteger, errorMessage, WAIT_COUNT_MAX);
    }

    static void logErrorMessageWithCounter(Logger logger, AtomicInteger atomicInteger, String errorMessage, int maxCount) {
        if (atomicInteger.getAndIncrement() == 0) {
            logger.error(errorMessage);
        } else {
            atomicInteger.compareAndSet(maxCount, 0);
        }
    }

    static void logDebugMessageWithCounter(Logger logger, AtomicInteger atomicInteger, String errorMessage) {
        Utils.logDebugMessageWithCounter(logger, atomicInteger, errorMessage, WAIT_COUNT_MAX);
    }

    static void logDebugMessageWithCounter(Logger logger, AtomicInteger atomicInteger, String debugMessage, int maxCount) {
        if (atomicInteger.getAndIncrement() == 0) {
            logger.debug(debugMessage);
        } else {
            atomicInteger.compareAndSet(maxCount, 0);
        }
    }
}

