/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.logging;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.logging.HostComponentLoggingInfo;
import id.onyx.obdp.server.controller.logging.LogFileDefinitionInfo;
import id.onyx.obdp.server.controller.logging.LogFileType;
import id.onyx.obdp.server.controller.logging.LogSearchDataRetrievalService;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactory;
import id.onyx.obdp.server.controller.logging.Utils;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.LogDefinition;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSearchPropertyProvider
implements PropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingSearchPropertyProvider.class);
    private static final String CLUSTERS_PATH = "/api/v1/clusters";
    private static final String PATH_TO_SEARCH_ENGINE = "/logging/searchEngine";
    private static final Set<RoleAuthorization> REQUIRED_AUTHORIZATIONS = EnumSet.of(RoleAuthorization.SERVICE_VIEW_OPERATIONAL_LOGS);
    private static AtomicInteger errorLogCounterForLogSearchConnectionExceptions = new AtomicInteger(0);
    @Inject
    private OBDPManagementController ambariManagementController;
    @Inject
    private LogSearchDataRetrievalService logSearchDataRetrievalService;
    @Inject
    private LoggingRequestHelperFactory loggingRequestHelperFactory;

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        HashMap<String, Boolean> isLogSearchRunning = new HashMap<String, Boolean>();
        for (Resource resource : resources) {
            String mappedComponentNameForLogSearch;
            String componentName = (String)resource.getPropertyValue(PropertyHelper.getPropertyId("HostRoles", "component_name"));
            String hostName = (String)resource.getPropertyValue(PropertyHelper.getPropertyId("HostRoles", "host_name"));
            String clusterName = (String)resource.getPropertyValue(PropertyHelper.getPropertyId("HostRoles", "cluster_name"));
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, this.getClusterResourceID(clusterName), REQUIRED_AUTHORIZATIONS)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The authenticated user ({}) is not authorized to access LogSearch data for the cluster named {}", (Object)AuthorizationHelper.getAuthenticatedName(), (Object)clusterName);
                continue;
            }
            Boolean isLogSearchRunningForSpecifiedCluster = (Boolean)isLogSearchRunning.get(clusterName);
            if (isLogSearchRunningForSpecifiedCluster == null) {
                isLogSearchRunningForSpecifiedCluster = this.logSearchServerRunning(clusterName);
                isLogSearchRunning.put(clusterName, isLogSearchRunningForSpecifiedCluster);
            }
            if (!isLogSearchRunningForSpecifiedCluster.booleanValue() || (mappedComponentNameForLogSearch = this.getMappedComponentNameForSearch(clusterName, componentName, this.ambariManagementController)) == null) continue;
            Set<String> logFileNames = this.logSearchDataRetrievalService.getLogFileNames(mappedComponentNameForLogSearch, hostName, clusterName);
            if (logFileNames != null && !logFileNames.isEmpty()) {
                HostComponentLoggingInfo loggingInfo = new HostComponentLoggingInfo();
                loggingInfo.setComponentName(mappedComponentNameForLogSearch);
                LinkedList<LogFileDefinitionInfo> listOfFileDefinitions = new LinkedList<LogFileDefinitionInfo>();
                for (String fileName : logFileNames) {
                    String searchEngineURI = this.ambariManagementController.getAmbariServerURI(this.getFullPathToSearchEngine(clusterName));
                    String logFileTailURI = this.logSearchDataRetrievalService.getLogFileTailURI(searchEngineURI, mappedComponentNameForLogSearch, hostName, clusterName);
                    if (logFileTailURI == null) continue;
                    listOfFileDefinitions.add(new LogFileDefinitionInfo(fileName, LogFileType.SERVICE, searchEngineURI, logFileTailURI));
                }
                loggingInfo.setListOfLogFileDefinitions(listOfFileDefinitions);
                LOG.debug("Adding logging info for component name = " + componentName + " on host name = " + hostName);
                resource.setProperty("logging", loggingInfo);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            String debugMessage = String.format("Error occurred while making request to LogSearch service, unable to populate logging properties on this resource, component = %s, host = %s", componentName, hostName);
            Utils.logDebugMessageWithCounter(LOG, errorLogCounterForLogSearchConnectionExceptions, debugMessage);
        }
        return resources;
    }

    private Long getClusterResourceID(String clusterName) {
        Long clusterResourceId;
        block5: {
            clusterResourceId = null;
            if (!StringUtils.isEmpty((String)clusterName)) {
                try {
                    Cluster cluster = this.ambariManagementController.getClusters().getCluster(clusterName);
                    if (cluster == null) {
                        LOG.warn(String.format("No cluster found with the name %s, assuming null resource id", clusterName));
                        break block5;
                    }
                    clusterResourceId = cluster.getResourceId();
                }
                catch (OBDPException e) {
                    LOG.warn(String.format("An exception occurred looking up the cluster named %s, assuming null resource id: %s", clusterName, e.getLocalizedMessage()));
                }
            } else {
                LOG.debug("The cluster name is not set, assuming null resource id");
            }
        }
        return clusterResourceId;
    }

    private boolean logSearchServerRunning(String clusterName) {
        return this.loggingRequestHelperFactory.getHelper(this.ambariManagementController, clusterName) != null;
    }

    private String getMappedComponentNameForSearch(String clusterName, String componentName, OBDPManagementController controller) {
        try {
            List<LogDefinition> listOfLogs;
            OBDPMetaInfo metaInfo = controller.getAmbariMetaInfo();
            Cluster cluster = controller.getClusters().getCluster(clusterName);
            String serviceName = controller.findServiceName(cluster, componentName);
            Service service = cluster.getService(serviceName);
            StackId stackId = service.getDesiredStackId();
            String stackName = stackId.getStackName();
            String stackVersion = stackId.getStackVersion();
            ComponentInfo componentInfo = metaInfo.getComponent(stackName, stackVersion, serviceName, componentName);
            if (componentInfo != null && (listOfLogs = componentInfo.getLogs()) != null && !listOfLogs.isEmpty()) {
                LogDefinition definition = listOfLogs.get(0);
                return definition.getLogId();
            }
        }
        catch (OBDPException e) {
            LOG.error("Error occurred while attempting to locate the log component name for component = " + componentName, (Throwable)e);
        }
        return null;
    }

    private String getFullPathToSearchEngine(String clusterName) {
        return "/api/v1/clusters/" + clusterName + PATH_TO_SEARCH_ENGINE;
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        return Collections.emptySet();
    }

    protected void setAmbariManagementController(OBDPManagementController ambariManagementController) {
        this.ambariManagementController = ambariManagementController;
    }

    void setLogSearchDataRetrievalService(LogSearchDataRetrievalService logSearchDataRetrievalService) {
        this.logSearchDataRetrievalService = logSearchDataRetrievalService;
    }

    void setLoggingRequestHelperFactory(LoggingRequestHelperFactory loggingRequestHelperFactory) {
        this.loggingRequestHelperFactory = loggingRequestHelperFactory;
    }
}

