/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.logging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.logging.HostLogFilesResponse;
import id.onyx.obdp.server.controller.logging.LogLevelQueryResponse;
import id.onyx.obdp.server.controller.logging.LogQueryResponse;
import id.onyx.obdp.server.controller.logging.LoggingCookieStore;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelper;
import id.onyx.obdp.server.controller.logging.Utils;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRequestHelperImpl
implements LoggingRequestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingRequestHelperImpl.class);
    private static final String LOGSEARCH_ADMIN_JSON_CONFIG_TYPE_NAME = "logsearch-admin-json";
    private static final String LOGSEARCH_ADMIN_USERNAME_PROPERTY_NAME = "logsearch_admin_username";
    private static final String LOGSEARCH_ADMIN_PASSWORD_PROPERTY_NAME = "logsearch_admin_password";
    private static final String LOGSEARCH_QUERY_PATH = "/api/v1/service/logs";
    private static final String LOGSEARCH_GET_LOG_LEVELS_PATH = "/api/v1/service/logs/levels/counts";
    private static final String LOGSEARCH_GET_LOG_FILES_PATH = "/api/v1/service/logs/files";
    private static final String LOGSEARCH_ADMIN_CREDENTIAL_NAME = "logsearch.admin.credential";
    private static final String COMPONENT_QUERY_PARAMETER_NAME = "component_name";
    private static final String HOST_QUERY_PARAMETER_NAME = "host_name";
    private static final String DEFAULT_PAGE_SIZE = "50";
    private static final String PAGE_SIZE_QUERY_PARAMETER_NAME = "pageSize";
    private static final String COOKIE_HEADER = "Cookie";
    private static final String SET_COOKIES_HEADER = "Set-Cookie";
    private static final int DEFAULT_LOGSEARCH_CONNECT_TIMEOUT_IN_MILLISECONDS = 5000;
    private static final int DEFAULT_LOGSEARCH_READ_TIMEOUT_IN_MILLISECONDS = 5000;
    private static final String LOGSEARCH_CLUSTERS_QUERY_PARAMETER_NAME = "clusters";
    private static AtomicInteger errorLogCounterForLogSearchConnectionExceptions = new AtomicInteger(0);
    private final String hostName;
    private final String portNumber;
    private final String protocol;
    private final CredentialStoreService credentialStoreService;
    private final Cluster cluster;
    private final String externalAddress;
    private final NetworkConnection networkConnection;
    private SSLSocketFactory sslSocketFactory;
    private int logSearchConnectTimeoutInMilliseconds = 5000;
    private int logSearchReadTimeoutInMilliseconds = 5000;

    public LoggingRequestHelperImpl(String hostName, String portNumber, String protocol, CredentialStoreService credentialStoreService, Cluster cluster, String externalAddress) {
        this(hostName, portNumber, protocol, credentialStoreService, cluster, externalAddress, new DefaultNetworkConnection());
    }

    protected LoggingRequestHelperImpl(String hostName, String portNumber, String protocol, CredentialStoreService credentialStoreService, Cluster cluster, String externalAddress, NetworkConnection networkConnection) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.credentialStoreService = credentialStoreService;
        this.cluster = cluster;
        this.externalAddress = externalAddress;
        this.networkConnection = networkConnection;
    }

    public int getLogSearchConnectTimeoutInMilliseconds() {
        return this.logSearchConnectTimeoutInMilliseconds;
    }

    public void setLogSearchConnectTimeoutInMilliseconds(int logSearchConnectTimeoutInMilliseconds) {
        this.logSearchConnectTimeoutInMilliseconds = logSearchConnectTimeoutInMilliseconds;
    }

    public int getLogSearchReadTimeoutInMilliseconds() {
        return this.logSearchReadTimeoutInMilliseconds;
    }

    public void setLogSearchReadTimeoutInMilliseconds(int logSearchReadTimeoutInMilliseconds) {
        this.logSearchReadTimeoutInMilliseconds = logSearchReadTimeoutInMilliseconds;
    }

    @Override
    public LogQueryResponse sendQueryRequest(Map<String, String> queryParameters) {
        try {
            URI logSearchURI = this.createLogSearchQueryURI(this.protocol, queryParameters);
            LOG.debug("Attempting to connect to LogSearch server at {}", (Object)logSearchURI);
            HttpURLConnection httpURLConnection = (HttpURLConnection)logSearchURI.toURL().openConnection();
            this.secure(httpURLConnection, this.protocol);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(this.logSearchConnectTimeoutInMilliseconds);
            httpURLConnection.setReadTimeout(this.logSearchReadTimeoutInMilliseconds);
            this.addCookiesFromCookieStore(httpURLConnection);
            LOG.debug("Attempting request to LogSearch Portal Server, with connect timeout = {} milliseconds and read timeout = {} milliseconds", (Object)this.logSearchConnectTimeoutInMilliseconds, (Object)this.logSearchReadTimeoutInMilliseconds);
            this.setupCredentials(httpURLConnection);
            StringBuffer buffer = this.networkConnection.readQueryResponseFromServer(httpURLConnection);
            this.addCookiesToCookieStoreFromResponse(httpURLConnection);
            StringReader stringReader = new StringReader(buffer.toString());
            ObjectReader logQueryResponseReader = LoggingRequestHelperImpl.createObjectReader(LogQueryResponse.class);
            return (LogQueryResponse)logQueryResponseReader.readValue((Reader)stringReader);
        }
        catch (Exception e) {
            Utils.logErrorMessageWithThrowableWithCounter(LOG, errorLogCounterForLogSearchConnectionExceptions, "Error occurred while trying to connect to the LogSearch service...", e);
            return null;
        }
    }

    private void secure(HttpURLConnection connection, String protocol) {
        if ("https".equals(protocol)) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            this.loadTrustStore();
            secureConnection.setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private void loadTrustStore() {
        if (this.sslSocketFactory == null) {
            ComponentSSLConfiguration sslConfig = ComponentSSLConfiguration.instance();
            String trustStorePath = sslConfig.getTruststorePath();
            String trustStoreType = sslConfig.getTruststoreType();
            String trustStorePassword = sslConfig.getTruststorePassword();
            if (trustStorePath == null || trustStorePassword == null) {
                String trustStoreErrorMsg = "Can't load TrustStore. Truststore path or password is not set.";
                LOG.error(trustStoreErrorMsg);
                throw new IllegalStateException(trustStoreErrorMsg);
            }
            try (FileInputStream in = new FileInputStream(new File(trustStorePath));){
                KeyStore e = KeyStore.getInstance(trustStoreType == null ? KeyStore.getDefaultType() : trustStoreType);
                e.load(in, trustStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(e);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                this.sslSocketFactory = context.getSocketFactory();
            }
            catch (Exception ex) {
                LOG.error("Unable to load TrustStore", (Throwable)ex);
            }
        }
    }

    private void addCookiesFromCookieStore(HttpURLConnection httpURLConnection) {
        if (LoggingCookieStore.INSTANCE.getCookiesMap().size() > 0) {
            ArrayList<String> cookiesStrList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : LoggingCookieStore.INSTANCE.getCookiesMap().entrySet()) {
                cookiesStrList.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
            httpURLConnection.setRequestProperty(COOKIE_HEADER, StringUtils.join(cookiesStrList, (String)"; "));
        }
    }

    private void addCookiesToCookieStoreFromResponse(HttpURLConnection httpURLConnection) {
        Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
        List<String> cookiesHeader = headerFields.get(SET_COOKIES_HEADER);
        if (cookiesHeader != null) {
            for (String cookie : cookiesHeader) {
                HttpCookie cookie1 = HttpCookie.parse(cookie).get(0);
                LoggingCookieStore.INSTANCE.addCookie(cookie1.getName(), cookie1.getValue());
            }
        }
    }

    private void setupCredentials(HttpURLConnection httpURLConnection) {
        String logSearchAdminUser = this.getLogSearchAdminUser();
        String logSearchAdminPassword = this.getLogSearchAdminPassword();
        if (logSearchAdminUser != null && logSearchAdminPassword != null && StringUtils.isEmpty((String)this.externalAddress)) {
            LOG.debug("Credential found in config, will be used to connect to LogSearch");
            this.networkConnection.setupBasicAuthentication(httpURLConnection, LoggingRequestHelperImpl.createEncodedCredentials(logSearchAdminUser, logSearchAdminPassword));
        } else {
            PrincipalKeyCredential principalKeyCredential = this.getLogSearchCredentials();
            if (principalKeyCredential != null) {
                LOG.debug("Credential found in CredentialStore, will be used to connect to LogSearch");
                this.networkConnection.setupBasicAuthentication(httpURLConnection, LoggingRequestHelperImpl.createEncodedCredentials(principalKeyCredential));
            } else {
                LOG.debug("No LogSearch credential could be found, this is probably an error in configuration");
                if (StringUtils.isEmpty((String)this.externalAddress)) {
                    LOG.error("No LogSearch credential could be found, this is required for external LogSearch (credential: {})", (Object)LOGSEARCH_ADMIN_CREDENTIAL_NAME);
                }
            }
        }
    }

    private String getLogSearchAdminUser() {
        Config logSearchAdminConfig = this.cluster.getDesiredConfigByType(LOGSEARCH_ADMIN_JSON_CONFIG_TYPE_NAME);
        if (logSearchAdminConfig != null) {
            return logSearchAdminConfig.getProperties().get(LOGSEARCH_ADMIN_USERNAME_PROPERTY_NAME);
        }
        return null;
    }

    private String getLogSearchAdminPassword() {
        Config logSearchAdminConfig = this.cluster.getDesiredConfigByType(LOGSEARCH_ADMIN_JSON_CONFIG_TYPE_NAME);
        if (logSearchAdminConfig != null) {
            return logSearchAdminConfig.getProperties().get(LOGSEARCH_ADMIN_PASSWORD_PROPERTY_NAME);
        }
        return null;
    }

    @Override
    public HostLogFilesResponse sendGetLogFileNamesRequest(String hostName) {
        try {
            URIBuilder uriBuilder = this.createBasicURI(this.protocol);
            this.appendUriPath(uriBuilder, LOGSEARCH_GET_LOG_FILES_PATH);
            uriBuilder.addParameter(HOST_QUERY_PARAMETER_NAME, hostName);
            uriBuilder.addParameter(LOGSEARCH_CLUSTERS_QUERY_PARAMETER_NAME, this.cluster.getClusterName());
            URI logFileNamesURI = uriBuilder.build();
            LOG.debug("Attempting to connect to LogSearch server at {}", (Object)logFileNamesURI);
            HttpURLConnection httpURLConnection = (HttpURLConnection)logFileNamesURI.toURL().openConnection();
            this.secure(httpURLConnection, this.protocol);
            httpURLConnection.setRequestMethod("GET");
            this.addCookiesFromCookieStore(httpURLConnection);
            this.setupCredentials(httpURLConnection);
            StringBuffer buffer = this.networkConnection.readQueryResponseFromServer(httpURLConnection);
            this.addCookiesToCookieStoreFromResponse(httpURLConnection);
            StringReader stringReader = new StringReader(buffer.toString());
            ObjectReader hostFilesQueryResponseReader = LoggingRequestHelperImpl.createObjectReader(HostLogFilesResponse.class);
            HostLogFilesResponse response = (HostLogFilesResponse)hostFilesQueryResponseReader.readValue((Reader)stringReader);
            if (LOG.isDebugEnabled() && response != null && MapUtils.isNotEmpty(response.getHostLogFiles())) {
                for (Map.Entry<String, List<String>> componentEntry : response.getHostLogFiles().entrySet()) {
                    LOG.debug("Log files for component '{}' : {}", (Object)componentEntry.getKey(), (Object)StringUtils.join((Collection)componentEntry.getValue(), (String)","));
                }
            }
            return response;
        }
        catch (Exception e) {
            Utils.logErrorMessageWithThrowableWithCounter(LOG, errorLogCounterForLogSearchConnectionExceptions, "Error occurred while trying to connect to the LogSearch service...", e);
            return null;
        }
    }

    @Override
    public LogLevelQueryResponse sendLogLevelQueryRequest(String componentName, String hostName) {
        try {
            URI logLevelQueryURI = this.createLogLevelQueryURI(this.protocol, componentName, hostName);
            LOG.debug("Attempting to connect to LogSearch server at {}", (Object)logLevelQueryURI);
            HttpURLConnection httpURLConnection = (HttpURLConnection)logLevelQueryURI.toURL().openConnection();
            this.secure(httpURLConnection, this.protocol);
            httpURLConnection.setRequestMethod("GET");
            this.addCookiesFromCookieStore(httpURLConnection);
            this.setupCredentials(httpURLConnection);
            StringBuffer buffer = this.networkConnection.readQueryResponseFromServer(httpURLConnection);
            this.addCookiesToCookieStoreFromResponse(httpURLConnection);
            StringReader stringReader = new StringReader(buffer.toString());
            ObjectReader logQueryResponseReader = LoggingRequestHelperImpl.createObjectReader(LogLevelQueryResponse.class);
            return (LogLevelQueryResponse)logQueryResponseReader.readValue((Reader)stringReader);
        }
        catch (Exception e) {
            Utils.logErrorMessageWithThrowableWithCounter(LOG, errorLogCounterForLogSearchConnectionExceptions, "Error occurred while trying to connect to the LogSearch service...", e);
            return null;
        }
    }

    @Override
    public String createLogFileTailURI(String baseURI, String componentName, String hostName) {
        return baseURI + "?component_name=" + componentName + "&host_name=" + hostName + "&pageSize=50";
    }

    private static ObjectReader createObjectReader(Class type) {
        ObjectMapper mapper = LoggingRequestHelperImpl.createJSONObjectMapper();
        return mapper.reader(type);
    }

    private URI createLogSearchQueryURI(String scheme, Map<String, String> queryParameters) throws URISyntaxException {
        URIBuilder uriBuilder = this.createBasicURI(scheme);
        this.appendUriPath(uriBuilder, LOGSEARCH_QUERY_PATH);
        uriBuilder.addParameter(LOGSEARCH_CLUSTERS_QUERY_PARAMETER_NAME, this.cluster.getClusterName());
        for (String key : queryParameters.keySet()) {
            uriBuilder.addParameter(key, queryParameters.get(key));
        }
        return uriBuilder.build();
    }

    private URIBuilder createBasicURI(String scheme) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder();
        if (StringUtils.isNotBlank((String)this.externalAddress)) {
            URI uri = new URI(this.externalAddress);
            uriBuilder.setScheme(uri.getScheme());
            uriBuilder.setHost(uri.getHost());
            if (uri.getPort() != -1) {
                uriBuilder.setPort(uri.getPort());
            }
            if (StringUtils.isNotBlank((String)uri.getPath())) {
                uriBuilder.setPath(uri.getPath());
            }
        } else {
            uriBuilder.setScheme(scheme);
            uriBuilder.setHost(this.hostName);
            uriBuilder.setPort(Integer.parseInt(this.portNumber));
        }
        return uriBuilder;
    }

    private void appendUriPath(URIBuilder uriBuilder, String path) {
        if (StringUtils.isNotEmpty((String)uriBuilder.getPath())) {
            uriBuilder.setPath(uriBuilder.getPath() + path);
        } else {
            uriBuilder.setPath(path);
        }
    }

    private URI createLogLevelQueryURI(String scheme, String componentName, String hostName) throws URISyntaxException {
        URIBuilder uriBuilder = this.createBasicURI(scheme);
        this.appendUriPath(uriBuilder, LOGSEARCH_GET_LOG_LEVELS_PATH);
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(HOST_QUERY_PARAMETER_NAME, hostName);
        queryParameters.put(COMPONENT_QUERY_PARAMETER_NAME, componentName);
        for (String key : queryParameters.keySet()) {
            uriBuilder.addParameter(key, (String)queryParameters.get(key));
        }
        return uriBuilder.build();
    }

    protected static ObjectMapper createJSONObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private PrincipalKeyCredential getLogSearchCredentials() {
        try {
            Credential credential = this.credentialStoreService.getCredential(this.cluster.getClusterName(), LOGSEARCH_ADMIN_CREDENTIAL_NAME);
            if (credential != null && credential instanceof PrincipalKeyCredential) {
                return (PrincipalKeyCredential)credential;
            }
            if (credential == null) {
                LOG.debug("LogSearch credentials could not be obtained from store.");
            } else {
                LOG.debug("LogSearch credentials were not of the correct type, this is likely an error in configuration, credential type is = {}", (Object)credential.getClass().getName());
            }
        }
        catch (OBDPException ambariException) {
            LOG.debug("Error encountered while trying to obtain LogSearch admin credentials.", (Throwable)ambariException);
        }
        return null;
    }

    private static String createEncodedCredentials(PrincipalKeyCredential principalKeyCredential) {
        return LoggingRequestHelperImpl.createEncodedCredentials(principalKeyCredential.getPrincipal(), new String(principalKeyCredential.getKey()));
    }

    private static String createEncodedCredentials(String userName, String password) {
        return Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes());
    }

    private static class DefaultNetworkConnection
    implements NetworkConnection {
        private DefaultNetworkConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StringBuffer readQueryResponseFromServer(HttpURLConnection httpURLConnection) throws IOException {
            try (InputStream resultStream = null;){
                resultStream = httpURLConnection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(resultStream));
                LOG.debug("Response code from LogSearch Service is = {}", (Object)httpURLConnection.getResponseCode());
                String line = reader.readLine();
                StringBuffer buffer = new StringBuffer();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
                LOG.debug("Sucessfully retrieved response from server, response = {}", (Object)buffer);
                StringBuffer stringBuffer = buffer;
                return stringBuffer;
            }
        }

        @Override
        public void setupBasicAuthentication(HttpURLConnection httpURLConnection, String encodedCredentials) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        }
    }

    static interface NetworkConnection {
        public StringBuffer readQueryResponseFromServer(HttpURLConnection var1) throws IOException;

        public void setupBasicAuthentication(HttpURLConnection var1, String var2);
    }
}

