/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.logging;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelper;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactory;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperImpl;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.State;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LoggingRequestHelperFactoryImpl
implements LoggingRequestHelperFactory {
    private static final Logger LOG = Logger.getLogger(LoggingRequestHelperFactoryImpl.class);
    private static final String LOGSEARCH_PROPERTIES_CONFIG_TYPE_NAME = "logsearch-properties";
    private static final String LOGSEARCH_SERVICE_NAME = "LOGSEARCH";
    private static final String LOGSEARCH_SERVER_COMPONENT_NAME = "LOGSEARCH_SERVER";
    private static final String LOGSEARCH_HTTP_PORT_PROPERTY_NAME = "logsearch.http.port";
    private static final String LOGSEARCH_HTTPS_PORT_PROPERTY_NAME = "logsearch.https.port";
    private static final String LOGSEARCH_UI_PROTOCOL = "logsearch.protocol";
    private static final String LOGSEARCH_HTTPS_PROTOCOL_VALUE = "https";
    @Inject
    private Configuration ambariServerConfiguration;

    @Override
    public LoggingRequestHelper getHelper(OBDPManagementController ambariManagementController, String clusterName) {
        if (this.ambariServerConfiguration == null) {
            LOG.error((Object)"Ambari Server configuration object not available, cannot create request helper");
            return null;
        }
        Clusters clusters = ambariManagementController.getClusters();
        try {
            Cluster cluster = clusters.getCluster(clusterName);
            if (cluster != null) {
                LoggingRequestHelperImpl loggingRequestHelper;
                if (StringUtils.isNotBlank((String)this.ambariServerConfiguration.getLogSearchPortalExternalAddress())) {
                    loggingRequestHelper = new LoggingRequestHelperImpl(null, null, null, ambariManagementController.getCredentialStoreService(), cluster, this.ambariServerConfiguration.getLogSearchPortalExternalAddress());
                } else {
                    ServiceComponentHost serviceComponentHost;
                    boolean isLogSearchEnabled = cluster.getServices().containsKey(LOGSEARCH_SERVICE_NAME);
                    if (!isLogSearchEnabled) {
                        return null;
                    }
                    Config logSearchEnvConfig = cluster.getDesiredConfigByType(LOGSEARCH_PROPERTIES_CONFIG_TYPE_NAME);
                    List<ServiceComponentHost> listOfMatchingHosts = cluster.getServiceComponentHosts(LOGSEARCH_SERVICE_NAME, LOGSEARCH_SERVER_COMPONENT_NAME);
                    if (listOfMatchingHosts.size() == 0) {
                        LOG.warn((Object)"No matching LOGSEARCH_SERVER instances found, this may indicate a deployment problem.  Please verify that LogSearch is deployed and running.");
                        return null;
                    }
                    if (listOfMatchingHosts.size() > 1) {
                        LOG.warn((Object)"More than one LOGSEARCH_SERVER instance found, this may be a deployment error.  Only the first LOGSEARCH_SERVER instance will be used.");
                    }
                    if ((serviceComponentHost = listOfMatchingHosts.get(0)).getState() != State.STARTED) {
                        return null;
                    }
                    String logSearchHostName = serviceComponentHost.getHostName();
                    String logSearchProtocol = logSearchEnvConfig.getProperties().get(LOGSEARCH_UI_PROTOCOL);
                    String logSearchPortNumber = LOGSEARCH_HTTPS_PROTOCOL_VALUE.equalsIgnoreCase(logSearchProtocol) ? logSearchEnvConfig.getProperties().get(LOGSEARCH_HTTPS_PORT_PROPERTY_NAME) : logSearchEnvConfig.getProperties().get(LOGSEARCH_HTTP_PORT_PROPERTY_NAME);
                    loggingRequestHelper = new LoggingRequestHelperImpl(logSearchHostName, logSearchPortNumber, logSearchProtocol, ambariManagementController.getCredentialStoreService(), cluster, null);
                }
                loggingRequestHelper.setLogSearchConnectTimeoutInMilliseconds(this.ambariServerConfiguration.getLogSearchPortalConnectTimeout());
                loggingRequestHelper.setLogSearchReadTimeoutInMilliseconds(this.ambariServerConfiguration.getLogSearchPortalReadTimeout());
                return loggingRequestHelper;
            }
        }
        catch (OBDPException ambariException) {
            LOG.error((Object)("Error occurred while trying to obtain the cluster, cluster name = " + clusterName), (Throwable)ambariException);
        }
        return null;
    }

    void setAmbariServerConfiguration(Configuration ambariServerConfiguration) {
        this.ambariServerConfiguration = ambariServerConfiguration;
    }
}

