/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.logging;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.logging.HostLogFilesResponse;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelper;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OBDPService
public class LogSearchDataRetrievalService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(LogSearchDataRetrievalService.class);
    private static int MAX_RETRIES_FOR_FAILED_METADATA_REQUEST = 10;
    @Inject
    private LoggingRequestHelperFactory loggingRequestHelperFactory;
    @Inject
    private Injector injector;
    @Inject
    private Configuration ambariServerConfiguration;
    private Cache<String, Set<String>> logFileNameCache;
    private Cache<String, String> logFileTailURICache;
    private final Set<String> currentRequests = Sets.newConcurrentHashSet();
    private final Map<String, AtomicInteger> componentRequestFailureCounts = Maps.newConcurrentMap();
    private Executor executor;

    protected void doStart() {
        LOG.debug("Initializing caches");
        int maxTimeoutForCacheInHours = this.ambariServerConfiguration.getLogSearchMetadataCacheExpireTimeout();
        LOG.debug("Caches configured with a max expire timeout of {} hours.", (Object)maxTimeoutForCacheInHours);
        this.logFileNameCache = CacheBuilder.newBuilder().expireAfterWrite((long)maxTimeoutForCacheInHours, TimeUnit.HOURS).build();
        this.logFileTailURICache = CacheBuilder.newBuilder().expireAfterWrite((long)maxTimeoutForCacheInHours, TimeUnit.HOURS).build();
        this.executor = Executors.newSingleThreadExecutor();
    }

    protected void doStop() {
        LOG.debug("Invalidating LogSearch caches");
        this.logFileNameCache.invalidateAll();
        this.logFileTailURICache.invalidateAll();
    }

    public Set<String> getLogFileNames(String component, String host, String cluster) {
        String key = LogSearchDataRetrievalService.generateKey(component, host);
        Set cacheResult = (Set)this.logFileNameCache.getIfPresent((Object)key);
        if (cacheResult != null) {
            LOG.debug("LogFileNames result for key = {} found in cache", (Object)key);
            return cacheResult;
        }
        if (!this.componentRequestFailureCounts.containsKey(component) || this.componentRequestFailureCounts.get(component).get() < MAX_RETRIES_FOR_FAILED_METADATA_REQUEST) {
            if (this.currentRequests.contains(key)) {
                LOG.debug("LogFileNames request has been made for key = {}, but not completed yet", (Object)key);
            } else {
                LOG.debug("LogFileNames result for key = {} not in cache, queueing up remote request", (Object)key);
                this.currentRequests.add(key);
                this.startLogSearchFileNameRequest(host, component, cluster);
            }
        } else {
            LOG.debug("Too many failures occurred while attempting to obtain log file metadata for component = {}, Ambari will ignore this component for LogSearch Integration", (Object)component);
        }
        return null;
    }

    public String getLogFileTailURI(String baseURI, String component, String host, String cluster) {
        String key = LogSearchDataRetrievalService.generateKey(component, host);
        String result = (String)this.logFileTailURICache.getIfPresent((Object)key);
        if (result != null) {
            return result;
        }
        if (this.loggingRequestHelperFactory != null) {
            String tailFileURI;
            LoggingRequestHelper helper = this.loggingRequestHelperFactory.getHelper(this.getController(), cluster);
            if (helper != null && (tailFileURI = helper.createLogFileTailURI(baseURI, component, host)) != null) {
                this.logFileTailURICache.put((Object)key, (Object)tailFileURI);
                return tailFileURI;
            }
        } else {
            LOG.debug("LoggingRequestHelperFactory not set on the retrieval service, this probably indicates an error in setup of this service.");
        }
        return null;
    }

    protected void setLoggingRequestHelperFactory(LoggingRequestHelperFactory loggingRequestHelperFactory) {
        this.loggingRequestHelperFactory = loggingRequestHelperFactory;
    }

    void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected void setExecutor(Executor executor) {
        this.executor = executor;
    }

    void setConfiguration(Configuration ambariServerConfiguration) {
        this.ambariServerConfiguration = ambariServerConfiguration;
    }

    protected Set<String> getCurrentRequests() {
        return this.currentRequests;
    }

    protected Map<String, AtomicInteger> getComponentRequestFailureCounts() {
        return this.componentRequestFailureCounts;
    }

    private void startLogSearchFileNameRequest(String host, String component, String cluster) {
        this.executor.execute(new LogSearchFileNameRequestRunnable(host, component, cluster, this.logFileNameCache, this.currentRequests, (LoggingRequestHelperFactory)this.injector.getInstance(LoggingRequestHelperFactory.class), this.componentRequestFailureCounts));
    }

    private OBDPManagementController getController() {
        return OBDPServer.getController();
    }

    private static String generateKey(String component, String host) {
        return component + "+" + host;
    }

    static class LogSearchFileNameRequestRunnable
    implements Runnable {
        private final String host;
        private final String component;
        private final String cluster;
        private final Set<String> currentRequests;
        private final Cache<String, Set<String>> logFileNameCache;
        private LoggingRequestHelperFactory loggingRequestHelperFactory;
        private final Map<String, AtomicInteger> componentRequestFailureCounts;
        private OBDPManagementController controller;

        LogSearchFileNameRequestRunnable(String host, String component, String cluster, Cache<String, Set<String>> logFileNameCache, Set<String> currentRequests, LoggingRequestHelperFactory loggingRequestHelperFactory, Map<String, AtomicInteger> componentRequestFailureCounts) {
            this(host, component, cluster, logFileNameCache, currentRequests, loggingRequestHelperFactory, componentRequestFailureCounts, OBDPServer.getController());
        }

        LogSearchFileNameRequestRunnable(String host, String component, String cluster, Cache<String, Set<String>> logFileNameCache, Set<String> currentRequests, LoggingRequestHelperFactory loggingRequestHelperFactory, Map<String, AtomicInteger> componentRequestFailureCounts, OBDPManagementController controller) {
            this.host = host;
            this.component = component;
            this.cluster = cluster;
            this.logFileNameCache = logFileNameCache;
            this.currentRequests = currentRequests;
            this.loggingRequestHelperFactory = loggingRequestHelperFactory;
            this.componentRequestFailureCounts = componentRequestFailureCounts;
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("LogSearchFileNameRequestRunnable: starting...");
            try {
                LoggingRequestHelper helper = this.loggingRequestHelperFactory.getHelper(this.controller, this.cluster);
                if (helper != null) {
                    HostLogFilesResponse logFilesResponse = helper.sendGetLogFileNamesRequest(this.host);
                    if (logFilesResponse != null && MapUtils.isNotEmpty(logFilesResponse.getHostLogFiles())) {
                        LOG.debug("LogSearchFileNameRequestRunnable: request was successful, updating cache");
                        for (Map.Entry<String, List<String>> componentEntry : logFilesResponse.getHostLogFiles().entrySet()) {
                            String key = LogSearchDataRetrievalService.generateKey(componentEntry.getKey(), this.host);
                            this.logFileNameCache.put((Object)key, new HashSet(componentEntry.getValue()));
                        }
                    } else {
                        LOG.debug("LogSearchFileNameRequestRunnable: remote request was not successful for component = {} on host ={}", (Object)this.component, (Object)this.host);
                        if (!this.componentRequestFailureCounts.containsKey(this.component)) {
                            this.componentRequestFailureCounts.put(this.component, new AtomicInteger());
                        }
                        this.componentRequestFailureCounts.get(this.component).incrementAndGet();
                    }
                } else {
                    LOG.debug("LogSearchFileNameRequestRunnable: request helper was null.  This may mean that LogSearch is not available, or could be a potential connection problem.");
                }
            }
            finally {
                this.currentRequests.remove(LogSearchDataRetrievalService.generateKey(this.component, this.host));
            }
        }

        protected void setLoggingRequestHelperFactory(LoggingRequestHelperFactory loggingRequestHelperFactory) {
            this.loggingRequestHelperFactory = loggingRequestHelperFactory;
        }

        protected void setAmbariManagementController(OBDPManagementController controller) {
            this.controller = controller;
        }
    }
}

