/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.jmx;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.jmx.JMXHostProvider;
import id.onyx.obdp.server.controller.jmx.JMXMetricHolder;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.ThreadPoolEnabledPropertyProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.state.services.MetricsRetrievalService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXPropertyProvider
extends ThreadPoolEnabledPropertyProvider {
    private static final String NAME_KEY = "name";
    private static final String PORT_KEY = "tag.port";
    private static final String DOT_REPLACEMENT_CHAR = "#";
    private static final Map<String, String> DEFAULT_JMX_PORTS = new HashMap<String, String>();
    private static final Map<String, Map<String, String>> AD_HOC_PROPERTIES = new HashMap<String, Map<String, String>>();
    private static final Logger LOG;
    private static final Pattern dotReplacementCharPattern;
    private final StreamProvider streamProvider;
    private final JMXHostProvider jmxHostProvider;
    private final String clusterNamePropertyId;
    private final String hostNamePropertyId;
    private final String componentNamePropertyId;
    private final String statePropertyId;
    private final Map<String, String> clusterComponentPortsMap;
    @Inject
    private MetricsRetrievalService metricsRetrievalService;

    @AssistedInject
    JMXPropertyProvider(@Assisted(value="componentMetrics") Map<String, Map<String, PropertyInfo>> componentMetrics, @Assisted(value="streamProvider") StreamProvider streamProvider, @Assisted(value="jmxHostProvider") JMXHostProvider jmxHostProvider, @Assisted(value="metricHostProvider") MetricHostProvider metricHostProvider, @Assisted(value="clusterNamePropertyId") String clusterNamePropertyId, @Assisted(value="hostNamePropertyId") @Nullable String hostNamePropertyId, @Assisted(value="componentNamePropertyId") String componentNamePropertyId, @Assisted(value="statePropertyId") @Nullable String statePropertyId) {
        super(componentMetrics, hostNamePropertyId, metricHostProvider, clusterNamePropertyId);
        this.streamProvider = streamProvider;
        this.jmxHostProvider = jmxHostProvider;
        this.clusterNamePropertyId = clusterNamePropertyId;
        this.hostNamePropertyId = hostNamePropertyId;
        this.componentNamePropertyId = componentNamePropertyId;
        this.statePropertyId = statePropertyId;
        this.clusterComponentPortsMap = new HashMap<String, String>();
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        this.clusterComponentPortsMap.clear();
        return super.populateResources(resources, request, predicate);
    }

    @Override
    protected Resource populateResource(Resource resource, Request request, Predicate predicate, ThreadPoolEnabledPropertyProvider.Ticket ticket) throws SystemException {
        Set<String> hostNames;
        String state;
        Set<String> ids = this.getRequestPropertyIds(request, predicate);
        HashSet<String> unsupportedIds = new HashSet<String>();
        String componentName = (String)resource.getPropertyValue(this.componentNamePropertyId);
        if (this.getComponentMetrics().get(componentName) == null) {
            return resource;
        }
        for (String id : ids) {
            if (request.getTemporalInfo(id) != null) {
                unsupportedIds.add(id);
            }
            if (this.isSupportedPropertyId(componentName, id)) continue;
            unsupportedIds.add(id);
        }
        ids.removeAll(unsupportedIds);
        if (ids.isEmpty()) {
            return resource;
        }
        if (this.statePropertyId != null && (state = (String)resource.getPropertyValue(this.statePropertyId)) != null && !healthyStates.contains(state)) {
            return resource;
        }
        String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
        String protocol = this.jmxHostProvider.getJMXProtocol(clusterName, componentName);
        boolean httpsEnabled = false;
        if (protocol.equals("https")) {
            httpsEnabled = true;
        }
        if ((hostNames = this.getHosts(resource, clusterName, componentName)) == null || hostNames.isEmpty()) {
            LOG.warn("Unable to get JMX metrics.  No host name for " + componentName);
            return resource;
        }
        Object spec = null;
        for (String hostName : hostNames) {
            try {
                String port = this.getPort(clusterName, componentName, hostName, httpsEnabled);
                String publicHostName = this.jmxHostProvider.getPublicHostName(clusterName, hostName);
                if (port == null) {
                    LOG.warn("Unable to get JMX metrics.  No port value for " + componentName);
                    return resource;
                }
                String jmxUrl = this.getSpec(protocol, hostName, port, "/jmx");
                this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.JMX, this.streamProvider, jmxUrl);
                JMXMetricHolder jmxMetricHolder = this.metricsRetrievalService.getCachedJMXMetric(jmxUrl);
                if (jmxMetricHolder == null && !hostName.equalsIgnoreCase(publicHostName)) {
                    String publicJmxUrl = this.getSpec(protocol, publicHostName, port, "/jmx");
                    this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.JMX, this.streamProvider, publicJmxUrl);
                    jmxMetricHolder = this.metricsRetrievalService.getCachedJMXMetric(publicJmxUrl);
                }
                if (!ticket.isValid()) {
                    return resource;
                }
                if (null != jmxMetricHolder) {
                    this.getHadoopMetricValue(jmxMetricHolder, ids, resource, request, ticket);
                }
                if (!AD_HOC_PROPERTIES.containsKey(componentName)) continue;
                for (String propertyId : ids) {
                    for (String adHocId : AD_HOC_PROPERTIES.get(componentName).keySet()) {
                        String queryURL = null;
                        if (adHocId.equals(propertyId) || adHocId.startsWith(propertyId + "/")) {
                            queryURL = AD_HOC_PROPERTIES.get(componentName).get(adHocId);
                        }
                        if (queryURL == null) continue;
                        String adHocUrl = this.getSpec(protocol, hostName, port, queryURL);
                        this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.JMX, this.streamProvider, adHocUrl);
                        JMXMetricHolder adHocJMXMetricHolder = this.metricsRetrievalService.getCachedJMXMetric(adHocUrl);
                        if (adHocJMXMetricHolder == null && !hostName.equalsIgnoreCase(publicHostName)) {
                            String publicAdHocUrl = this.getSpec(protocol, publicHostName, port, queryURL);
                            this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.JMX, this.streamProvider, publicAdHocUrl);
                            adHocJMXMetricHolder = this.metricsRetrievalService.getCachedJMXMetric(publicAdHocUrl);
                        }
                        if (!ticket.isValid()) {
                            return resource;
                        }
                        if (null == adHocJMXMetricHolder) continue;
                        this.getHadoopMetricValue(adHocJMXMetricHolder, Collections.singleton(propertyId), resource, request, ticket);
                    }
                }
            }
            catch (IOException e) {
                OBDPException detailedException = new OBDPException(String.format("Unable to get JMX metrics from the host %s for the component %s. Spec: %s", hostName, componentName, spec), (Throwable)e);
                JMXPropertyProvider.logException(detailedException);
            }
        }
        return resource;
    }

    private void getHadoopMetricValue(JMXMetricHolder metricHolder, Set<String> ids, Resource resource, Request request, ThreadPoolEnabledPropertyProvider.Ticket ticket) throws IOException {
        HashMap<String, Map<String, Object>> categories = new HashMap<String, Map<String, Object>>();
        String componentName = (String)resource.getPropertyValue(this.componentNamePropertyId);
        String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
        for (Map<String, Object> bean : metricHolder.getBeans()) {
            String category = this.getCategory(bean, clusterName, componentName);
            if (category == null) continue;
            categories.put(category, bean);
        }
        for (String propertyId : ids) {
            Map<String, PropertyInfo> propertyInfoMap = this.getPropertyInfoMap(componentName, propertyId);
            String requestedPropertyId = propertyId;
            for (Map.Entry<String, PropertyInfo> entry : propertyInfoMap.entrySet()) {
                int keyEndIndex;
                PropertyInfo propertyInfo = entry.getValue();
                propertyId = entry.getKey();
                if (!propertyInfo.isPointInTime()) continue;
                String property = propertyInfo.getPropertyId();
                String category = "";
                LinkedList<String> keyList = new LinkedList<String>();
                int keyStartIndex = property.indexOf(91);
                if (-1 != keyStartIndex && -1 != (keyEndIndex = property.indexOf(93, keyStartIndex)) && keyEndIndex > keyStartIndex) {
                    keyList.add(property.substring(keyStartIndex + 1, keyEndIndex));
                }
                if (!this.containsArguments(propertyId)) {
                    int dotIndex = property.indexOf(46, property.indexOf(61));
                    if (-1 != dotIndex) {
                        category = property.substring(0, dotIndex);
                        property = -1 == keyStartIndex ? property.substring(dotIndex + 1) : property.substring(dotIndex + 1, keyStartIndex);
                    }
                } else {
                    int firstKeyIndex = keyStartIndex > -1 ? keyStartIndex : property.length();
                    int dotIndex = property.lastIndexOf(46, firstKeyIndex);
                    if (dotIndex != -1) {
                        category = property.substring(0, dotIndex);
                        property = property.substring(dotIndex + 1, firstKeyIndex);
                    }
                }
                if (this.containsArguments(propertyId)) {
                    Pattern pattern = Pattern.compile(category);
                    for (String jmxCat : categories.keySet()) {
                        Matcher matcher = pattern.matcher(jmxCat);
                        if (!matcher.matches()) continue;
                        String newPropertyId = propertyId;
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            newPropertyId = JMXPropertyProvider.substituteArgument(newPropertyId, "$" + (i + 1), matcher.group(i + 1));
                        }
                        if (!JMXPropertyProvider.isRequestedPropertyId(newPropertyId, requestedPropertyId, request)) continue;
                        if (!ticket.isValid()) {
                            return;
                        }
                        this.setResourceValue(resource, categories, newPropertyId, jmxCat, property, keyList);
                    }
                    continue;
                }
                if (!ticket.isValid()) {
                    return;
                }
                this.setResourceValue(resource, categories, propertyId, category, property, keyList);
            }
        }
    }

    private void setResourceValue(Resource resource, Map<String, Map<String, Object>> categories, String propertyId, String category, String property, List<String> keyList) {
        Map<String, Object> properties = categories.get(category);
        if (property.contains(DOT_REPLACEMENT_CHAR)) {
            property = dotReplacementCharPattern.matcher(property).replaceAll(".");
        }
        if (properties != null && properties.containsKey(property)) {
            Object value = properties.get(property);
            if (keyList.size() > 0 && value instanceof Map) {
                String key;
                Map map = (Map)value;
                Iterator<String> iterator = keyList.iterator();
                while (iterator.hasNext() && (value = map.get(key = iterator.next())) instanceof Map) {
                    map = (Map)value;
                }
            }
            resource.setProperty(propertyId, value);
        }
    }

    private String getPort(String clusterName, String componentName, String hostName, boolean httpsEnabled) throws SystemException {
        String portMapKey = String.format("%s-%s-%s", clusterName, componentName, httpsEnabled);
        String port = this.clusterComponentPortsMap.get(portMapKey);
        if (port == null) {
            port = this.jmxHostProvider.getPort(clusterName, componentName, hostName, httpsEnabled);
            port = port == null ? DEFAULT_JMX_PORTS.get(componentName) : port;
            this.clusterComponentPortsMap.put(portMapKey, port);
        }
        return port;
    }

    private Set<String> getHosts(Resource resource, String clusterName, String componentName) {
        return this.hostNamePropertyId == null ? this.jmxHostProvider.getHostNames(clusterName, componentName) : Collections.singleton((String)resource.getPropertyValue(this.hostNamePropertyId));
    }

    private String getCategory(Map<String, Object> bean, String clusterName, String componentName) {
        if (bean.containsKey(NAME_KEY)) {
            String name = (String)bean.get(NAME_KEY);
            if (bean.containsKey(PORT_KEY)) {
                String port = (String)bean.get(PORT_KEY);
                String tag = this.jmxHostProvider.getJMXRpcMetricTag(clusterName, componentName, port);
                name = name.replace("ForPort" + port, (CharSequence)(tag == null ? "" : ",tag=" + tag));
            }
            return name;
        }
        return null;
    }

    static {
        DEFAULT_JMX_PORTS.put("NAMENODE", "50070");
        DEFAULT_JMX_PORTS.put("DATANODE", "50075");
        DEFAULT_JMX_PORTS.put("HBASE_MASTER", "60010");
        DEFAULT_JMX_PORTS.put("HBASE_REGIONSERVER", "60030");
        DEFAULT_JMX_PORTS.put("RESOURCEMANAGER", "8088");
        DEFAULT_JMX_PORTS.put("HISTORYSERVER", "19888");
        DEFAULT_JMX_PORTS.put("NODEMANAGER", "8042");
        DEFAULT_JMX_PORTS.put("JOURNALNODE", "8480");
        DEFAULT_JMX_PORTS.put("STORM_REST_API", "8745");
        DEFAULT_JMX_PORTS.put("OZONE_MANAGER", "9874");
        DEFAULT_JMX_PORTS.put("STORAGE_CONTAINER_MANAGER", "9876");
        AD_HOC_PROPERTIES.put("NAMENODE", Collections.singletonMap("metrics/dfs/FSNamesystem/HAState", "/jmx?get=Hadoop:service=NameNode,name=FSNamesystem::tag.HAState"));
        LOG = LoggerFactory.getLogger(JMXPropertyProvider.class);
        dotReplacementCharPattern = Pattern.compile(DOT_REPLACEMENT_CHAR);
    }
}

