/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.jmx;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class JMXMetricHolder {
    private static final String NAME_KEY = "name";
    private List<Map<String, Object>> beans;

    public List<Map<String, Object>> getBeans() {
        return this.beans;
    }

    public void setBeans(List<Map<String, Object>> beans) {
        this.beans = beans;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map<String, Object> map : this.beans) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append("    ").append(entry).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public List<Object> findAll(List<String> properties) {
        return properties.stream().map(this::find).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<Object> find(String pattern) {
        JmxPattern jmxPattern = JmxPattern.parse(pattern);
        return this.beans.stream().map(jmxPattern::extract).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static class JmxPattern {
        private static final Pattern PATTERN = Pattern.compile("(.*?)\\[(\\S+?)\\]");
        private final String beanName;
        private final String propertyName;
        @Nullable
        private final String key;

        public static JmxPattern parse(String property) {
            String beanName = property.split("/")[0];
            String propertyName = property.split("/")[1];
            String key = null;
            Matcher matcher = PATTERN.matcher(propertyName);
            if (matcher.matches()) {
                propertyName = matcher.group(1);
                key = matcher.group(2);
            }
            return new JmxPattern(beanName, propertyName, key);
        }

        private JmxPattern(String beanName, String propertyName, String key) {
            this.beanName = beanName;
            this.propertyName = propertyName;
            this.key = key;
        }

        public Optional<Object> extract(Map<String, Object> bean) {
            return this.beanName.equals(this.name(bean)) ? Optional.ofNullable(this.lookupByKey(bean.get(this.propertyName))) : Optional.empty();
        }

        public Object lookupByKey(Object bean) {
            return this.key != null && bean instanceof Map ? ((Map)bean).get(this.key) : bean;
        }

        private String name(Map<String, Object> bean) {
            return bean.containsKey(JMXMetricHolder.NAME_KEY) ? (String)bean.get(JMXMetricHolder.NAME_KEY) : null;
        }
    }
}

