/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.jdbc;

import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;

public class SQLPredicateVisitor
implements PredicateVisitor {
    private final StringBuilder stringBuilder = new StringBuilder();

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        String propertyId = predicate.getPropertyId();
        String propertyCategory = PropertyHelper.getPropertyCategory(propertyId);
        if (propertyCategory != null) {
            this.stringBuilder.append(propertyCategory).append(".");
        }
        this.stringBuilder.append(PropertyHelper.getPropertyName(propertyId));
        this.stringBuilder.append(" ").append(predicate.getOperator()).append(" \"");
        this.stringBuilder.append(predicate.getValue());
        this.stringBuilder.append("\"");
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate predicate) {
        Predicate[] predicates = predicate.getPredicates();
        if (predicates.length > 0) {
            this.stringBuilder.append("(");
            for (int i = 0; i < predicates.length; ++i) {
                if (i > 0) {
                    this.stringBuilder.append(" ").append(predicate.getOperator()).append(" ");
                }
                PredicateHelper.visit(predicates[i], this);
            }
            this.stringBuilder.append(")");
        }
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
        this.stringBuilder.append(predicate.getOperator()).append("(");
        PredicateHelper.visit(predicate.getPredicate(), this);
        this.stringBuilder.append(")");
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
        this.stringBuilder.append("TRUE");
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
    }

    public String getSQL() {
        return this.stringBuilder.toString();
    }
}

