/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.jdbc;

import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.jdbc.ConnectionFactory;
import id.onyx.obdp.server.controller.jdbc.SQLPredicateVisitor;
import id.onyx.obdp.server.controller.predicate.BasePredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitorAcceptor;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResourceProvider
extends BaseProvider
implements ResourceProvider {
    private final Resource.Type type;
    private final ConnectionFactory connectionFactory;
    private final Map<Resource.Type, String> keyPropertyIds;
    private final Map<String, Map<String, String>> importedKeys = new HashMap<String, Map<String, String>>();
    private static final Logger LOG = LoggerFactory.getLogger(JDBCResourceProvider.class);

    public JDBCResourceProvider(ConnectionFactory connectionFactory, Resource.Type type, Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds) {
        super(propertyIds);
        this.connectionFactory = connectionFactory;
        this.type = type;
        this.keyPropertyIds = keyPropertyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> propertyIds = this.getRequestPropertyIds(request, predicate);
        propertyIds.remove(PropertyHelper.getPropertyId("Clusters", "cluster_id"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "disk_info"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "public_host_name"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "last_registration_time"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "host_state"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "last_heartbeat_time"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "host_health_report"));
        propertyIds.remove(PropertyHelper.getPropertyId("Hosts", "host_status"));
        propertyIds.remove(PropertyHelper.getPropertyId("ServiceInfo", "desired_configs"));
        propertyIds.remove(PropertyHelper.getPropertyId("ServiceComponentInfo", "desired_configs"));
        propertyIds.remove(PropertyHelper.getPropertyId("HostRoles", "configs"));
        propertyIds.remove(PropertyHelper.getPropertyId("HostRoles", "desired_configs"));
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            connection = this.connectionFactory.getConnection();
            for (String table : JDBCResourceProvider.getTables(propertyIds)) {
                this.getImportedKeys(connection, table);
            }
            String sql = this.getSelectSQL(propertyIds, predicate);
            statement = connection.createStatement();
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                ResourceImpl resource = new ResourceImpl(this.type);
                for (int i = 1; i <= columnCount; ++i) {
                    String propertyId = PropertyHelper.getPropertyId(metaData.getTableName(i), metaData.getColumnName(i));
                    if (!propertyIds.contains(propertyId)) continue;
                    resource.setProperty(propertyId, rs.getString(i));
                }
                resources.add(resource);
            }
            statement.close();
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caught exception getting resource.", (Throwable)e);
            }
            Set<Resource> set = Collections.emptySet();
            return set;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Exception while closing ResultSet", (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Exception while closing statment", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Exception while closing statment", (Throwable)e);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            try (Statement statement = null;){
                Set<Map<String, Object>> propertySet = request.getProperties();
                statement = connection.createStatement();
                for (Map<String, Object> properties : propertySet) {
                    String sql = this.getInsertSQL(properties);
                    statement.execute(sql);
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("DB error : ", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw new IllegalStateException("DB error : ", ex);
                }
            }
        }
        return this.getRequestStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            try (Statement statement = null;){
                Set<Map<String, Object>> propertySet = request.getProperties();
                Map<String, Object> properties = propertySet.iterator().next();
                String sql = this.getUpdateSQL(properties, predicate);
                statement = connection.createStatement();
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("DB error : ", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw new IllegalStateException("DB error : ", ex);
                }
            }
        }
        return this.getRequestStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            try (Statement statement = null;){
                String sql = this.getDeleteSQL(predicate);
                statement = connection.createStatement();
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("DB error : ", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw new IllegalStateException("DB error : ", ex);
                }
            }
        }
        return this.getRequestStatus();
    }

    private String getInsertSQL(Map<String, Object> properties) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        String table = null;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyId = entry.getKey();
            Object propertyValue = entry.getValue();
            table = PropertyHelper.getPropertyCategory(propertyId);
            if (columns.length() > 0) {
                columns.append(", ");
            }
            columns.append(PropertyHelper.getPropertyName(propertyId));
            if (values.length() > 0) {
                values.append(", ");
            }
            values.append("'");
            values.append(propertyValue);
            values.append("'");
        }
        return "insert into " + table + " (" + columns + ") values (" + values + ")";
    }

    /*
     * WARNING - void declaration
     */
    private String getSelectSQL(Set<String> propertyIds, Predicate predicate) {
        void var9_14;
        StringBuilder columns = new StringBuilder();
        HashSet<String> tableSet = new HashSet<String>();
        for (String propertyId : propertyIds) {
            if (columns.length() > 0) {
                columns.append(", ");
            }
            String propertyCategory = PropertyHelper.getPropertyCategory(propertyId);
            columns.append(propertyCategory).append(".").append(PropertyHelper.getPropertyName(propertyId));
            tableSet.add(propertyCategory);
        }
        boolean haveWhereClause = false;
        StringBuilder whereClause = new StringBuilder();
        if (predicate != null && propertyIds.containsAll(PredicateHelper.getPropertyIds(predicate)) && predicate instanceof PredicateVisitorAcceptor) {
            SQLPredicateVisitor visitor = new SQLPredicateVisitor();
            ((PredicateVisitorAcceptor)((Object)predicate)).accept(visitor);
            whereClause.append(visitor.getSQL());
            haveWhereClause = true;
        }
        StringBuilder joinClause = new StringBuilder();
        if (tableSet.size() > 1) {
            for (String string : tableSet) {
                Map<String, String> joinKeys = this.importedKeys.get(string);
                if (joinKeys == null) continue;
                for (Map.Entry<String, String> entry : joinKeys.entrySet()) {
                    String category1 = PropertyHelper.getPropertyCategory(entry.getKey());
                    String category2 = PropertyHelper.getPropertyCategory(entry.getValue());
                    if (!tableSet.contains(category1) || !tableSet.contains(category2)) continue;
                    if (haveWhereClause) {
                        joinClause.append(" AND ");
                    }
                    joinClause.append(category1).append(".").append(PropertyHelper.getPropertyName(entry.getKey()));
                    joinClause.append(" = ");
                    joinClause.append(category2).append(".").append(PropertyHelper.getPropertyName(entry.getValue()));
                    tableSet.add(category1);
                    tableSet.add(category2);
                    haveWhereClause = true;
                }
            }
        }
        StringBuilder tables = new StringBuilder();
        for (String table : tableSet) {
            if (tables.length() > 0) {
                tables.append(", ");
            }
            tables.append(table);
        }
        String string = "select " + columns + " from " + tables;
        if (haveWhereClause) {
            String string2 = string + " where " + whereClause + joinClause;
        }
        return var9_14;
    }

    private String getDeleteSQL(Predicate predicate) {
        StringBuilder whereClause = new StringBuilder();
        if (predicate instanceof BasePredicate) {
            BasePredicate basePredicate = (BasePredicate)predicate;
            SQLPredicateVisitor visitor = new SQLPredicateVisitor();
            basePredicate.accept(visitor);
            whereClause.append(visitor.getSQL());
            String table = PropertyHelper.getPropertyCategory(basePredicate.getPropertyIds().iterator().next());
            return "delete from " + table + " where " + whereClause;
        }
        throw new IllegalStateException("Can't generate SQL.");
    }

    private String getUpdateSQL(Map<String, Object> properties, Predicate predicate) {
        if (predicate instanceof BasePredicate) {
            StringBuilder whereClause = new StringBuilder();
            BasePredicate basePredicate = (BasePredicate)predicate;
            SQLPredicateVisitor visitor = new SQLPredicateVisitor();
            basePredicate.accept(visitor);
            whereClause.append(visitor.getSQL());
            String table = PropertyHelper.getPropertyCategory(basePredicate.getPropertyIds().iterator().next());
            StringBuilder setClause = new StringBuilder();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                if (setClause.length() > 0) {
                    setClause.append(", ");
                }
                setClause.append(PropertyHelper.getPropertyName(entry.getKey()));
                setClause.append(" = ");
                setClause.append("'");
                setClause.append(entry.getValue());
                setClause.append("'");
            }
            return "update " + table + " set " + setClause + " where " + whereClause;
        }
        throw new IllegalStateException("Can't generate SQL.");
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return this.keyPropertyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImportedKeys(Connection connection, String table) throws SQLException {
        if (!this.importedKeys.containsKey(table)) {
            HashMap<String, String> importedKeys = new HashMap<String, String>();
            this.importedKeys.put(table, importedKeys);
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = null;){
                rs = metaData.getImportedKeys(connection.getCatalog(), null, table);
                while (rs.next()) {
                    String pkPropertyId = PropertyHelper.getPropertyId(rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                    String fkPropertyId = PropertyHelper.getPropertyId(rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"));
                    importedKeys.put(pkPropertyId, fkPropertyId);
                }
            }
        }
    }

    private RequestStatus getRequestStatus() {
        return new RequestStatusImpl(null);
    }

    private static Set<String> getTables(Set<String> propertyIds) {
        HashSet<String> tables = new HashSet<String>();
        for (String propertyId : propertyIds) {
            tables.add(PropertyHelper.getPropertyCategory(propertyId));
        }
        return tables;
    }
}

