/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractJDBCResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.jdbc.ConnectionFactory;
import id.onyx.obdp.server.controller.jdbc.JobHistoryPostgresConnectionFactory;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowResourceProvider
extends AbstractJDBCResourceProvider<WorkflowFields> {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowResourceProvider.class);
    protected static final String WORKFLOW_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "cluster_name");
    protected static final String WORKFLOW_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "workflow_id");
    protected static final String WORKFLOW_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "name");
    protected static final String WORKFLOW_USER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "user_name");
    protected static final String WORKFLOW_START_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "start_time");
    protected static final String WORKFLOW_LAST_UPDATE_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "last_update_time");
    protected static final String WORKFLOW_ELAPSED_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "elapsed_time");
    protected static final String WORKFLOW_INPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "input_bytes");
    protected static final String WORKFLOW_OUTPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "output_bytes");
    protected static final String WORKFLOW_NUM_JOBS_TOTAL_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "num_jobs_total");
    protected static final String WORKFLOW_NUM_JOBS_COMPLETED_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "num_jobs_completed");
    protected static final String WORKFLOW_PARENT_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "parent_id");
    protected static final String WORKFLOW_CONTEXT_PROPERTY_ID = PropertyHelper.getPropertyId("Workflow", "context");
    protected WorkflowFetcher workflowFetcher;
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)WORKFLOW_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.Workflow, (Object)WORKFLOW_ID_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{WORKFLOW_CLUSTER_NAME_PROPERTY_ID, WORKFLOW_ID_PROPERTY_ID, WORKFLOW_NAME_PROPERTY_ID, WORKFLOW_USER_NAME_PROPERTY_ID, WORKFLOW_START_TIME_PROPERTY_ID, WORKFLOW_LAST_UPDATE_TIME_PROPERTY_ID, WORKFLOW_ELAPSED_TIME_PROPERTY_ID, WORKFLOW_INPUT_BYTES_PROPERTY_ID, WORKFLOW_OUTPUT_BYTES_PROPERTY_ID, WORKFLOW_NUM_JOBS_TOTAL_PROPERTY_ID, WORKFLOW_NUM_JOBS_COMPLETED_PROPERTY_ID, WORKFLOW_PARENT_ID_PROPERTY_ID, WORKFLOW_CONTEXT_PROPERTY_ID});

    protected WorkflowResourceProvider() {
        super(propertyIds, keyPropertyIds);
        this.workflowFetcher = new PostgresWorkflowFetcher(new JobHistoryPostgresConnectionFactory());
    }

    protected WorkflowResourceProvider(WorkflowFetcher workflowFetcher) {
        super(propertyIds, keyPropertyIds);
        this.workflowFetcher = workflowFetcher;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> predicatePropertieSet = this.getPropertyMaps(predicate);
        for (Map<String, Object> predicateProperties : predicatePropertieSet) {
            String clusterName = (String)predicateProperties.get(WORKFLOW_CLUSTER_NAME_PROPERTY_ID);
            String workflowId = (String)predicateProperties.get(WORKFLOW_ID_PROPERTY_ID);
            resourceSet.addAll(this.workflowFetcher.fetchWorkflows(requestedIds, clusterName, workflowId));
        }
        return resourceSet;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Map<String, WorkflowFields> getDBFieldMap() {
        HashMap<String, WorkflowFields> dbFields = new HashMap<String, WorkflowFields>();
        dbFields.put(WORKFLOW_ID_PROPERTY_ID, WorkflowFields.WORKFLOWID);
        dbFields.put(WORKFLOW_NAME_PROPERTY_ID, WorkflowFields.WORKFLOWNAME);
        dbFields.put(WORKFLOW_USER_NAME_PROPERTY_ID, WorkflowFields.USERNAME);
        dbFields.put(WORKFLOW_START_TIME_PROPERTY_ID, WorkflowFields.STARTTIME);
        dbFields.put(WORKFLOW_LAST_UPDATE_TIME_PROPERTY_ID, WorkflowFields.LASTUPDATETIME);
        dbFields.put(WORKFLOW_ELAPSED_TIME_PROPERTY_ID, WorkflowFields.DURATION);
        dbFields.put(WORKFLOW_INPUT_BYTES_PROPERTY_ID, WorkflowFields.INPUTBYTES);
        dbFields.put(WORKFLOW_OUTPUT_BYTES_PROPERTY_ID, WorkflowFields.OUTPUTBYTES);
        dbFields.put(WORKFLOW_NUM_JOBS_TOTAL_PROPERTY_ID, WorkflowFields.NUMJOBSTOTAL);
        dbFields.put(WORKFLOW_NUM_JOBS_COMPLETED_PROPERTY_ID, WorkflowFields.NUMJOBSCOMPLETED);
        dbFields.put(WORKFLOW_PARENT_ID_PROPERTY_ID, WorkflowFields.PARENTWORKFLOWID);
        dbFields.put(WORKFLOW_CONTEXT_PROPERTY_ID, WorkflowFields.WORKFLOWCONTEXT);
        return dbFields;
    }

    protected class PostgresWorkflowFetcher
    implements WorkflowFetcher {
        private static final String WORKFLOW_TABLE_NAME = "workflow";
        private ConnectionFactory connectionFactory;
        private Connection db;
        private PreparedStatement ps;

        public PostgresWorkflowFetcher(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            this.db = null;
            this.ps = null;
        }

        protected ResultSet getResultSet(Set<String> requestedIds, String workflowId) throws SQLException {
            this.db = null;
            this.ps = null;
            this.db = this.connectionFactory.getConnection();
            if (workflowId == null) {
                this.ps = this.db.prepareStatement("SELECT " + WorkflowResourceProvider.this.getDBFieldString(requestedIds) + " FROM workflow");
            } else {
                this.ps = this.db.prepareStatement("SELECT " + WorkflowResourceProvider.this.getDBFieldString(requestedIds) + " FROM workflow WHERE " + WorkflowFields.WORKFLOWID + " = ?");
                this.ps.setString(1, workflowId);
            }
            return this.ps.executeQuery();
        }

        protected void close() {
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing statment", (Throwable)e);
                }
            }
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing connection", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Resource> fetchWorkflows(Set<String> requestedIds, String clusterName, String workflowId) {
            HashSet<Resource> workflows = new HashSet<Resource>();
            ResultSet rs = null;
            try {
                rs = this.getResultSet(requestedIds, workflowId);
                while (rs.next()) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.Workflow);
                    BaseProvider.setResourceProperty(resource, WORKFLOW_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
                    WorkflowResourceProvider.this.setString(resource, WORKFLOW_ID_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setString(resource, WORKFLOW_NAME_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setString(resource, WORKFLOW_USER_NAME_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setLong(resource, WORKFLOW_START_TIME_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setLong(resource, WORKFLOW_LAST_UPDATE_TIME_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setLong(resource, WORKFLOW_ELAPSED_TIME_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setLong(resource, WORKFLOW_INPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setLong(resource, WORKFLOW_OUTPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setInt(resource, WORKFLOW_NUM_JOBS_TOTAL_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setInt(resource, WORKFLOW_NUM_JOBS_COMPLETED_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setString(resource, WORKFLOW_PARENT_ID_PROPERTY_ID, rs, requestedIds);
                    WorkflowResourceProvider.this.setString(resource, WORKFLOW_CONTEXT_PROPERTY_ID, rs, requestedIds);
                    workflows.add(resource);
                }
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception getting resource.", (Throwable)e);
                }
                Set<Resource> set = Collections.emptySet();
                return set;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("Exception while closing ResultSet", (Throwable)e);
                    }
                }
                this.close();
            }
            return workflows;
        }
    }

    public static interface WorkflowFetcher {
        public Set<Resource> fetchWorkflows(Set<String> var1, String var2, String var3);
    }

    static enum WorkflowFields {
        WORKFLOWID,
        WORKFLOWNAME,
        USERNAME,
        STARTTIME,
        LASTUPDATETIME,
        DURATION,
        NUMJOBSTOTAL,
        NUMJOBSCOMPLETED,
        INPUTBYTES,
        OUTPUTBYTES,
        PARENTWORKFLOWID,
        WORKFLOWCONTEXT;

    }
}

