/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.WidgetDAO;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutUserWidgetEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.security.access.AccessDeniedException;

@StaticallyInject
public class WidgetResourceProvider
extends AbstractControllerResourceProvider {
    public static final String WIDGET_ID_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "id");
    public static final String WIDGET_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "cluster_name");
    public static final String WIDGET_WIDGET_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "widget_name");
    public static final String WIDGET_WIDGET_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "widget_type");
    public static final String WIDGET_TIME_CREATED_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "time_created");
    public static final String WIDGET_AUTHOR_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "author");
    public static final String WIDGET_DESCRIPTION_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "description");
    public static final String WIDGET_SCOPE_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "scope");
    public static final String WIDGET_METRICS_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "metrics");
    public static final String WIDGET_VALUES_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "values");
    public static final String WIDGET_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "properties");
    public static final String WIDGET_TAG_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetInfo", "tag");
    private static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)WIDGET_ID_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)WIDGET_ID_PROPERTY_ID).add((Object)WIDGET_WIDGET_NAME_PROPERTY_ID).add((Object)WIDGET_WIDGET_TYPE_PROPERTY_ID).add((Object)WIDGET_TIME_CREATED_PROPERTY_ID).add((Object)WIDGET_CLUSTER_NAME_PROPERTY_ID).add((Object)WIDGET_AUTHOR_PROPERTY_ID).add((Object)WIDGET_DESCRIPTION_PROPERTY_ID).add((Object)WIDGET_SCOPE_PROPERTY_ID).add((Object)WIDGET_METRICS_PROPERTY_ID).add((Object)WIDGET_VALUES_PROPERTY_ID).add((Object)WIDGET_PROPERTIES_PROPERTY_ID).add((Object)WIDGET_TAG_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Widget, (Object)WIDGET_ID_PROPERTY_ID).put((Object)Resource.Type.Cluster, (Object)WIDGET_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.User, (Object)WIDGET_AUTHOR_PROPERTY_ID).build();
    @Inject
    private static WidgetDAO widgetDAO;
    private static Gson gson;

    public WidgetResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Widget, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (final Map<String, Object> properties : request.getProperties()) {
            WidgetEntity widgetEntity = this.createResources(new AbstractResourceProvider.Command<WidgetEntity>(){

                @Override
                public WidgetEntity invoke() throws OBDPException {
                    String[] requiredProperties;
                    for (String propertyName : requiredProperties = new String[]{WIDGET_CLUSTER_NAME_PROPERTY_ID, WIDGET_WIDGET_NAME_PROPERTY_ID, WIDGET_WIDGET_TYPE_PROPERTY_ID, WIDGET_SCOPE_PROPERTY_ID}) {
                        if (properties.get(propertyName) != null) continue;
                        throw new OBDPException("Property " + propertyName + " should be provided");
                    }
                    WidgetEntity entity = new WidgetEntity();
                    String clusterName = properties.get(WIDGET_CLUSTER_NAME_PROPERTY_ID).toString();
                    String scope = properties.get(WIDGET_SCOPE_PROPERTY_ID).toString();
                    if (!WidgetResourceProvider.this.isScopeAllowedForUser(scope, clusterName)) {
                        throw new AccessDeniedException("Only cluster operator can create widgets with cluster scope");
                    }
                    entity.setWidgetName(StringEscapeUtils.escapeHtml4((String)properties.get(WIDGET_WIDGET_NAME_PROPERTY_ID).toString()));
                    entity.setWidgetType(properties.get(WIDGET_WIDGET_TYPE_PROPERTY_ID).toString());
                    entity.setClusterId(WidgetResourceProvider.this.getManagementController().getClusters().getCluster(clusterName).getClusterId());
                    entity.setScope(scope);
                    String metrics = properties.containsKey(WIDGET_METRICS_PROPERTY_ID) ? gson.toJson(properties.get(WIDGET_METRICS_PROPERTY_ID)) : null;
                    entity.setMetrics(metrics);
                    entity.setAuthor(WidgetResourceProvider.this.getAuthorName(properties));
                    String description = properties.containsKey(WIDGET_DESCRIPTION_PROPERTY_ID) ? StringEscapeUtils.escapeHtml4((String)properties.get(WIDGET_DESCRIPTION_PROPERTY_ID).toString()) : null;
                    entity.setDescription(description);
                    String values = properties.containsKey(WIDGET_VALUES_PROPERTY_ID) ? gson.toJson(properties.get(WIDGET_VALUES_PROPERTY_ID)) : null;
                    entity.setWidgetValues(values);
                    HashMap widgetPropertiesMap = new HashMap();
                    for (Map.Entry entry : properties.entrySet()) {
                        if (!PropertyHelper.getPropertyCategory((String)entry.getKey()).equals(WIDGET_PROPERTIES_PROPERTY_ID)) continue;
                        widgetPropertiesMap.put(PropertyHelper.getPropertyName((String)entry.getKey()), entry.getValue());
                    }
                    String widgetProperties = widgetPropertiesMap.isEmpty() ? null : gson.toJson(widgetPropertiesMap);
                    entity.setProperties(widgetProperties);
                    if (properties.containsKey(WIDGET_TAG_PROPERTY_ID)) {
                        entity.setTag(properties.get(WIDGET_TAG_PROPERTY_ID).toString());
                    }
                    widgetDAO.create(entity);
                    WidgetResourceProvider.this.notifyCreate(Resource.Type.Widget, request);
                    return entity;
                }
            });
            ResourceImpl resource = new ResourceImpl(Resource.Type.Widget);
            resource.setProperty(WIDGET_ID_PROPERTY_ID, widgetEntity.getId());
            associatedResources.add(resource);
        }
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        String author = AuthorizationHelper.getAuthenticatedName();
        ArrayList<WidgetEntity> requestedEntities = new ArrayList<WidgetEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            if (propertyMap.get(WIDGET_ID_PROPERTY_ID) != null) {
                Long id;
                try {
                    id = Long.parseLong(propertyMap.get(WIDGET_ID_PROPERTY_ID).toString());
                }
                catch (Exception ex) {
                    throw new SystemException("WidgetLayout should have numerical id");
                }
                WidgetEntity entity = widgetDAO.findById(id);
                if (entity == null) {
                    throw new NoSuchResourceException("WidgetLayout with id " + id + " does not exists");
                }
                if (!entity.getAuthor().equals(author) && !entity.getScope().equals(SCOPE.CLUSTER.name())) {
                    throw new AccessDeniedException("User must be author of the widget or widget must have cluster scope");
                }
                requestedEntities.add(entity);
                continue;
            }
            requestedEntities.addAll(widgetDAO.findByScopeOrAuthor(author, SCOPE.CLUSTER.name()));
        }
        for (WidgetEntity entity : requestedEntities) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Widget);
            resource.setProperty(WIDGET_ID_PROPERTY_ID, entity.getId());
            resource.setProperty(WIDGET_WIDGET_NAME_PROPERTY_ID, entity.getWidgetName());
            resource.setProperty(WIDGET_WIDGET_TYPE_PROPERTY_ID, entity.getWidgetType());
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_METRICS_PROPERTY_ID, entity.getMetrics(), requestedIds);
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_TIME_CREATED_PROPERTY_ID, entity.getTimeCreated(), requestedIds);
            resource.setProperty(WIDGET_AUTHOR_PROPERTY_ID, entity.getAuthor());
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_DESCRIPTION_PROPERTY_ID, entity.getDescription(), requestedIds);
            resource.setProperty(WIDGET_SCOPE_PROPERTY_ID, entity.getScope());
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_VALUES_PROPERTY_ID, entity.getWidgetValues(), requestedIds);
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_PROPERTIES_PROPERTY_ID, entity.getProperties(), requestedIds);
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_TAG_PROPERTY_ID, entity.getTag(), requestedIds);
            String clusterName = null;
            try {
                clusterName = this.getManagementController().getClusters().getClusterById(entity.getClusterId()).getClusterName();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage());
            }
            WidgetResourceProvider.setResourceProperty(resource, WIDGET_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final Set<Map<String, Object>> propertyMaps = request.getProperties();
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                for (Map propertyMap : propertyMaps) {
                    Long id;
                    try {
                        id = Long.parseLong(propertyMap.get(WIDGET_ID_PROPERTY_ID).toString());
                    }
                    catch (Exception ex) {
                        throw new OBDPException("Widget should have numerical id");
                    }
                    WidgetEntity entity = widgetDAO.findById(id);
                    if (entity == null) {
                        throw new ObjectNotFoundException("There is no widget with id " + id);
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_WIDGET_NAME_PROPERTY_ID)))) {
                        entity.setWidgetName(StringEscapeUtils.escapeHtml4((String)propertyMap.get(WIDGET_WIDGET_NAME_PROPERTY_ID).toString()));
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_WIDGET_TYPE_PROPERTY_ID)))) {
                        entity.setWidgetType(propertyMap.get(WIDGET_WIDGET_TYPE_PROPERTY_ID).toString());
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_METRICS_PROPERTY_ID)))) {
                        entity.setMetrics(gson.toJson(propertyMap.get(WIDGET_METRICS_PROPERTY_ID)));
                    }
                    entity.setAuthor(WidgetResourceProvider.this.getAuthorName(propertyMap));
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_DESCRIPTION_PROPERTY_ID)))) {
                        entity.setDescription(StringEscapeUtils.escapeHtml4((String)propertyMap.get(WIDGET_DESCRIPTION_PROPERTY_ID).toString()));
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_SCOPE_PROPERTY_ID)))) {
                        String clusterName;
                        String scope = propertyMap.get(WIDGET_SCOPE_PROPERTY_ID).toString();
                        if (!WidgetResourceProvider.this.isScopeAllowedForUser(scope, clusterName = propertyMap.get(WIDGET_CLUSTER_NAME_PROPERTY_ID).toString())) {
                            throw new OBDPException("Only cluster operator can create widgets with cluster scope");
                        }
                        entity.setScope(scope);
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_VALUES_PROPERTY_ID)))) {
                        entity.setWidgetValues(gson.toJson(propertyMap.get(WIDGET_VALUES_PROPERTY_ID)));
                    }
                    HashMap widgetPropertiesMap = new HashMap();
                    for (Map.Entry entry : propertyMap.entrySet()) {
                        if (!PropertyHelper.getPropertyCategory((String)entry.getKey()).equals(WIDGET_PROPERTIES_PROPERTY_ID)) continue;
                        widgetPropertiesMap.put(PropertyHelper.getPropertyName((String)entry.getKey()), entry.getValue());
                    }
                    if (!widgetPropertiesMap.isEmpty()) {
                        entity.setProperties(gson.toJson(widgetPropertiesMap));
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGET_TAG_PROPERTY_ID)))) {
                        entity.setTag(propertyMap.get(WIDGET_TAG_PROPERTY_ID).toString());
                    }
                    widgetDAO.merge(entity);
                }
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<WidgetEntity> entitiesToBeRemoved = new ArrayList<WidgetEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            Long id;
            try {
                id = Long.parseLong(propertyMap.get(WIDGET_ID_PROPERTY_ID).toString());
            }
            catch (Exception ex) {
                throw new SystemException("Widget should have numerical id");
            }
            WidgetEntity entity = widgetDAO.findById(id);
            if (entity == null) {
                throw new NoSuchResourceException("There is no widget with id " + id);
            }
            entitiesToBeRemoved.add(entity);
        }
        for (WidgetEntity entity : entitiesToBeRemoved) {
            if (entity.getListWidgetLayoutUserWidgetEntity() != null) {
                for (WidgetLayoutUserWidgetEntity layoutUserWidgetEntity : entity.getListWidgetLayoutUserWidgetEntity()) {
                    if (layoutUserWidgetEntity.getWidgetLayout().getListWidgetLayoutUserWidgetEntity() == null) continue;
                    layoutUserWidgetEntity.getWidgetLayout().getListWidgetLayoutUserWidgetEntity().remove(layoutUserWidgetEntity);
                }
            }
            widgetDAO.remove(entity);
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private boolean isScopeAllowedForUser(String scope, String clusterName) throws OBDPException {
        if ("USER".equals(scope)) {
            return true;
        }
        return AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, this.getClusterResourceId(clusterName), EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_WIDGETS));
    }

    private String getAuthorName(Map<String, Object> properties) {
        if (StringUtils.isNotBlank((String)ObjectUtils.toString((Object)properties.get(WIDGET_AUTHOR_PROPERTY_ID)))) {
            return properties.get(WIDGET_AUTHOR_PROPERTY_ID).toString();
        }
        return this.getManagementController().getAuthName();
    }

    static {
        gson = new GsonBuilder().enableComplexMapKeySerialization().disableHtmlEscaping().serializeNulls().setPrettyPrinting().registerTypeAdapter(String.class, (Object)new JsonSerializer<String>(){

            public JsonElement serialize(String src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(StringEscapeUtils.escapeHtml4((String)src));
            }
        }).create();
    }

    public static enum SCOPE {
        CLUSTER,
        USER;

    }
}

